<?php

/*
 * $Id: 0.8.0beta4_sqlite.php 27 2008-07-30 10:35:30Z trellmor $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

// This is the version of this file, not the version of the next update 
$next_version = '0.8.0RC1';

$querys = array();

$querys[] = "CREATE TABLE " . TABLE_SESSIONS . " (
session_id VARCHAR( 32 ) NOT NULL ,
session_expire INT UNSIGNED NOT NULL ,
session_data TEXT NOT NULL ,
PRIMARY KEY ( session_id )
)";

//$querys[] = "ALTER TABLE " . TABLE_BLOG . " ADD `entry_uri` VARCHAR(36);";
//$querys[] = "ALTER TABLE " . TABLE_BLOG . " DROP INDEX `entry_title`;";

$querys[] = "DROP TABLE " . TABLE_BLOG . ";";

$querys[] = "CREATE TABLE " . TABLE_BLOG . " (
  entry_id INTEGER AUTOINCREMENT,
  user_id int(11) NOT NULL default '1',
  entry_date int(11) default '0',
  entry_title varchar(255) NOT NULL,
  entry_content longtext NOT NULL,
  entry_extended longtext,
  link_id int(11) default '1',
  entry_nofeedback int(1) default '0',
  entry_hidden int(1) default '0',
  entry_uri varchar(36),
  comment_number int(11),
  PRIMARY KEY  (entry_id)
);";

$sql = "SELECT * FROM " . TABLE_BLOG . ";";
$res = $db->query( $sql );
while( $row = $db->fetch( $res ) ) {
	$querys[] = "INSERT INTO " . TABLE_BLOG . " (
 entry_id,
 user_id,
 entry_date,
 entry_title,
 entry_content,
 entry_extended,
 link_id,
 entry_nofeedback,
 entry_hidden,
 comment_number
) VALUES (
 '" . $db->escape( $row['entry_id'] ) . "',
 '" . $db->escape( $row['user_id'] ) . "',
 '" . $db->escape( $row['entry_date'] ) . "',
 '" . $db->escape( $row['entry_title'] ) . "',
 '" . $db->escape( $row['entry_content'] ) . "',
 '" . $db->escape( $row['entry_extended'] ) . "',
 '" . $db->escape( $row['link_id'] ) . "',
 '" . $db->escape( $row['entry_nofeedback'] ) . "',
 '" . $db->escape( $row['entry_hidden'] ) . "',
 '" . $db->escape( $row['comment_number'] ) . "' 
);";
}

$querys[] = "INSERT INTO " . TABLE_CONFIG . " ( config_name, config_value ) VALUES ( 'comment_allowed_html', 'a,b,i,u,strike,blockquote,code,br,p,strong,pre' );";

$querys[] = "UPDATE
 " . TABLE_CONFIG . "
SET
 config_value = '0'
WHERE
 config_name = 'mod_rewrite';";

$querys[] = "UPDATE
 " . TABLE_CONFIG . "
SET
 config_value = '" . $db->escape( $next_version ) . "'
WHERE
 config_name = 'version';";

$sql = "SELECT entry_id, entry_title FROM " . TABLE_BLOG . " ORDER BY entry_id ASC;";
$res = $db->query( $sql );
$uris = array();
while( $row = $db->fetch( $res ) ) {
	// max 32 chars + 4 for number if a title is there multiple times =  36 chars maximum
	$uri = substr( $row['entry_title'], 0, 32 );
	$final_uri = $uri;
	$i = 1;
	if( empty( $final_url ) ) $final_url = $i = 1;
	//$sql = "SELECT entry_id FROM " . TABLE_BLOG . " WHERE entry_uri = '" . $db->escape( $final_uri );
	//$send_sql = $sql . "';";
	while( in_array( $final_uri, $uris ) ) {
		$i++;
		$final_uri = $uri . $i;
		//$send_sql = $sql . (int)$i . "';";
	}
	$uris[] = $final_uri;
	$querys[] = "UPDATE " . TABLE_BLOG . " SET entry_uri = '" . $db->escape( $final_uri ) . "' WHERE entry_id = '" . (int)$row['entry_id'] . "';";
	//$db->query( $sql );
}

?>