<?php

/**
 * yabs - Yet another blog system
 * ==============================
 * (c) 2005 - 2007 by Daniel Triendl <daniel@tac-ops.net>
 * http://yabs.tac-ops.net
 */

/**
 * name		index.php
 * begin	May 11, 2005
 * 
 * $Id: index.php 61 2009-12-21 16:41:58Z trellmor $
 */

/**
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

define( 'INSIDE', true );

require('./includes/init.php');

// Init template
$tpl = new template('./templates/' . $config['template']);	

if( file_exists( './templates/' . $config['template'] . '/template.php' ) ) {
	include( './templates/' . $config['template'] . '/template.php' );
}
$tpl->add( 'header.tpl' );
$plug->runhook( 'hook_index_site_load' );
if( isset( $_GET['site'] ) AND isset( $site[$_GET['site']] ) ) {
	require( $site[$_GET['site']] );
} else {
	require( $site['default'] );
}

	
//Add footer
$tpl->add( 'footer.tpl' );

$tpl->part_seperate( 'E_SIDEBAR' );

$plug->runhook( 'hook_index_sidebar' );

$tpl->part_unite();

// Menu
$sql = "SELECT
			menu_name,
			menu_url
		FROM
			" . TABLE_MENU . "
		ORDER BY
			menu_order ASC;";
$res = $db->query( $sql );
$tpl->part_seperate( 'E_MENU' );
$first = true;
while( $row = $db->fetch( $res ) ) {
	$tpl->part_load();
	if( 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] == $row['menu_url'] && !$first) {
		$tpl->fillin_array( array(
			'S_MENU_SELECTED' => 'id="selected"',
			'S_MENU_SELECTED_FIRST' => '',
		) );
	} else {
		if( $first ) {
			$first = false;
			$tpl->fillin( 'S_MENU_SELECTED', 'id="selected"' );
		} else {
			$tpl->fillin( 'S_MENU_SELECTED', '' );
		}
	}
	$tpl->fillin( 'S_MENU_NAME', $row['menu_name'] );
	$tpl->fillin( 'L_MENU_URL', $row['menu_url'] );
}
$tpl->part_unite();
$db->free( $res );

$feed_entries = site_true_home();
if( $config['mod_rewrite'] ) {
	$feed_entries .= '/feed/';
} else {
	$feed_entries .= '/feed.php';
}

yabs_headers( '<link href="' . $feed_entries .'" type="application/atom+xml" rel="feed" title="feed" />' );

$plug->runhook( 'hook_index_preoutput' );

if( isset( $_SERVER['HTTP_ACCEPT'] ) && stristr( $_SERVER['HTTP_ACCEPT'], "application/xhtml+xml" ) ) {
	$ctype = 'application/xhtml+xml';
} else {
	$ctype = 'text/html';
}

//Fillin some vars
$tpl->fillin_array( array(
	'S_BLOG_TITLE' => html2txt( $config['blog_title'] ), // S_BLOG_TITLE may be changed to e.g. the title of the selected entry
	'S_SITE_TITLE' => html2txt( $config['blog_title'] ),
	'S_BLOG_SUBTITLE' => html2txt( $config['blog_subtitle'] ),
	'S_QUERYNUM' => $db->status( 'querynum' ),
	'L_HOME' => url(),
	'L_TRUE_HOME' => site_true_home(),
	'S_ADMINPANEL' => '<a href="' . site_true_home() . '/admin.php">' . $lang['adminpanel'] . '</a>',
	'S_FEED_ENTRIES' => '<a href="' . $feed_entries . '">' . $lang['entries'] . '</a>',
	'L_FEED_ENTRIES' => $feed_entries,
	'S_HEADERS' => yabs_headers(),
	'S_CHARSET' => $lang['charset'],
	'S_CONTENT_TYPE' => $ctype,
	'S_LANG_SHORT' => $lang['lang_short'],
) );
	
//Calcualte Rendertime	
$rendertime = round( array_sum( explode( ' ', microtime() ) ) - $rendertime_start, 4 );
$tpl->fillin( 'S_RENDER_FILLIN', $rendertime );
	
// +-----------------------------------------------------+
// | Send Header                                         |
// +-----------------------------------------------------+
if( !headers_sent() ) {
	header( 'Cache-control: private, pre-check=0, post-check=0, max-age=0' );
	header( 'Pragma: no-cache' );
	header( 'Expires: 0' );
	header( 'Vary: Accept' );
	header( 'Content-Type: ' . $ctype . '; charset=' . $lang['charset'] );
}

$plug->runhook( 'hook_index_output' );

$tpl->output();

session_write_close(); // This is required at the end of every standalone script, oterwise your session data won't be saved.
$db->disconnect(); // And especially important: close mysql __after__ session_write_close.

?>
