<?php

/*
 * name		functions.php
 * begin	May 11, 2005
 * 
 * $Id: functions.php 45 2009-11-20 22:55:11Z Trellmor $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if ( !function_exists( 'time_utc' ) ) {
	function time_utc( $timestamp = false )
	{
		if( $timestamp === false ) {
			return time() - date( 'Z' );
		} else {
			global $config;
			return $timestamp - ( $config['time_offset'] * 3600 );
		}
	}
}

if ( !function_exists( 'time_local' ) ) {
	function time_local( $timestamp = false )
	{
		global $config;
		if( $timestamp === false ) $timestamp = time_utc();
		return $timestamp + ( $config['time_offset'] * 3600 );
	}
}

if ( !function_exists( 'time_lokal' ) ) {
	function time_lokal( $timestamp = false )
	{
		return time_local( $timestamp );
	}
}

if ( !function_exists( 'url' ) ) { 
	function url( $querys = array(), $use_amp = true )
	{
		global $config;
		$url = "http://".$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);
		if(substr($url, strlen($url)-1, 1) != '/') $url .= "/";
		
		// Session id
		if( !$config['mod_rewrite'] && ( $sid = get_sid() ) !== false ) {
			$querys['sid'] = $sid;
		} 
		if( count( $querys ) > 0 ) {
			if( $config['mod_rewrite'] ) {
				if( !empty( $querys['site'] ) ) {
					$url .= $querys['site'] . '/';
					if( !empty( $querys[$querys['site']] ) ) {
						$url .= $querys[$querys['site']] . '/';
						$querys[$querys['site']] = '';
					}
					$querys['site'] = '';
				} else {
					$url .= 'blog/';
				}
				
				foreach( $querys as $key => $val ) {
					if( !empty( $val ) ) {
						$url .= $key . '/' . $val . '/';
					}
				}
			}else{
				$query = "?";
				foreach($querys as $name => $value){
					if($use_amp){
						$query .= $name."=".$value."&amp;";
					}else{
						$query .= $name."=".$value."&";
					}
				}
				if($use_amp) $query = substr($query, 0, strlen($query)-5);
				else $query = substr($query, 0, strlen($query)-1);
				$url .= $query;
			}
		}
		
		// Session id
		if( ( $config['mod_rewrite'] && $sid = get_sid() ) !== false ) {
			$url .= '?sid=' . $sid;
		} 
		return $url;
	}
}

if( !function_exists( 'get_sid' ) ) {
	function get_sid() {
		global $config;
		// Only append if config key not set or true
		if( isset( $config['sid'] ) && $config['sid'] == false ) return false;
		// Only append if cookie ain't set
		if( !empty( $_COOKIE['PHPSESSID'] ) ) return false;
		// You can add more bot agents here if you want
		// They should all be lowsercase, too!
		$agents = array( 'excite', 'googlebot', 'yahoo', 'msnbot', 'nutch', 'tailrank', 'baidu', 'feedburner' );
		// Whoa? sometimes HTTL_USER_AGENT is not defined?
		$ref = ( isset( $_SERVER['HTTP_USER_AGENT'] ) ) ? strtolower( $_SERVER['HTTP_USER_AGENT'] ) : '';
		foreach( $agents as $agent ) {
			if( strpos($ref, $agent) !== false ) {
					// We got a bot, so don't append sid
					return false;
			}
		}
		// neither cookie nor bot, so lets see if we have a active session
		if( session_id() == '' ) return false; // no session active
	
		// yey, no cookie set, no but and we have a active session, lets return the session id
		return session_id(); 
	}
}

if ( !function_exists( 'aurl' ) ) {
	function aurl($querys = array(), $use_amp = true)
	{
		$url = 'admin.php';
		$url .= '?';

		// Session id
		if( ( $sid = get_sid() ) !== false ) {
			$querys['sid'] = $sid;
		}
		if(count($querys)){
			foreach($querys as $var => $arg){
				$url .= $var . '=' . $arg;
				if($use_amp) $url .= '&amp;';
				else $url .= '&';
			}
		}
		return $url;
	}
}
	
if( !function_exists('make_get') ) {
	function make_get()
	{
		$request = $_SERVER['REQUEST_URI'];
		if( substr( $request, strlen( $request ) - 2, 1 ) != '/' ) $request .= '/';
		// Strip away the dir
		if( dirname( $_SERVER['PHP_SELF'] ) != '/' ) {
			$request = str_replace( dirname( $_SERVER['PHP_SELF'] ), '', $request );
		}
		$request = explode( '/', substr( $request, 1 ) );
		
		if( isset( $request[0] ) ) {
			$_GET['site'] = $request[0];	
		}
		
		for( $i = 0; $i < count( $request ); $i++ ) {
			if( isset( $request[$i + 1] ) && isset( $request[$i] ) ) {
				$_GET[$request[$i]] = $request[$i + 1];
			}
		}
	}
}

if ( !function_exists( 'site_true_home' ) ) {
	function site_true_home( $strip = 0 )
	{
		$url = "http://".$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);
		if(substr($url, strlen($url)-1, 1) == '/') $url = substr($url, 0, strlen($url)-1);
		$url = explode( '/', $url );
		$strip = count( $url ) - $strip;
		for( $i = count( $url ); $i >= $strip; $i-- ) {
			unset( $url[$i] );
		}
		$url = implode( '/', $url );
		return $url;
	}
}
	
if ( !function_exists( 'checkmail' ) ) {
	function checkmail( $mail )
	{
	    return preg_match( "/^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/", $mail );
	} 
}

if ( !function_exists( 'html2txt' ) ) {
	// Thanks uersoy at tnn dot net and admin at automapit dot com 
	// http://php.net/strip_tags
	function html2txt ( $str )
	{
		global $lang;
		$search = array( '@<script[^>]*?>.*?</script>@si',  // Strip out javascript
		                 '@<style[^>]*?>.*?</style>@siU',    // Strip style tags properly
		                 '@<[\/\!]*?[^<>]*?>@si',            // Strip out HTML tags
		                 '@<![\s\S]*?--[ \t\n\r]*>@'        // Strip multi-line comments including CDATA
		);
		$str = preg_replace( $search, '', $str );
		return htmlentities( $str, ENT_COMPAT, $lang['charset'] );
	}
}

function cutStr255 ( $str ) {
	return substr( $str, 0, 255 );
}

if ( !function_exists( 'object2array' ) ) {
	function object2array($object)
	{
		$return = NULL;
	    
		if ( is_array( $object ) ) {
			foreach ( $object as $key => $value ) {
	           $return[$key] = object2array( $value );
			}
		} else {
			$var = get_object_vars( $object );
			if ( $var ) {
				foreach( $var as $key => $value ) {
					$return[$key] = object2array( $value );
				}
			} else {
				$return = strval( $object ); // strval and everything is fine
			}
		}
		return $return;
	}
}

/*
 * Writes content to a file
 * 
 * $f		The filename
 * $limiter	String or array
 * 			Used to identify the block.
 * 			String - start and end delimiter are the same
 * 			Array - index start and end contain the start and the end delimiter
 * $string	The block that should be written to the file
 * $top		If the block don't exist yet, it will be written to the top of the
 * 			file if if this is 1, otherwise to the end.
 * 			Default 0
 */
if( !function_exists( 'yabs_file_write' ) ) {
	// limiter can either be a string or an array with 2 keys: start, end
	function yabs_file_write( $f, $limiter, $string, $top = 0 )
	{
		clearstatcache();
		if( !file_exists( $f ) ) {
			if( file_exists( dirname( $f ) ) && is_writeable( dirname( $f ) ) ) {
				$fo = fopen( $f, 'w' );
				fclose( $fo );
			} else {
				return false;
			}
		}
		if( !is_writeable( $f ) ) return false;
		if( filesize( $f ) ) {
			$fo = fopen( $f, 'r' );
			$fc = fread( $fo, filesize( $f ) );
			fclose( $fo );
		} else {
			$fc = '';
		}
		
		if( is_array( $limiter ) ) {
			$fc = explode( $limiter['start'], $fc );
			if( !isset( $fc[1] ) ) $fc[1] = '';
			
			$fc1 = explode( $limiter['end'], $fc[1] );
			if( !isset( $fc1[1] ) ) {
				$fc1[1] = $fc1[0];
				$fc1[0] = '';
			}
			$fc[1] = $fc1[0];
			$fc[2] = $fc1[1];
		} else {
			$fc = explode( $limiter, $fc );
			if( !isset( $fc[1] ) ) $fc[1] = '';
			if( !isset( $fc[2] ) ) $fc[2] = '';
			$limiter = array( 'start' => $limiter, 'end' => $limiter );
		}
		
		if( $top == 1 && empty( $fc[1] ) && empty( $fc[2] ) ) {
			$fc[2] = $fc[0];
			$fc[0] = '';
		}
		
		if( !empty( $string ) ) {
			if( !empty( $fc[0] ) ) {
				$fc[0] = trim( $fc[0] ) . "\n" . $limiter['start'] . "\n";
			} else {
				$fc[0] = $limiter['start'] . "\n";
			}
			if( !empty( $fc[2] ) ) {
				$fc[2] = "\n" . $limiter['end'] . "\n" . trim( $fc[2] );
			} else {
				$fc[2] = "\n" . $limiter['end'];
			}
		}
		
		if( !empty( $string ) ) $fc[1] = $string;
		else $fc[1] = '';
		$fc = implode( '', $fc );
		if( empty( $fc ) ) $fc = '';
		$fo = fopen( $f, 'w' );
		fwrite( $fo, $fc );
		fclose( $fo );
		return true;
	}
}

if( !function_exists( 'yabs_headers' ) ) {
	// Append head html data
	// call w/o argument to return all current head data
	function yabs_headers( $header = '' )
	{
		static $headers = '';
		
		if( empty( $header ) ) {
			return $headers;
		}
		
		$headers .= "\n" . $header;
	}
}

if( !function_exists( 'str_urlsafe' ) ) {
	function str_urlsafe( $str )
	{
		$return = '';
		for( $i = 0; $i < strlen( $str ); $i++ ) {
			$c = substr( $str, $i, 1 );
			// Space, A-Z, a-z
			if( ord( $c ) == 32 || ( ord( $c ) >= 65 && ord( $c ) <= 90 ) || ( ord( $c ) >= 97 && ord( $c ) <= 122 ) ) {
				$return .= c;
			}
		}
		return str_replace( ' ', '_', $return );
	}
}

if( !function_exists( 'yabs_redirect' ) ) {
	function yabs_redirect( $url, $text, $additional = '', $header = 1 )
	{
		if( !headers_sent() && $header ) {
			session_write_close();
			header( 'Location: ' . str_replace( '&amp;', '&', $url ) );
		}
		
		if( $header === 2 ) {
			if( !( !headers_sent() && $header ) ) {
				session_write_close();
			}
			die( '<a href="' . $url . '">' . $text . '</a>' );
		}
		
		global $tpl;
		$tpl->add( 'empty.tpl' );
		if( !empty( $additional ) ) $additional .= '<br />';
		$tpl->fillin( 'S_CONTENT', $additional . '<a href="' . $url . '">' . $text . '</a>' );
	}
}

?>
