<?php

/*
 * name		class.socketconnect.php
 * begin	July 24, 2008
 * 
 * $Id: class.socketconnect.php 39 2009-04-05 19:33:37Z trellmor $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class connection
{
	protected $url = '';
	protected $socket = null;

	protected function connect( $url )
	{
		if ( is_resource( $this->socket ) ) {
			fclose( $this->socket );
		}
		$url = parse_url( $url );

		if( isset( $url['scheme'] ) && $url['scheme'] == 'https' ) {
			$url['conhost'] = 'ssl://' . $url['host'];
			if( !isset( $url['port'] ) ) $url['port'] = 443;
		} else {
			$url['conhost'] = $url['host'];
			if( !isset( $url['port'] ) ) $url['port'] = 80;
		}
		$this->socket = @fsockopen( $url['conhost'], $url['port'], $errno, $error, 2 );

		if ( !is_resource( $this->socket ) ) {
			return false;
		}
		
		$url['query'] = ( !empty( $url['query'] ) ) ? '?' . $url['query'] : '';
		$url['path'] = ( !empty( $url['path'] ) ) ? $url['path'] . $url['query'] : '/' . $url['query'];
		
		$this->write( 'GET ' . $url['path'] . ' HTTP/1.1' . "\r\n");
		$this->write( 'Host: ' . $url['host'] . "\r\n" );
		$this->write( 'User-agent: Mozilla/5.0 (compatible; yabs; http://yabs.tac-ops.net)' . "\r\n");
		$this->write( 'Connection: Close' . "\r\n\r\n" );
		
		return true;
	}
	
	public function write( $data )
	{
		if( is_resource( $this->socket ) ) {
			//echo "Writing " . $data;
			fwrite( $this->socket, $data );
		}
	}
	
	protected function getData()
	{
		if ( is_resource( $this->socket ) ) {
			$data = '';
			$i = 512;
			stream_set_timeout( $this->socket, 3 );
			while ( !feof( $this->socket ) && $i > 0 ) {
				$buffer = fread( $this->socket, 1024 );
				$info = stream_get_meta_data( $this->socket );
				$data .= $buffer;
				$i++;
				if( $info['timed_out'] ) break;
			}
			// Chunked?
			if( strpos( substr( $data, 0, strpos( $data, "\r\n\r\n" ) ), "Transfer-Encoding: chunked" ) !== false ) {
				$data = substr( $data, strpos( $data, "\r\n\r\n" ) + 4 );
				$return = '';
				while( $data ) {
					// Get chunk length
					$chunk = substr( $data, 0, strpos( $data, "\r\n" ) );
					// Return is chunk size minus the chunk definition + \r\n
					$return .= substr( $data, strlen( $chunk ) + 2, hexdec( $chunk ) );
					
					// New data is everything minus chunk + chunk definition + \r\n\r\n
					$data = substr( $data, hexdec( $chunk ) + strlen( $chunk ) + 4 );
				}
				return $return;
			} else {
				return trim( substr( $data, strpos( $data, "\r\n\r\n" ) + 4 ) );
			}
		} else {
			return false;
		}
	}
	
	protected function disconnect()
	{
		if( is_resource( $this->socket ) ) {
			fclose( $this->socket );
		}
	}
}

?>