<?php
/*
 * name		categories.php
 * begin	December 21, 2009
 *
 * $Id: categories.php 60 2009-12-21 16:31:13Z trellmor $
 * 
 * This shares a lot of it's code with admin/links.php, if you fix a error here
 * also check admin/links.php
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if( $user->getRight('categories' ) ) {
	
	switch( @$_GET['action'] ){
		case 'edit':
			if( isset( $_POST['link_save'] ) ) {
				if( !empty( $_POST['link_name'] ) ) {
					if( isset( $_GET['link_id'] ) && is_numeric( $_GET['link_id'] ) && $_GET['link_id'] != -1 ) {
						$sql = "SELECT link_id FROM " . TABLE_LINKS . " WHERE link_id = '" . $db->escape( $_GET['link_id'] ) . "';";
						$res = $db->query( $sql );
						if( $db->numrows( $res ) ) {
							$sql = "SELECT link_id FROM " . TABLE_LINKS . " WHERE link_name = '" . $db->escape( $_POST['link_name'] ) . "' and link_url = '' and link_id != '" . $db->escape($_GET['link_id']) . ";";
							$res = $db->query( $sql );
							if( !$db->numrows( $res ) ) {
								$sql = "UPDATE " . TABLE_LINKS . " SET link_name = '" . $db->escape( $_POST['link_name'] ) . "'";
								$sql .= ", link_url = ''";
								$sql .= " WHERE link_id = '" . $db->escape( $_GET['link_id'] ) . "';";
								$db->query( $sql );
								$continue_url = array( 'site' => 'categories', 'action' => 'list' );
								$plug->runhook( 'hook_admin_link_saved' );
								yabs_redirect( aurl( $continue_url ), $lang['continue'] );
							} else {
								$tpl->add( 'empty.tpl' );
								$tpl->fillin( 'S_CONTENT', $lang['admin_error_category_name_inuse'] . $lang['back'] );
							}
						} else {
							$tpl->add( 'empty.tpl' );
							$tpl->fillin( 'S_CONTENT', $lang['admin_error_category_notfound'] . $lang['back'] );
						}
						$db->free( $res );
					} else {
						$sql = "SELECT link_id FROM " . TABLE_LINKS . " WHERE link_name = '" . $db->escape( $_POST['link_name'] ) . "' and link_url = '';";
						$res = $db->query( $sql );
						if( !$db->numrows( $res ) ) {
							if( empty( $_POST['link_url'] ) ) $_POST['link_url'] = '';
							$sql = "INSERT INTO " . TABLE_LINKS . " ( link_name, link_url ) VALUES ( '" . $db->escape( $_POST['link_name'] ) . "', '' );";
							$db->query( $sql );
							$continue_url = array( 'site' => 'categories', 'action' => 'list' );
							$plug->runhook( 'hook_admin_link_saved' );
							yabs_redirect( aurl( $continue_url ), $lang['continue'] );
						} else {
							$tpl->add( 'empty.tpl' );
							$tpl->fillin( 'S_CONTENT', $lang['admin_error_category_name_inuse'] . $lang['back'] );
						}
					}
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['error_name'] . $lang['back'] );
				}
			}  else {
				$link = array();
				$link['link_id'] = -1;
				$link['link_url'] = "";
				$link['link_name'] = "";
				if( isset( $_GET['link_id'] ) && is_numeric( $_GET['link_id'] ) ) {
					$sql = "SELECT
								link_id,
								link_name,
								link_url
							FROM
								" . TABLE_LINKS . "
							WHERE
								link_id = '" . $db->escape( $_GET['link_id'] ) . "';";
					$res = $db->query( $sql );
					if( $db->numrows( $res ) ) {
						$link = $db->fetch( $res );
					}
					$db->free( $res );
				}	
				$tpl->add( 'link_form.tpl' );
				$tpl->part_seperate( 'E_LINK_FORM' );
				$tpl->part_load();
				$tpl->fillin_array( array(
					'S_LINK_FORM' => $lang['name'],
					'I_LINK_FORM' => '<input type="text" name="link_name" value="' . $link['link_name'] . '" size="50" />',
				) );
				$tpl->part_unite();
				
				$url = array( 'site' => 'categories', 'link_id' => $link['link_id'], 'action' => 'edit' );
				$tpl->fillin_array( array(
					'L_LINK_ACTION' => aurl( $url ),
					'I_LINK_FORM_SUBMIT' => '<input type="submit" name="link_save" value="' . $lang['save'] .'" />',
				) );
			}
			break;
		case 'delete':
			if ( isset( $_GET['link_id'] ) && is_numeric( $_GET['link_id'] ) ) {
				if ( isset( $_GET['yabsonce'] ) && $_GET['yabsonce'] == $user->getOnce() ) {
					$sql = "DELETE FROM " . TABLE_LINKS . " WHERE link_id = '" . $db->escape( $_GET['link_id'] ) . "';";
					$db->query( $sql );
					$plug->runhook( 'hook_admin_link_deleted' );
					$continue_url = array( 'site' => 'categories' ); 
					yabs_redirect( aurl( $continue_url ), $lang['continue'] );
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_invalid_category'] . $lang['back'] );
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_category_notfound'] . $lang['back'] );
			}
			break;
		case 'list':
		default:
			$tpl->add( 'links_list.tpl' );
			$sql = "SELECT
						link_id,
						link_name,
						link_url
					FROM
						" . TABLE_LINKS . "
					WHERE
						link_url = ''
					ORDER BY link_name ASC;";
			$res = $db->query( $sql, __LINE__, __FILE__ );
			$tpl->part_seperate( 'E_LINKS' );
			$url = array( 'site' => 'categories' );
			$i = 0;
			while( $row = $db->fetch( $res ) ) {
				$tpl->part_load();
				if ( $i == 0 ) {
					$css_table_row = 'yabs_table_row_dark';
					$i = 1;
				} else {
					$css_table_row =  'yabs_table_row_light';
					$i = 0;
				}
				$url['link_id'] = $row['link_id'];
				$edit_url = $url;
				$edit_url['action'] = 'edit';
				$delete_url = $url;
				$delete_url['action'] = 'delete';
				$delete_url['yabsonce'] = $user->getOnce();
				$view_url = array( 'site' => 'category', 'category' => urlencode( $row['link_name'] ) );
				$tpl->fillin_array( array(
					'L_LINK_EDIT_LINK' => aurl( $edit_url ),
					'L_LINK_DELETE_LINK' => aurl( $delete_url ),
					'S_CSS_TABLE_ROW' => $css_table_row,
					'S_LINK_NAME' => $row['link_name'],
					'L_LINK_VIEW_LINK' => url($view_url),
				) );
			}
			$tpl->part_unite();
			$url = array( 'site' => 'categories', 'action' => 'edit' );
			$tpl->fillin_array( array(
				'I_LINK_DELETE_CONFIRM' => 'onclick="return confirm(\'' . $lang['admin_category_delete_question'] . '\')""',
				'S_LINK_DELETE_TEXT' => $lang['delete'],
				'S_LINK_EDIT_TEXT' => $lang['edit'],
				'S_LINK_NAME_TEXT' => $lang['name'],
				'S_LINK_NEW' => $lang['admin_category_new'],
				'L_LINK_NEW' => aurl( $url ),
			) );
			break;
	}
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}

?>