<?php

/*
 * $Id:install_php 101 2007-08-12 16:20:56Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

$querys = array();

$querys[] = "CREATE TABLE `" . TABLE_BLOG . "` (
  `entry_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '1',
  `entry_date` int(11) NOT NULL default '0',
  `entry_title` varchar(255) NOT NULL,
  `entry_content` longtext NOT NULL,
  `entry_extended` longtext NOT NULL,
  `link_id` int(11) NOT NULL default '1',
  `entry_nofeedback` int(1) NOT NULL default '0',
  `entry_hidden` int(1) NOT NULL default '0',
  `comment_number` int(11) NOT NULL,
  PRIMARY KEY  (`entry_id`),
  UNIQUE KEY `entry_title` (`entry_title`)
);";

$querys[] = "INSERT INTO `" . TABLE_BLOG . "` (`user_id`, `entry_date`, `entry_title`, `entry_content`, `link_id`) VALUES
('1', '" . time_utc() . "', 'Welcome to your blog!', 'This is your first entry. Login to the <a href=\"admin.php\">Adminpanel</a> to start blogging.<br /><br />We hope you will enjoy your new blog.',  '1');";

$querys[] = "CREATE TABLE `" . TABLE_COMMENTS . "` (
  `comment_id` int(11) NOT NULL auto_increment,
  `entry_id` int(11) NOT NULL default '0',
  `comment_author_name` varchar(30) NOT NULL,
  `comment_author_mail` varchar(50) NOT NULL,
  `comment_title` varchar(255) NOT NULL,
  `comment_content` text NOT NULL,
  `comment_author_ip` varchar(15) NOT NULL,
  `comment_author_hostname` varchar(255) NOT NULL,
  `comment_author_url` varchar(75) NOT NULL,
  `comment_date` int(11) NOT NULL default '0',
  `comment_active` int(1) NOT NULL default '0',
  `comment_spam` int(1) NOT NULL default '0',
  `comment_crypt` varchar(32) NOT NULL,
  PRIMARY KEY  (`comment_id`)
);";

$querys[] = "CREATE TABLE `" . TABLE_CONFIG . "` (
  `config_name` varchar(255) NOT NULL default '',
  `config_value` varchar(255) NOT NULL default ''
);";

$querys[] = "INSERT INTO `" . TABLE_CONFIG . "` (`config_name`, `config_value`) VALUES 
('language', 'german'),
('template', 'CrystalX'),
('blog_title', ''),
('blog_subtitle', ''),
('limit_blog_entries', '5'),
('time_offset', '0'),
('time_format', '%m-%d-%Y %H:%M'),
('activate_comments', '1'),
('accept_trackback', '1'),
('version', '" . $yabs_installer_version . "'),
('mod_rewrite', '0'),
('delete_spam', '-1');";

$querys[] = "CREATE TABLE `" . TABLE_LINKS . "` (
  `link_id` int(11) NOT NULL auto_increment,
  `link_name` varchar(255) NOT NULL,
  `link_url` varchar(255) NOT NULL,
  PRIMARY KEY  (`link_id`)
);";

$querys[] = "INSERT INTO `" . TABLE_LINKS . "` (`link_name`, `link_url`) VALUES 
('Default', ''),
('Dani Bloggt!', 'http://dani.tac-ops.net'),
('yabs', 'http://yabs.tac-ops.net');";

$querys[] = "CREATE TABLE `" . TABLE_MENU . "` (
  `menu_id` tinyint(4) NOT NULL auto_increment,
  `menu_name` varchar(255) NOT NULL,
  `menu_url` varchar(255) NOT NULL,
  `menu_order` tinyint(4) NOT NULL,
  PRIMARY KEY  (`menu_id`)
);";

$querys[] = "INSERT INTO `" . TABLE_MENU . "` (`menu_name`, `menu_url`, `menu_order`) VALUES 
('Home', 'http://" . $_SERVER['HTTP_HOST'] . substr( dirname( $_SERVER['PHP_SELF'] ), 0, strlen( dirname( $_SERVER['PHP_SELF'] ) )-7 ) . "', 1);";

$querys[] = "CREATE TABLE `" . TABLE_PLUGINS . "` (
  `plugin_name` varchar(255) NOT NULL,
  `plugin_version` varchar(8) NOT NULL,
  UNIQUE KEY `name` (`plugin_name`)
);";

$querys[] = "CREATE TABLE `" . TABLE_USER . "` (
  `user_id` int(11) NOT NULL auto_increment,
  `user_name` varchar(255) NOT NULL,
  `user_password` varchar(32) NOT NULL,
  `user_mail` varchar(255) NOT NULL,
  `user_cookie` varchar(32) NOT NULL,
  `user_ip` varchar(15) NOT NULL,
  `user_session` varchar(32) default NULL,
  PRIMARY KEY  (`user_id`),
  UNIQUE KEY `user_name` (`user_name`)
);";

$querys[] = "CREATE TABLE `" . TABLE_USER_CONFIG . "` (
  `user_id` int(11) NOT NULL,
  `user_config_name` varchar(255) NOT NULL,
  `user_config_value` varchar(255) NOT NULL,
  `user_permission` tinyint(1) NOT NULL,
  KEY `user_id` (`user_id`)
);";

$querys[] = "INSERT INTO `" . TABLE_USER_CONFIG . "` (`user_id`, `user_config_name`, `user_config_value`, `user_permission`) VALUES 
(1, 'use_wysiwyg', '1', '0'),
(1, 'user', '', '1'),
(1, 'settings', '', '1'),
(1, 'links', '', '1'),
(1, 'plugins', '', '1'),
(1, 'entry_other', '', '1'),
(1, 'comments', '', '1'),
(1, 'entry', '', '1'),
(1, 'fm_upload', '', '1'),
(1, 'fm_modify', '', '1');";


?>
