<?php

/*
 * name		class.socket.php
 * begin	February 09, 2007
 * 
 * $Id: class.socket.php 100 2007-08-11 21:45:03Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class socket{
	
	protected $_socket = null;
		
	public function __construct(  )
	{
		
	}
		
	public function connect( $url, $port=80, $timeout=1 )
	{
		if ( is_resource( $this->_socket ) ) {
			fclose( $this->_socket );
		}
		$socket = @fsockopen( $url, $port, $errno, $error, $timeout );
		if ( !is_resource( $socket ) ) {
			return false;
		} else {
			$this->_socket = $socket;
			return true;
		}
	}
		
	public function disconnect()
	{
		if ( is_resource( $this->_socket ) ) {
			fclose( $this->_socket );
			$this->_socket = NULL;
		}
	}
		
	public function read( $size = -1, $timeout = 5 )
	{
		if ( is_resource( $this->_socket ) ) {
			$data = '';
			$i = 0;
			stream_set_timeout( $this->_socket, $timeout );
			while ( !feof( $this->_socket ) && ( $i < $size || $size == -1 ) ) {
				$buffer = fread( $this->_socket, 1024 );
				$info = stream_get_meta_data( $this->_socket );
				if( $info['timed_out'] ) {
					break;
				}
				$data .= $buffer;
				$i++;
			}
			return $data;
		}
	}
		
	public function write( $data )
	{
		if ( is_resource( $this->_socket ) ) {
			fwrite( $this->_socket, $data );
		}
	}
	
}

?>