<?php

/*
 * name		class.plugin.php
 * begin	March 24, 2007
 * 
 * $Id: class.plugin.php 100 2007-08-11 21:45:03Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class plugin {
	
	protected $_filters = array();
	protected $_hooks = array();
	protected $_adminsites = array();
    private static $instance;
	
	private function __construct()
	{
		
	}
	
	public static function singleton()
	{
		if ( !isset( self::$instance ) ) {
			$plugin = __CLASS__;
			self::$instance = new $plugin;
		}
		
		return self::$instance;
	}
	
		public function __clone()
	{
		trigger_error( 'Can\'t clone class ' . __CLASS__ . '.', E_USER_ERROR );
	}
	
	public function runhook( $hook, $arg = '' )
	{
		if ( isset( $this->_hooks[$hook] ) && is_array( $this->_hooks[$hook] ) ) {
			$hrun = $this->_rank( $this->_hooks[$hook] );
			foreach ( $hrun as $call ) {
				if( empty( $arg ) ) {
					eval( $call . '();' );	
				} else {
					eval( $call . '( $arg );' );
				}
			}
		}
	}
	
	public function runfilter( $filter, $arg )
	{
		if ( isset( $this->_filters[$filter] ) && is_array( $this->_filters[$filter] ) ) {
			$frun = $this->_rank( $this->_filters[$filter] );
			foreach ( $frun as $call ) {
				eval( '$arg = ' . $call . '( $arg );');
			}
		}
		return $arg;
	}
	
	protected function _rank( $array )
	{
		krsort( $array );
		$return = array();
		foreach ( $array as $array2 ) {
			foreach( $array2 as $name ) {
				if( !empty( $name) ) {
					$return[] = $name;
				}
			} 
		}
		return $return;
	}
	
	public function addfilter( $filter, $name, $priority = 10 )
	{
		$this->_filters[$filter][$priority][] = $name;
	}
	
	public function addhook( $hook, $name, $priority = 10 )
	{
		$this->_hooks[$hook][$priority][] = $name;
	}
	
	public function removehook( $hook, $name, $priority )
	{
		if( false !== ( $key = array_search( $name, $this->_hooks[$hook][$priority] ) ) ) {
			$this->_hooks[$hook][$priority][$key] = '';
			return true;
		}
		return false;
	}
	
	public function removefilter( $filter, $name, $priority )
	{
		if( false !== ( $key = array_search( $name, $this->_filters[$filter][$priority] ) ) ) {
			$this->_filters[$filter][$priority][$key] = '';
			return true;
		}
		return false;
	}
	
	public function addadminsite( $cat, $link, $location, $text = '', $priority = 10 )
	{
		$this->_adminsites[$cat][$priority][] = array( 'category' => $cat, 'text' => $text, 'link' => $link, 'location' => $location );
	}
	
	public function getadminsites()
	{
		$return = array();
		foreach( $this->_adminsites as $cats ) {
			foreach( $cats as $sites ) {
				foreach( $sites as $site ) {
					$return[$site['link']] = $site['location'];
				}
			}
		}
		return $return;
	}
	
	public function getadmincategory( $cat )
	{
		if( isset( $this->_adminsites[$cat] ) ) {
			return $this->_rank( $this->_adminsites[$cat] );
		} else {
			return array();
		}
	}
	
	public function registerPlugins()
	{
		global $db;
		$sql = "SELECT plugin_name, plugin_version FROM " . TABLE_PLUGINS;
		$res = $db->query( $sql );
		$return = '';
		while( $row = $db->fetch( $res ) ) {
			if( file_exists( './plugins/' . $row['plugin_name'] . '/plugin.php' ) &&
					file_exists( './plugins/' . $row['plugin_name'] . '/plugin.xml' ) ) {
				$plugin = object2array( new SimpleXMLElement( './plugins/' . $row['plugin_name'] . '/plugin.xml', NULL, true ) );
				if ( !empty( $plugin['name'] ) && !empty( $plugin['version'] ) ) {
					if( $plugin['version'] == $row['plugin_version'] ) {
						$return .= 'include_once( \'./plugins/' . $row['plugin_name'] . '/plugin.php\' );' . "\n";
					}
				}
			}
		}
		return( $return );
		$db->free( $res );
	}
	
}

?>