<?php

/*
 * name		comment.php
 * begin	January 14, 2006
 * 
 * $Id: comment.php 99 2007-08-09 12:49:57Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if ( isset( $_GET['entry_id'] ) ) {
	$sql = "SELECT
				entry_id,
				entry_title,
				entry_nofeedback,
				comment_number
			FROM
				" . TABLE_BLOG . "
			WHERE
				entry_id = '" . $db->escape( $_GET['entry_id'] ) . "' and
				entry_hidden = 0 and
				entry_date < '" . time_utc() . "';";
	$res = $db->query( $sql, __LINE__, __FILE__ );
	if ( $db->numrows( $res ) ) {
		$entry = $db->fetch( $res );
		$db->free( $res );
		$comment_error = array();
		
		if ( $entry['entry_nofeedback'] == 0 ) {
			$comment =  $_POST;
			if ( empty( $comment['comment_author_name'] ) ) $comment_error[] = $lang['error_noname'];
			if ( empty( $comment['comment_author_mail'] ) || !checkmail( $comment['comment_author_mail'] ) ) $comment_error[] = $lang['error_mail'];
			if ( empty( $comment['comment_content'] ) ) $comment_error[] = $lang['comment_error_content'];
			if ( empty( $comment['comment_author_url'] ) || !preg_match( '/^(http|https):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,6}((:[0-9]{1,5})?\/.*)?$/i', $comment['comment_author_url'] ) ) $comment['comment_author_url'] = '';
			$comment['spam'] = 0;
			$comment['active'] = $config['activate_comments'];
			$comment['crypt'] = md5( microtime() );
			// To add an error message, use global $comment_error; $comment_error[] = 'error_msg';
			// $comment contains all comment data from post
			// change $comment['spam'] to 1 to mark a comment as spam
			$plug->runhook( 'hook_comment_validating' );
			
			if ( !count( $comment_error ) ) {
				$plug->runhook( 'hook_comment_validated' );
				$sql = "INSERT INTO
							" . TABLE_COMMENTS . "
							(
							 comment_author_name,
							 comment_author_mail,
							 comment_author_url,
							 comment_content,
							 comment_date,
							 entry_id,
							 comment_author_ip,
							 comment_author_hostname,
							 comment_active,
							 comment_spam,
							 comment_crypt
							)
						VALUES
							(
							 '" . $db->escape( $comment['comment_author_name'] ) . "',
							 '" . $db->escape( $comment['comment_author_mail'] ) . "',
							 '" . $db->escape( $comment['comment_author_url'] ) . "',
							 '" . $db->escape( $comment['comment_content'] ) . "',
							 '" .time_utc() . "',
							 '" . $entry['entry_id'] . "',
							 '" . $_SERVER['REMOTE_ADDR'] . "',
							 '" . gethostbyaddr( $_SERVER['REMOTE_ADDR'] ) . "',
							 '" . $comment['active'] . "',
							 '" . $comment['spam'] . "',
							 '" . $comment['crypt'] . "'
						);";
				$db->query( $sql, __LINE__, __FILE__ );
				if ( isset( $comment['comment_remember_values'] ) && $comment['comment_remember_values'] == 'true' ) {
					setcookie('comment_crypt', $comment['crypt'], time_lokal( time_utc() ) + 60*60*24*356, dirname( $_SERVER['PHP_SELF'] ) );
				}
				
				if( !$comment['spam'] && $comment['active'] ) {
					$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . $db->escape( $entry['comment_number'] + 1 ) . "' WHERE entry_id = '" . $entry['entry_id'] . "';";
					$db->query( $sql );
				}
				
				$sql = "SELECT comment_id FROM " . TABLE_COMMENTS . " ORDER BY comment_id DESC LIMIT 0, 1;";
				$res = $db->query( $sql, __LINE__, __FILE__ );
				$comment_written = $db->fetch( $res );
				$db->free( $res );
				$plug->runhook( 'hook_comment_saved', $comment_written['comment_id'] );
				// Redirec the user to his comment */
				if ( !headers_sent() && !$comment['spam'] ) {
					header('Location: ' . url( array( 'site' => 'blog', 'blog' => urlencode( $entry['entry_title'] ) ), false ) . '#com' . $comment_written['comment_id'] );
				}
				$tpl->add( 'empty.tpl' );
				$fillin = $lang['comment_saved'] . '<br />';
				if ( $comment['spam'] ) $fillin .= $lang['comment_spam'] . '<br />';
				$fillin .= '<a href="' . url( array( 'site' => 'blog', 'blog' => urlencode( $entry['entry_title'] ) ) ) . '#com' . $comment_written['comment_id'] . '">' . $lang['continue'] . '</a>';
				$tpl->fillin( 'S_CONTENT', $fillin );
			} else {
				$tpl->add( 'empty.tpl' );
				$plug->runhook( 'hook_comment_validating_failed' );
				$fillin = $lang['comment_errors'] . '<br />';
				foreach ( $comment_error as $error ) {
					$fillin .= $error . '<br />';
				}
				$fillin .= $lang['back'];
				$tpl->fillin( 'S_CONTENT', $fillin );
			}
		} else {
			$plug->runhook( 'hook_comment_not_allowed' );
			$tpl->add( 'empty.tpl' );
			$tpl->fillin( 'S_CONTENT', $lang['comment_error_not_allowed'] );
		}
	} else {
		$db->free( $res );
		$plug->runhook('hook_comment_entry_notfound', $_GET['entry_id'] );
		$tpl->add( 'empty.tpl' );
		$tpl->fillin( 'S_CONTENT', $lang['error_entry_notfound'] . $lang['back'] );
	}
} else {
	$plug->runhook('hook_comment_entry_notfound', 0 );
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['error_entry_notfound'] . $lang['back'] );
}

?>