<?php

/*
 * name		blog.php
 * begin	May 11, 2005
 * 
 * $Id: blog.php 100 2007-08-11 21:45:03Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

$blog_sql = "SELECT
			e.entry_id,
			e.entry_title,
			e.entry_content,
			e.entry_extended,
			e.user_id,
			e.entry_date,
			e.link_id,
			e.entry_nofeedback,
			e.comment_number,
			u.user_name,
			u.user_mail,
			l.link_name
		FROM
			" . TABLE_BLOG . " e
		LEFT JOIN " . TABLE_USER . " u ON  u.user_id = e.user_id 
		LEFT JOIN " . TABLE_LINKS . " l
		ON (
			l.link_id = e.link_id and
			l.link_url = '' )
		WHERE
			e.entry_hidden = 0";

$stoppages = array(
	'page',
	'date',
	'day',
	'category',
	'action',
);

if( !empty( $_GET['blog'] ) && !in_array($_GET['blog'], $stoppages ) ) {
	$blog_sql .= " and e.entry_title = '" . $db->escape( urldecode( $_GET['blog'] ) ) . "'";
} else {
	$_GET['blog'] = '';
}
if ( !empty( $_GET['category'] ) ) { 
	$cat_sql = "SELECT link_id FROM " . TABLE_LINKS . " WHERE link_url = '' and link_name = '" . $db->escape( urldecode( $_GET['category'] ) ) . "' LIMIT 0, 1;";
	$cat_res = $db->query( $cat_sql );
	if( $db->numrows( $cat_res ) ) {
		$cat_row = $db->fetch( $cat_res );;
		$blog_sql .= " and e.link_id = '" . $db->escape( $cat_row['link_id'] ) . "'";
	} else {
		$_GET['category'] = '';
	}
	$db->free( $cat_res );
}
/*
if ( isset( $_GET['date'] ) && is_numeric( $_GET['date'] ) ) {
	if ( isset( $_GET['day'] ) && $_GET['day'] == 1 ) {
		$blog_sql .= " and e.entry_date > '" . $db->escape( $_GET['date'] - 1 ) . "'
			and e.entry_date < '" . $db->escape( $_GET['date'] + 3600*24 )."'";
	} else {
		$blog_sql .= " and e.entry_date > '" . mktime( 23, 59, 59, date( 'm', $_GET['date'] ), 0, date( 'Y', $_GET['date'] ) )."'
			and e.entry_date < '" . mktime( 0, 0, 0, date( 'm', $_GET['date'] )+1, 1, date( 'Y', $_GET['date'] ) )."'";
	}
}
*/
if( isset( $_GET['date'] ) ) {
	$date = explode( '-', $_GET['date'] );
	if( count( $date ) >= 2 ) {
		if( is_numeric( $date[0] ) && strlen( $date[0] ) == 4 &&
			is_numeric( $date[1] ) && strlen( $date[1] ) == 2 ) {
			$_GET['blog'] = '';
			if( isset( $date[2] ) && is_numeric( $date[2] ) && strlen( $date[2] ) == 2 ) {
				// exakt day
				$blog_sql .= " and e.entry_date > '" . mktime_utc( 0, 0, 0, $date[1], $date[2], $date[0] ) . "'";
				$blog_sql .= " and e.entry_date < '" . mktime_utc( 23, 59, 59, $date[1], $date[2], $date[0] ) . "'";
			} else {
				// whole month
				$blog_sql .= " and e.entry_date > '" . mktime_utc( 0, 0, 0, $date[1], 1, $date[0] ) . "'";
				$blog_sql .= " and e.entry_date < '" . mktime_utc( 23, 59, 59, $date[1] + 1, 0, $date[0] ) . "'";
			}
		}
	}
}
$blog_sql .= " and e.entry_date <= '" . time_utc() . "'";

if ( isset( $_GET['page'] ) && is_numeric($_GET['page'] ) ) {
    $offset = ( $_GET['page'] - 1 ) * $config['limit_blog_entries'];
} else {
	$offset = 0;
	$_GET['page'] = 1;
}
$blog_sql .= " ORDER BY e.entry_date DESC LIMIT " . $offset . ", ".$config['limit_blog_entries'].";";

// fire query to db
$res = $db->query( $blog_sql, __LINE__, __FILE__ );

if( !empty( $_GET['blog'] ) && !$db->numrows( $res ) ) {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin('S_CONTENT', $lang['error_entry_notfound'].'<br /><a href="'.url().'">'.$config['blog_title'].'</a>');
	if(!headers_sent()){
		header('HTTP/1.0 404 Not Found');
	}
} elseif( $db->numrows( $res ) ) {
	
	// load tpl
	$tpl->add( 'blog.tpl', __LINE__, __FILE__ );
	$tpl->part_seperate( 'E_ENTRY', __LINE__, __FILE__ );
	
	// this is were the entry data is filled in
	while ( $entry = $db->fetch( $res ) ) {
		$entries[] = $entry;
	}
	
	foreach( $entries as $entry_number => $entry ) {
		$entry['entry_number'] = $entry_number;
		$tpl->part_load( 1, __LINE__, __FILE__);
	
		$last_entry = $entry;
		
		if( !empty( $_GET['blog'] ) && !empty( $entry['entry_extended'] ) ) $entry['entry_content'] .= '<br />' . $entry['entry_extended'];
		if( empty( $_GET['blog'] ) && !empty( $entry['entry_extended'] ) ) $entry['entry_content'] .= '<br /><br />' . $lang['entry_continue'];
		
		$plug->runhook( 'hook_blog_entry_output', $entry['entry_id'] );
		
		if( $entry['comment_number'] == '' ) $entry['comment_number'] = '0';
		
		$tpl->fillin_array( array(
			'S_ENTRY_TITLE' => '<a href="' . url( array( 'site' => 'blog', 'blog' => urlencode( $entry['entry_title'] ) ) ) . '">' . $plug->runfilter( 'filter_entry_title', $entry['entry_title'] ) . '</a>',
			'S_ENTRY_CONTENT' => $plug->runfilter( 'filter_entry_content', $entry['entry_content'] ),
			'S_ENTRY_ID' => $entry['entry_id'],
			'S_ENTRY_DATE' => strftime( $config['time_format'], time_lokal( $entry['entry_date'] ) ),
			'S_ENTRY_CATEGORY_NAME' => '<a href="' . url( array( 'site' => 'category', 'category' => urlencode( $entry['link_name'] ) ) ) . '">' . $plug->runfilter( 'filter_category_name', $entry['link_name'] ) . '</a>',
			'S_ENTRY_USER_NAME' => $plug->runfilter( 'filter_user_name', $entry['user_name'] ),
			'S_ENTRY_USER_MAIL' => $plug->runfilter( 'filter_user_mail', $entry['user_mail']),
			'S_ENTRY_FEEDBACKNUMBERS' => '<a href="' . url(array( 'site' => 'blog', 'blog' => urlencode( $entry['entry_title'] ) ) ) . '#comments">' . $lang['comments'] . ' (' . $entry['comment_number'] . ')</a>',
		) );
	} // while reading blog entries
	$tpl->part_unite( __LINE__, __FILE__ );
	$db->free( $res );
	// if it is a single entry, fill in the feedback data
	if( !empty( $_GET['blog'] ) ) {
		$plug->runhook( 'hook_blog_single_entry' );
		// trackback autodedection
		$trackback = '<!--;
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:trackback="http://madskills.com/public/xml/rss/module/trackback/">
<rdf:Description
	rdf:about="' . url( array( 'site' => 'blog', 'blog' => urlencode( $last_entry['entry_title'] ) ), 0 ) . '"
	dc:identifier="' . url( array( 'site' => 'blog', 'blog' => urlencode( $last_entry['entry_title'] ) ), 0 ) . '"
	dc:title="' . html2txt( $last_entry['entry_title'] ) . '"
	trackback:ping="' . url( array( 'site' => 'trackback', 'trackback' => urlencode( $last_entry['entry_title'] ) ), 0 ) . '" />
/rdf:RDF>
-->';
		
		$tpl->fillin_array( array( 'S_TRACKBACK' => $trackback,
			'S_BLOG_TITLE' => $plug->runfilter( 'filter_entry_title', $last_entry['entry_title'] ),
			'S_BLOG_SUBTITLE' => html2txt( $config['blog_title'] ),
		) );
		
		// load the feedback from the db
		$com_sql = "SELECT
						comment_id,
						comment_author_name,
						comment_author_mail,
						comment_title,
						comment_content,
						comment_author_url,
						comment_date
					FROM
						" . TABLE_COMMENTS . "
					WHERE
						entry_id = '" . $db->escape( $last_entry['entry_id'] ) . "' and
						comment_spam = '0' and
						comment_active = '1'
					ORDER BY
						comment_date ASC;";
		$com_res = $db->query( $com_sql );
		$comm = array();
		$tbs = array();
		// fetch and sepereate comments and trackbacks
		while( $com = $db->fetch( $com_res ) ) {
			if( !empty($com['comment_title'] ) ) {
				$tbs[] = $com;
			} else {
				$comm[] = $com;
			}
		}
		$db->free( $com_res );
		
		// if we have trackbacks, load the template and fillin the data
		if( count( $tbs ) ) {
			$tpl->add( 'comments.tpl' );
			$tpl->fillin( 'S_COMMENTS_TITLE', $lang['trackbacks'] );
			$tpl->part_seperate( 'E_COMMENT' );
			$plug->runhook( 'hook_blog_trakbacks' );
			foreach( $tbs as $comment ) {
				$tpl->part_load( 1, __LINE__, __FILE__ );
				$plug->runhook( 'hook_blog_trackback_single' );
				if( !empty( $comment['comment_author_url'] ) ) {
					$comment_author = '<a href="' . $plug->runfilter( 'filter_comment_author_url', $comment['comment_author_url'] ) . '">' . $plug->runfilter( 'filter_comment_author_name', $comment['comment_author_name'] ) . '</a>';
				} else {
					$comment_author =  $plug->runfilter( 'filter_comment_author_name', $comment['comment_author_name'] );
				}
				$tpl->fillin_array( array(
					'S_COMMENT_ID' => 'com' . $comment['comment_id'],
					'S_COMMENT_CONTENT' => $plug->runfilter( 'filter_comment_title', $comment['comment_title'] ) . '<br /><br />' . $plug->runfilter( 'filter_comment_content', $comment['comment_content'] ),
					'S_COMMENT_AUTHOR_NAME' => $comment_author,
					'S_COMMENT_AUTHOR_MAIL' => '',
					'S_COMMENT_DATE' => strftime( $config['time_format'], time_lokal( $comment['comment_date'] ) ),
				) );
			}
			$tpl->part_unite();
		}
		
		// if we got comments, load the template and fillin the data
		if( count( $comm ) ) {
			$tpl->add( 'comments.tpl' );
			$tpl->fillin( 'S_COMMENTS_TITLE', $lang['comments'] );
			$tpl->part_seperate( 'E_COMMENT' );
			$plug->runhook( 'hook_blog_comments' );
			foreach( $comm as $comment ) {
				$tpl->part_load( 1, __LINE__, __FILE__ );
				$plug->runhook( 'hook_blog_comment_single' );
				if( !empty( $comment['comment_author_url'] ) ) {
					$comment_author = '<a href="' . $plug->runfilter( 'filter_comment_author_url', $comment['comment_author_url'] ) . '">' . $plug->runfilter( 'filter_comment_author_name', $comment['comment_author_name'] ) . '</a>';
				} else {
					$comment_author =  $plug->runfilter( 'filter_comment_author_name', $comment['comment_author_name'] );
				}
				$tpl->fillin_array( array(
					'S_COMMENT_ID' => 'com' . $comment['comment_id'],
					'S_COMMENT_CONTENT' => $plug->runfilter( 'filter_comment_content', $comment['comment_content'] ),
					'S_COMMENT_AUTHOR_NAME' => $plug->runfilter( 'filter_comment_author', $comment_author ),
					'S_COMMENT_AUTHOR_MAIL' => $plug->runfilter( 'filter_comment_author_mail', $comment['comment_author_mail'] ),
					'S_COMMENT_DATE' => strftime( $config['time_format'], time_lokal( $comment['comment_date'] ) ),
				) );
			}
			$tpl->part_unite();
		}
		
		// the comment form
		$tpl->add( 'comment_form.tpl' );
		$comment_form[0]['text'] = $lang['name'];
		$comment_form[0]['input'] = '<input type="text" name="comment_author_name" />';
		$comment_form[1]['text'] = $lang['mail'];
		$comment_form[1]['input'] = '<input type="text" name="comment_author_mail" />';
		$comment_form[2]['text'] = $lang['homepage'];
		$comment_form[2]['input'] = '<input type="text" name="comment_author_url" />';
		$comment_form[3]['text'] = $lang['data_remember'];
		$comment_form[3]['input'] = '<input type="checkbox" name="comment_remember_values" value="true" class="checkbox" />';
		if ( isset( $_COOKIE['comment_crypt'] ) && strlen( $_COOKIE['comment_crypt'] ) == 32 ) {
			$sql = "SELECT
						comment_author_name,
						comment_author_mail,
						comment_author_url
					FROM
						" . TABLE_COMMENTS . "
					WHERE
						comment_crypt = '" . $db->escape( $_COOKIE['comment_crypt'] ) . "'
					LIMIT
						0, 1;";
			$res = $db->query( $sql );
			if ( $db->numrows( $res ) ) {
				$row = $db->fetch( $res );
				$comment_form[0]['input'] = '<input type="text" name="comment_author_name" value="' . $row['comment_author_name'] . '" />';
				$comment_form[1]['input'] = '<input type="text" name="comment_author_mail" value="' . $row['comment_author_mail'] . '" />';
				$comment_form[2]['input'] = '<input type="text" name="comment_author_url" value="' . $row['comment_author_url'] . '" />';
				$comment_form[3]['input'] = '<input type="checkbox" name="comment_remember_values" value="true" checked="checked" class="checkbox" />';
			}
		}
		$plug->runhook( 'hook_blog_comment_form' );
		$tpl->part_seperate( 'E_COMMENT_FORM' );
		foreach( $comment_form as $form ) {
			$tpl->part_load( 1, __LINE__, __FILE__ );
			$tpl->fillin_array( array(
				'S_COMMENT_FORM' => $form['text'],
				'I_COMMENT_FORM' => $form['input']
			) );
		}
		$tb_uri = url();
		if( $config['mod_rewrite'] ) {
			$tb_uri .= 'trackback/' . urlencode( $last_entry['entry_title'] ) . '/';
		} else {
			$tb_uri .= 'trackback.php?trackback=' . urlencode( $last_entry['entry_title'] );
		}
		$tpl->part_unite();
		$tpl->fillin_array( array(
			'S_COMMENT_FORM_CONTENT' => $lang['comment_content'] . ':',
			'I_COMMENT_FORM_CONTENT' => '<textarea name="comment_content" cols="60" rows="15"></textarea>',
			'I_COMMENT_FORM_SUBMIT' => '<input type="submit" name="comment_submit" value="' . $lang['send'] . '" class="submit" />',
			'L_COMMENT_ACTION' => url( array( 'site' => 'comment', 'entry_id' => $last_entry['entry_id'] ) ),
			'L_TRACKBACK_URI' => $tb_uri,
			'S_TRACKBACK_URI' => $lang['trackback_uri'],
			'S_COMMENT_FORM_TITLE' => $lang['comment_form_title'], 
		) );
	} else {
		$plug->runhook( 'hook_blog_multi_entries' );
		// If it wasn't a single entry, we have to create a pages list
		$num_sql = "SELECT
						entry_id
					FROM
						" . TABLE_BLOG . "
					WHERE
						entry_hidden = '0'";
		if ( !empty( $_GET['category'] ) ) { 
			$cat_sql = "SELECT link_id FROM " . TABLE_LINKS ." WHERE link_url = '' and link_name = '" . $db->escape( urldecode( $_GET['category'] ) ) . "' LIMIT 0, 1;";
			$cat_res = $db->query( $cat_sql );
			if( $db->numrows( $cat_res ) ) {
				$cat_row = $db->fetch( $cat_res );
				$num_sql .= " and link_id = '" . $db->escape( $cat_row['link_id'] ) . "'";
			} else {
				$_GET['category'] = '';
			}
			$db->free( $cat_res );
		}
		if ( isset( $_GET['date'] ) && is_numeric( $_GET['date'] ) ) {
			if ( isset( $_GET['day'] ) && $_GET['day'] == 1 ) {
				$num_sql .= " and entry_date > '" . $db->escape( $_GET['date'] - 1 ) . "'
					and entry_date < '" . $db->escape( $_GET['date'] + 3600*24 )."'";
			} else {
				$num_sql .= " and entry_date > '" . mktime( 23, 59, 59, date( 'm', $_GET['date'] ), 0, date( 'Y', $_GET['date'] ) )."'
					and entry_date < '" . mktime( 0, 0, 0, date( 'm', $_GET['date'] )+1, 1, date( 'Y', $_GET['date'] ) )."'";
			}
		}
		$num_sql .= " and entry_date <= '" . time_utc() . "'";
		$num_res = $db->query( $num_sql );
		$num = $db->numrows( $num_res );
		$db->free( $num_res );
		$num = ceil( $num / $config['limit_blog_entries'] );
		$pages = '';
		$p_url = array( 'site' => 'blog' );
		
		if ( !empty( $_GET['category'] ) ) $p_url['cat'] = $_GET['category'];
		if( isset( $_GET['date'] ) && is_numeric( $_GET['date'] ) ) $p_url['date'] = $_GET['date'];
		if ( isset( $_GET['day'] ) && $_GET['day'] == 1 ) $p_url['day'] = 1;
		
		if( $_GET['page'] > 1 ) {
			$p_url['page'] = 1;
			$pages = '<a href="' . url( $p_url) . '">&lt;</a> ';
			$p_url['page'] = $_GET['page'] - 1;
			$pages .= '<a href="' . url( $p_url ) . '">&lt;&lt;' . '</a> ';
		}
		
		for( $i = -2; $i <= 2; $i++ ) {
			$page = $_GET['page'] + $i;
			if( $page > 0 && $page <= $num ) {
				if( $page !=  $_GET['page'] ) {
					$p_url['page'] = $page;
					$pages .= '<a href="' . url( $p_url ) . '">' . $page . '</a> ';
				} else {
					$pages .= $page . ' ';
				}
			}
		}
		
	if( $_GET['page'] < $num ) {
			$p_url['page'] = $_GET['page'] + 1;
			$pages .= '<a href="' . url( $p_url) . '">&gt;&gt;</a> ';
			$p_url['page'] = $num;
			$pages .= '<a href="' . url( $p_url ) . '">&gt;' . '</a>';
		}
		
		$tpl->fillin( 'S_PAGES', $pages );
	}
}

?>
