<?php

/*
 * @name: plugins.php
 * @desc: yabs plugin hooks and filters
 * @created: 23.04.2007
 * @author: Daniel Triendl <daniel@tac-ops.net>
 * @copy: 2007 yabs
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

$plug->addfilter( 'filter_comment_title', 'html2txt' );
$plug->addfilter( 'filter_comment_content', 'html2txt' );
$plug->addfilter( 'filter_comment_author_name', 'html2txt' );
$plug->addfilter( 'filter_comment_author_mail', 'html2txt' );
$plug->addfilter( 'filter_entry_content', 'htmlchars' );
$plug->addfilter( 'filter_entry_title', 'htmlchars' );

$plug->addhook( 'hook_index_sidebar', 'calendar' );
$plug->addhook( 'hook_index_sidebar', 'categories' );
$plug->addhook( 'hook_index_sidebar', 'blogroll' );

function calendar() {
	global $tpl;
	global $lang;
	global $db;
	
	$this_day = date( 'd', time_local() );
	$this_month = date( 'm', time_local() );
	$this_year =  date( 'Y', time_local() );
	if( isset( $_GET['date'] ) ) {
		$date = explode( '-', $_GET['date'] );
		if( count( $date ) >= 2 ) {
			if( is_numeric( $date[0] ) && strlen( $date[0] ) == 4 &&
				is_numeric( $date[1] ) && strlen( $date[1] ) == 2 ) {
				$this_year = $date[0];
				$this_month = $date[1];
			}
			if( isset( $date[2] ) && is_numeric( $date[2] ) && strlen( $date[2] ) == 2 ) {
				$this_day = $date[2];
			}
		}
	}
	
	$offset = date( 'w', mktime( 0, 0, 0, $this_month, 1, $this_year ) ) - 1;
	if( $offset == -1 ) $offset = 6;
	
	$calendar = '<table cellspacing="0" id="calendar_title"><tr>';
	$calendar .= '<td id="calendar_title_left"><a href="' . url( array( 'site' => 'blog', 'date' => date( 'Y-m', mktime( 0, 0, 0, $this_month - 1 , 1, $this_year ) ) ) ) . '">&lt;&lt;</a></td>';
	$calendar .= '<td id="calendar_title_center"><a href="' . url( array( 'site' => 'blog', 'date' => date( 'Y-m', mktime( 0, 0, 0, $this_month, 1, $this_year ) ) ) ). '">' . $lang['month' . $this_month] . '</a></td>';
	$calendar .= '<td id="calendar_title_right"><a href="' . url( array( 'site' => 'blog', 'date' => date( 'Y-m', mktime( 0, 0, 0, $this_month + 1 , 1, $this_year ) ) ) ) . '">&gt;&gt;</a></td>';
	$calendar .= '</tr></table>';
	
	$calendar .= '<table cellspacing="0" id="calendar_content"><tr>';
	for( $i = 0; $i < 7; $i++ ) {
		$calendar .= '<td>' . $lang['day_short_' . $i] . '</td>';
	}
	$calendar .= '</tr><tr>';
	
	for( $i = 0; $i < $offset; $i++ ) {
		$calendar .= '<td>&nbsp;</td>';
	}
	
	$sql = "SELECT entry_date FROM " . TABLE_BLOG . " WHERE entry_date > '" . mktime_utc( 0, 0, 0, $this_month, 1, $this_year ) . "' and ";
	$sql .= " entry_date < '" . mktime_utc( 23, 59, 59, $this_month + 1, 0, $this_year) . "' and entry_hidden = '0' and ";
	$sql .= " entry_date < '" . time_utc() . "';";
	$res = $db->query( $sql );
	$entries = array();
	while( $row = $db->fetch( $res ) ) {
		$entries[date('j', time_local( $row['entry_date'] ) )] = true;
	}
	
	$i = $offset;
	for( $j = 0; $j < date( 't', mktime( 0, 0, 0, $this_month,  $this_day, $this_year ) ); $j++ ) {
		if( !isset( $entries[$j + 1] ) && $j + 1 == $this_day ) {
			$calendar .= '<td class="calendar_this_day">';
		} elseif( isset( $entries[$j + 1] ) && $j + 1 != $this_day) {
			$calendar .= '<td class="calendar_mark_day">';
		} elseif( isset( $entries[$j + 1] ) && $j + 1 == $this_day) {
			$calendar .= '<td class="calendar_mark_day calendar_this_day">';
		} else {
			$calendar .= '<td>';
		}
		if( isset( $entries[$j + 1] ) ) {
			$calendar .= '<a href="' . url( array( 'site' => 'blog', 'date' => date('Y-m-d', mktime( 0, 0, 0, $this_month, $j + 1, $this_year ) ) ) ) . '">' . ($j + 1) . '</a>';
		} else {
			$calendar .= ( $j + 1 );
		}
		$calendar .= '</td>';
		$i++;
		if( $i == 7 ) {
			$calendar .= '</tr><tr>' . "\n";
			$i = 0;
		}
	}
	
	if( $i == 0 ) {
		$calendar = substr( $calendar, 0, strlen( $calendar ) - 10 );
	} else {
		for( $j = $i; $j < 7; $j++ ) {
			$calendar .= '<td>&nbsp;</td>';
		}
	}

	$calendar .= '</tr></table>';
	$tpl->part_load( 1, __LINE__, __FILE__ );
	$tpl->fillin_array( array(
		'S_SIDEBAR_TITLE' => $lang['calendar'],
		'S_SIDEBAR_CONTENT' => $calendar,
	) );
}

function get_sidebar() {
	global $db;
	$sql = "SELECT
				link_name,
				link_url
			FROM
				" . TABLE_LINKS . "
			ORDER BY
				link_name ASC;";
	$res = $db->query( $sql );
	$cats = array();
	$links = array();
	while( $row = $db->fetch( $res ) ) {
		if( $row['link_url'] == '' ) {
			$cats[] = $row['link_name'];
		} else {
			$links[] = $row;
		}
	}
	$db->free( $res );
	return array( 'links' => $links, 'categories' => $cats );
}

function categories() {
	global $tpl;
	global $sidebar;
	global $lang;
	
	if( !is_array( $sidebar ) ) {
		$sidebar = get_sidebar();
	}
	$cats = $sidebar['categories'];
	$content = '';
	$url = array( 'site' => 'category' );
	foreach( $cats as $cat ) {
		$url['category'] = urlencode( $cat );
		$content .= '<li><a href="' . url( $url ) . '">' . $cat . '</a></li>';
	}
	$tpl->part_load( 1, __LINE__, __FILE__ );
	$tpl->fillin_array( array(
		'S_SIDEBAR_TITLE' => $lang['categories'],
		'S_SIDEBAR_CONTENT' => '<ul>' . $content . '</ul>',
	) );
}

function blogroll() {
	global $tpl;
	global $sidebar;
	global $lang;
	
	if( !is_array( $sidebar ) ) {
		$sidebar = get_sidebar();
	}
	$links = $sidebar['links'];
	$content = '';
	foreach( $links as $link ) {
		$content .= '<li><a href="' . $link['link_url'] . '">' . $link['link_name'] . '</a></li>';
	}
	$tpl->part_load( 1, __LINE__, __FILE__ );
	$tpl->fillin_array( array(
		'S_SIDEBAR_TITLE' => $lang['blogroll'],
		'S_SIDEBAR_CONTENT' => '<ul>' . $content . '</ul>',
	) );
}

function htmlchars( $str ) {
	$trans = get_html_translation_table( HTML_ENTITIES );
	unset( $trans['<'] );
	unset( $trans['>'] );
	unset( $trans['"'] );
	$trans['<blockquote>'] = '</p><blockquote><p>';
	$trans['</blockquote>'] = '</p></blockquote><p>';
	return( strtr( $str, $trans ) );
}

?>