<?php

/*
 * @name: functions.php
 * @desc:
 * @created: May 11, 2005
 * @author: Daniel Triendl <daniel@tac-ops.net>
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !function_exists( 'time_utc' ) ) {
	function time_utc()
	{
		$offset = date( 'Z' );
		return time() - $offset;
	}
}

if ( !function_exists( 'time_local' ) ) {
	function time_local( $timestamp = false )
	{
		global $config;
		if( $timestamp === false ) $timestamp = time();
		return $timestamp + ( $config['time_offset'] * 3600 );
	}
}

if ( !function_exists( 'time_lokal' ) ) {
	function time_lokal( $timestamp = false )
	{
		return time_local( $timestamp );
	}
}

if ( !function_exists( 'mktime_utc' ) ) {
	function mktime_utc( $hour = false, $minute = false, $second = false,
		$month = false, $day = false, $year = false )
	{
		$offset = date( 'Z' );
		$hour = ( $hour === false ) ? strftime( '%H', time() ) : $hour;
		$minute = ( $minute === false ) ? strftime( '%M', time() ) : $minute;
		$second = ( $second === false ) ? strftime( '%S', time() ) : $second;
		$month = ( $month === false ) ? strftime( '%m', time() ) : $month;
		$day = ( $day === false ) ? strftime( '%d', time() ) : $day;
		$year = ( $year === false ) ? strftime( '%Y', time() ) : $year;
		
		return mktime( $hour, $minute, $second, $month, $day, $year ) - $offset;
	}
}

if ( !function_exists( 'url' ) ) { 
	function url( $querys = array(), $use_amp = true )
	{
		global $config;
		$url = "http://".$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);
		if(substr($url, strlen($url)-1, 1) != '/') $url .= "/";

		if( count( $querys ) > 0 ) {
			if( $config['mod_rewrite'] ) {
				if( !empty( $querys['site'] ) ) {
					$url .= $querys['site'] . '/';
					if( !empty( $querys[$querys['site']] ) ) {
						$url .= $querys[$querys['site']] . '/';
						$querys[$querys['site']] = '';
					}
					$querys['site'] = '';
				} else {
					$url .= 'blog/';
				}
				
				foreach( $querys as $key => $val ) {
					if( !empty( $val ) ) {
						$url .= $key . '/' . $val . '/';
					}
				}
			}else{
				$query = "?";
				foreach($querys as $name => $value){
					if($use_amp){
						$query .= $name."=".$value."&amp;";
					}else{
						$query .= $name."=".$value."&";
					}
				}
				if($use_amp) $query = substr($query, 0, strlen($query)-5);
				else $query = substr($query, 0, strlen($query)-1);
				$url .= $query;
			}
		}
		return $url;
	}
}

if ( !function_exists( 'aurl' ) ) {
	function aurl($querys = array(), $use_amp = true)
	{
		$url = 'admin.php';
		$url .= '?';
		if(count($querys)){
			foreach($querys as $var => $arg){
				$url .= $var . '=' . $arg;
				if($use_amp) $url .= '&amp;';
				else $url .= '&';
			}
		}
		return $url;
	}
}
	
if( !function_exists('make_get') ) {
	function make_get()
	{
		$request = $_SERVER['REQUEST_URI'];
		// Strip away the dir
		if( dirname( $_SERVER['PHP_SELF'] ) != '/' ) {
			$request = str_replace( dirname( $_SERVER['PHP_SELF'] ), '', $request );
		}
		$request = explode( '/', substr( $request, 1 ) );
		
		if( isset( $request[0] ) ) {
			$_GET['site'] = $request[0];	
		}
		
		for( $i = 0; $i < count( $request ); $i++ ) {
			if( isset( $request[$i + 1] ) && isset( $request[$i] ) ) {
				$_GET[$request[$i]] = $request[$i + 1];
			}
		}
	}
}

if ( !function_exists( 'site_true_home' ) ) {
	function site_true_home()
	{
		$url = "http://".$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);
		if(substr($url, strlen($url)-1, 1) == '/') $url = substr($url, 0, strlen($url)-1);
		return $url;
	}
}
	
if ( !function_exists( 'checkmail' ) ) {
	function checkmail( $mail )
	{
	    return preg_match( "/^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/", $mail );
	} 
}

if ( !function_exists( 'html2txt' ) ) {
	// Thanks uersoy at tnn dot net and admin at automapit dot com 
	// http://php.net/strip_tags
	function html2txt ( $str )
	{
		$search = array( '@<script[^>]*?>.*?</script>@si',  // Strip out javascript
		                 '@<style[^>]*?>.*?</style>@siU',    // Strip style tags properly
		                 '@<[\/\!]*?[^<>]*?>@si',            // Strip out HTML tags
		                 '@<![\s\S]*?--[ \t\n\r]*>@'        // Strip multi-line comments including CDATA
		);
		$str = preg_replace( $search, '', $str );
		return htmlentities( $str );
	}
}

function cutStr255 ( $str ) {
	return substr( $str, 0, 255 );
}

if ( !function_exists( 'object2array' ) ) {
	function object2array($object)
	{
		$return = NULL;
	    
		if ( is_array( $object ) ) {
			foreach ( $object as $key => $value ) {
	           $return[$key] = object2array( $value );
			}
		} else {
			$var = get_object_vars( $object );
			if ( $var ) {
				foreach( $var as $key => $value ) {
					$return[$key] = object2array( $value );
				}
			} else {
				$return = strval( $object ); // strval and everything is fine
			}
		}
		return $return;
	}
}

if( !function_exists( 'yabs_file_write' ) ) {
	function yabs_file_write( $f, $limiter, $string )
	{
		if( !file_exists( $f ) || !is_writeable( $f ) ) return false;
		if( filesize( $f ) ) {
			$fo = fopen( $f, 'r' );
			$fc = fread( $fo, filesize( $f ) );
			fclose( $fo );
		} else {
			$fc = '';
		}
		
		$fc = explode( $limiter, $fc );
		if( !isset( $fc[1] ) ) $fc[1] = '';
		if( !isset( $fc[2] ) ) $fc[2] = '';
		
		if( !empty( $fc[0] ) ) {
			$fc[0] = trim( $fc[0] ) . "\n" . $limiter . "\n";
		} else {
			$fc[0] = $limiter . "\n";
		}
		$fc[1] = $string;
		if( !empty( $fc[2] ) ) {
			$fc[2] = "\n" . $limiter . "\n" . trim( $fc[2] );
		} else {
			$fc[2] = "\n" . $limiter;
		}
		
		$fo = fopen( $f, 'w' );
		fwrite( $fo, implode( '', $fc ) );
		fclose( $fo );
		return true;
	}
}
	
?>