<?php

/*
 * @name: autoload.php
 * @desc:
 * @created: March 23, 2007
 * @author: Daniel Triendl <daniel@tac-ops.net>
 * @copy: 2007 yabs
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

/*
 * Load classes
 */
 
function __autoload( $class ) {
	if ( file_exists( './includes/class.' . $class . '.php' ) ){
		require_once( './includes/class.' . $class . '.php' );
		return;
	} else {
		// Browsing plugins
		$plugins = scandir( './plugins' );
		foreach ( $plugins as $plugin ) {
			if( substr( $plugin, 0, 1 ) != '.' && substr( $plugin, 0, 1 ) != '.' && file_exists( './plugins/' . $plugin . '/' . 'class.' . $class . '.php' ) ) {
				require_once( './plugins/' . $plugin . '/' . 'class.' . $class . '.php' );
				return;
			}
		}
	}
	die( 'Class ' . $class . ' not found.' );
}

?>