<?php
/*
 * @name: feed.php
 * @desc: 
 * @created: February 27, 2005
 * @author: Daniel Triendl <daniel@tac-ops.net>
 * @copy: 2005-2007 yabs
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

define( 'INSIDE', true );

require( './includes/init.php');

$tpl = new template();

switch( @$_GET['feed'] ) {
	case 'entry':
	default:
		$blog_sql = "SELECT
					e.entry_id,
					e.entry_title,
					e.entry_content,
					e.user_id,
					e.entry_date,
					e.link_id,
					e.entry_nofeedback,
					e.comment_number,
					u.user_name,
					u.user_mail,
					l.link_name
				FROM
					" . TABLE_BLOG . " e
				LEFT JOIN (
					" . TABLE_USER . " u )
				ON (
					u.user_id = e.user_id )
				LEFT JOIN (
					" . TABLE_LINKS . " l )
				ON (
					l.link_id = e.link_id and
					l.link_url = '' )
				WHERE
					e.entry_hidden = 0";
		if ( !empty( $_GET['category'] ) ) { 
			$cat_sql = "SELECT link_id FROM " . TABLE_LINKS . " WHERE link_url = '' and link_name = '" . $db->escape( urldecode( $_GET['category'] ) ) . "' LIMIT 0, 1;";
			$cat_res = $db->query( $cat_sql );
			if( $db->numrows( $cat_res ) ) {
				$cat_row = $db->fetch( $cat_res );
				$blog_sql .= " and e.link_id = '" . $db->escape( $cat_row['link_id'] ) . "'";
			} else {
				$_GET['category'] = '';
			}
			$db->free( $cat_res );
		}
		$blog_sql .= " and e.entry_date <= '" . time_utc() . "'";
		$blog_sql .= " ORDER BY e.entry_date DESC LIMIT 0, ".$config['limit_blog_entries'].";";
		
		// fire query to db
		$res = $db->query( $blog_sql, __LINE__, __FILE__ );
		$tpl->add( 'feed.txml' );
		$tpl->part_seperate( 'E_ENTRY' );
		$time = '';
		while( $entry = $db->fetch( $res ) ) {
			$tpl->part_load();
			if( !empty( $_GET['blog'] ) && !empty( $entry['entry_extended'] ) ) $entry['entry_content'] .= '<br />' . $entry['entry_extended']; 
			$plug->runhook( 'hook_feed_entry_fillin' );
			$time_offset = floor( $config['time_offset'] );
			if( strlen( $time_offset ) == 1 ) $time_offset = '0' . $time_offset;
			if( $time_offset >= 0 ) $time_offset = '+' . $time_offset;
			if( ( $config['time_offset'] - $time_offset ) * 60 > 0 ) {
				$time_offset .= ':' . ( $config['time_offset'] - $time_offset ) * 60;
			} else {
				$time_offset .= ':00';
			}
			if( empty( $time ) ) $time = strftime( '%Y-%m-%dT%H:%M:%S' . $time_offset, time_lokal( $entry['entry_date'] ) );
			$tpl->fillin_array( array(
				'S_ENTRY_CONTENT' => str_replace( '&', '&amp;', $plug->runfilter( 'filter_entry_content', $entry['entry_content'] ) ),
				'S_ENTRY_TITLE' => str_replace( '&', '&amp;', $entry['entry_title'] ),
				'L_ENTRY_URI' => url( array( 'site' => 'blog', 'blog' => urlencode( $entry['entry_title'] ) ) ),
				'S_ENTRY_DATE' => strftime( '%Y-%m-%dT%H:%M:%S' . $time_offset, time_lokal( $entry['entry_date'] ) ),
				'S_ENTRY_AUTHOR_NAME' => html2txt( $entry['user_name'] ),
				'L_ENTRY_AUTHOR_URI' => url( array( 'site' => 'blog', 'author' => urlencode( $entry['user_name'] ) ) ),
				'S_ENTRY_CATEGORY' => html2txt( $entry['link_name'] ),
			) );
		}
		if( empty( $time ) ) if( empty( $time ) ) $time = strftime( '%Y-%m-%dT%H:%M:%S+' . $time_offset, 0 );
		$tpl->part_unite();
		$sql = "SELECT user_name FROM " . TABLE_USER . ";";
		$res = $db->query( $sql );
		$tpl->part_seperate( 'E_AUTHOR' );
		while( $row = $db->fetch( $res ) ) {
			$tpl->part_load();
			$tpl->fillin_array( array( 
				'S_AUTHOR_NAME' => html2txt( $row['user_name'] ),
				'L_AUTHOR_URI' => url( array( 'site' => 'blog', 'author' => urlencode( $row['user_name'] ) ) ),
			) );
		}
		$tpl->part_unite();
		$sql = "SELECT link_name FROM " . TABLE_LINKS . " WHERE link_url = '';";
		$res = $db->query( $sql );
		$tpl->part_seperate( 'E_CATEGORY' );
		while( $row = $db->fetch( $res ) ) {
			$tpl->part_load();
			$tpl->fillin( 'S_CATEGORY', html2txt( $row['link_name'] ) );
		}
		$tpl->part_unite();
		$url = array( 'site' => 'feed' );
		if( !empty( $_GET['category'] ) ) $url['category'] = $_GET['category'];
		$tpl->fillin_array( array(
			'S_URL' => url(),
			'S_URL_SELF' => url( $url ),
			'S_TITLE' => html2txt( $config['blog_title'] ),
			'S_GENERATOR_VERSION' => '0.8.0', // Have to change that later
			'S_GENERATOR_NAME' => 'yabs atom feed generator http://yabs.tac-ops.net',
			'S_DATE' => $time,
			'S_CHARSET' => $lang['charset'],
		) );
		break;
}

header( 'Content-Type: application/atom+xml; charset=' . $lang['charset'] );

$tpl->output();

?>