<?php

/*
 * @name: temmlate.php
 * @desc:
 * @created: May 04, 2007
 * @author: Daniel Triendl <daniel@tac-ops.net>
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if( $user->getRight('settings' ) ) {
	if( !empty( $_POST['template'] ) ) {
		$_POST['template'] = trim( $_POST['template'] );
		if( is_dir( './templates/' . $_POST['template'] ) && substr( $_POST['template'], 0, 1 ) != '.' && $_POST['template'] != 'admin' ) {
			$sql = "UPDATE " . TABLE_CONFIG . " SET config_value = '" . $db->escape( $_POST['template'] ) . "' WHERE config_name = 'template';";
			$db->query( $sql );
			$config['template'] = $_POST['template'];
			$tpl->add( 'empty.tpl' );
			$tpl->fillin( 'S_CONTENT', $lang['admin_template_saved'] );
		}
	}
	
	$dir = scandir( './templates/' );
	$tpl->add( 'templates.tpl' );
	$tpl->part_seperate( 'E_TEMPLATE' );
	$i = 0;
	foreach ( $dir as $folder ) {
		if ( substr( $folder, 0, 1 ) != '.' && is_dir( './templates/' . $folder ) && $folder != 'admin' ) {
			$tpl->part_load();
			$template = array();
			if ( file_exists( './templates/' . $folder . '/template.xml' ) ) {
				$template = object2array( new SimpleXMLElement( './templates/' . $folder . '/template.xml', NULL, true ) );
			}
			$template['name'] = ( !empty( $template['name'] ) ) ? $template['name'] : $folder;
			$template['preview'] = ( file_exists( './templates/' . $folder . '/preview.jpg' ) ) ? '<img src="./templates/' . $folder . '/preview.jpg" alt="image_' . $template['name'] . '_preview" />' : '';
			if( isset( $template['author'] ) && is_array( $template['author'] ) ) {
				if( !empty( $template['author']['name'] ) ) {
					if( !empty( $template['author']['url'] ) && preg_match( '/^(http|https):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,6}((:[0-9]{1,5})?\/.*)?$/i', $template['author']['url'] ) ) {
						$template['author'] = '<a href="' . $template['author']['url'] . '">' . $template['author']['name'] . '</a>';
					} else {
						$template['author'] = $template['author']['name'];
					}
				}
			} else {
				$template['author'] = '';
			}
			$template['description'] = ( !empty( $template['description'] ) ) ? $template['description'] : '';
			$template['version'] = ( !empty( $template['version'] ) ) ? $template['version'] : '';
			
			if ( $i == 0 ) {
				$css_table_row = 'yabs_table_row_dark';
				$i = 1;
			} else {
				$css_table_row =  'yabs_table_row_light';
				$i = 0;
			}
			
			if( $folder == $config['template'] ) {
				$tpl->fillin( 'I_TEMPLATE_FORM', '<input type="radio" name="template" value="' . $folder . '" checked="checked" />' );
			} else {
				$tpl->fillin( 'I_TEMPLATE_FORM', '<input type="radio" name="template" value="' . $folder . '" />' );
			}
			
			$tpl->fillin_array( array( 
				'S_TEMPLATE_AUTHOR' => $template['author'],
				'S_TEMPLATE_VERSION' => $template['version'],
				'S_TEMPLATE_NAME' => $template['name'],
				'S_TEMPLATE_DESCRIPTION' => $template['description'],
				'S_CSS_TABLE_ROW' => $css_table_row,
				'S_TEMPLATE_PREVIEW' => $template['preview'],
			) );
		}
	}
	$tpl->part_unite();
	
	$url = array( 'site' => 'template' );
	$tpl->fillin_array( array(
		'S_TEMPLATE_NAME_TEXT' => $lang['name'],
		'S_TEMPLATE_VERSION_TEXT' => $lang['version'],
		'S_TEMPLATE_DESCRIPTION_TEXT' => $lang['description'],
		'S_TEMPLATE_AUTHOR_TEXT' => $lang['author'],
		'S_TEMPLATE_PREVIEW_TEXT' => $lang['preview'],
		'L_TEMPLATE_ACTION' => aurl( $url ),
		'I_TEMPLATE_SUBMIT' => '<input type="submit" name="template_save" value="' . $lang['save'] . '" />',
	) ); 
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}

?>