<?php
/*
 * @name: settings.php
 * @desc: 
 * @created: May 3, 2007
 * @author: Daniel Triendl <daniel@tac-ops.net>
 * @copy: 2007 yabs
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if( $user->getRight('settings' ) ) {

	$time_zones = array( -12, -11, -10, -9, -8, -7, -6, -5, -4, -3.5, -3, -2, -1, 0, 1, 2, 3, 3.5, 4, 4.5, 5, 5.5, 6, 6.5, 7, 8, 9, 9.5, 10, 11, 12, 13);
	
	if( isset( $_POST['settings_save'] ) ) {
		if ( isset( $_GET['yabsonce'] ) && $_GET['yabsonce'] == $user->getOnce() ) {
			// Test dat shit
			$settings_save = array();
			
			if( isset( $_POST['blog_title'] ) ) $settings_save['blog_title'] = $_POST['blog_title'];
			if( isset( $_POST['language'] ) && file_exists( './languages/' . $_POST['language'] . '.php' ) ) $settings_save['language'] = $_POST['language'];
			if( !empty( $_POST['time_format'] ) ) $settings_save['time_format'] = $_POST['time_format'];
			if( isset( $_POST['time_offset'] ) && is_numeric( $_POST['time_offset'] ) && in_array( $_POST['time_offset'], $time_zones ) ) $settings_save['time_offset'] = $_POST['time_offset'];
			if( isset( $_POST['limit_blog_entries'] ) && is_numeric( $_POST['limit_blog_entries'] ) && $_POST['limit_blog_entries'] > 0 ) $settings_save['limit_blog_entries'] = $_POST['limit_blog_entries'];
			if( isset( $_POST['delete_spam'] ) && is_numeric( $_POST['delete_spam'] ) ) $settings_save['delete_spam'] = $_POST['delete_spam'];
			$settings_save['activate_comments'] = ( isset( $_POST['activate_comments'] ) && $_POST['activate_comments'] == 1 ) ? 0 : 1;
			$settings_save['accept_trackback'] = ( isset( $_POST['accept_trackback'] ) && $_POST['accept_trackback'] == 1 ) ? 1 : 0;
			
			if( is_writeable( './.htaccess' ) ) {
				$settings_save['mod_rewrite'] = ( isset( $_POST['mod_rewrite'] ) && $_POST['mod_rewrite'] == 1 ) ? 1 : 0;
				if( $settings_save['mod_rewrite'] != $config['mod_rewrite'] ) {
					if( $settings_save['mod_rewrite'] ) {
						$write = "RewriteEngine On\nRewriteBase " . dirname( $_SERVER['PHP_SELF'] );
						if( substr( dirname( $_SERVER['PHP_SELF'] ), strlen( dirname( $_SERVER['PHP_SELF'] )  ) - 2, 1 ) != '/' ) $write .= '/';
						$write .= "\nRewriteRule ^trackback/ trackback.php [L]\nRewriteRule ^feed/ feed.php [L]\nRewriteRule /$ index.php [L]"; 
					} else {
						$write = '';
					}
					if( yabs_file_write( './.htaccess', '# YABS MOD_REWRITE', $write ) ) {
						$plug->runhook( 'hook_admin_settings_htaccess_saved' );
					} else {
						$tpl->add( 'empty.tpl' );
						$tpl->fillin( 'S_CONTENT', $lang['admin_error_settings_htaccess'] );
					}
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_settings_htaccess'] );
			}
			
			$plug->runhook( 'hook_admin_settings_validating' );
			
			foreach( $settings_save as $key => $val ) {
				$sql = "UPDATE " . TABLE_CONFIG . " SET config_value = '" . $db->escape( $val ) . "' WHERE config_name = '" . $db->escape( $key ) . "';";
				$db->query( $sql );
			}
			
			// Reload the Config from the Server
			$sql = "SELECT
						config_name,
						config_value
					FROM
						" . TABLE_CONFIG . ";";
			$res = $db->query( $sql, __LINE__, __FILE__ );
			$config = array();
			while ( $row = $db->fetch( $res ) ) {
				$config[$row['config_name']] = $row['config_value'];
			}
			
			$tpl->add( 'empty.tpl' );
			$tpl->fillin( 'S_CONTENT', $lang['admin_settings_saved'] );
			
		} else {
			$tpl->add( 'empty.tpl' );
			$tpl->fillin( 'S_CONTENT', $lang['admin_error_invalid_link'] );
		}
	}
	$tpl->add( 'settings.tpl' );
	$tpl->part_seperate( 'E_SETTINGS' );
	
	// blog title
	$tpl->part_load();
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_blog_title'],
		'I_SETTINGS_FORM' => '<input type="test" name="blog_title" value="' . $config['blog_title'] . '" size="40" />',
	) );
	
	// language
	$tpl->part_load();
	$dirs = scandir( './languages/' );
	$languages = '<select name="language">';
	foreach( $dirs as $dir ) {
		if( $dir != '.' && $dir != '..' && substr( $dir, strlen( $dir ) - 4, 4 ) == '.php' ) {
			$languages .= '<option value="' . substr( $dir, 0, strlen( $dir ) - 4 ) . '"';
			if( substr( $dir, 0, strlen( $dir ) - 4 ) == $config['language'] ) {
				$languages .= ' selected="selected"';
			}
			$languages .= '>' . substr( $dir, 0, strlen( $dir ) - 4 ) . '</option>';
		}
	}
	$languages .= '</select>';
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_language'],
		'I_SETTINGS_FORM' => $languages,
	) );
	
	// time format
	$tpl->part_load();
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_time_format'],
		'I_SETTINGS_FORM' => '<input type="test" name="time_format" value="' . $config['time_format'] . '" size="40" />',
	) );
	
	// time_offset
	$tpl->part_load();
	$offsets = '<select name="time_offset">';
	foreach( $time_zones as $zone ) {
		$offsets .= '<option value="' . $zone . '"';
		if( $zone == $config['time_offset'] ) $offsets .= ' selected="selected"';
		$offsets .= '>GMT';
		if( $zone != 0 ) {
			$offsets .= ' ';
			if( $zone > 0 ) $offsets .= '+'; 
			$offsets .= $zone . ' ';
			if( $zone == 1 || $zone == -1 ) {
				$offsets .= $lang['hour'];  
			} else {
				$offsets .= $lang['hours'];
			}
		}
		$offsets .= '</option>';
	}
	$offsets .= "</select>";
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_time_offset'],
		'I_SETTINGS_FORM' => $offsets,
	) );
	
	// limit_blog_entries
	$tpl->part_load();
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_limit_blog_entries'],
		'I_SETTINGS_FORM' => '<input type="text" name="limit_blog_entries" value="' . $config['limit_blog_entries'] . '" size="3" />',
	) );
	
	// activate_comments
	$tpl->part_load();
	$activate_comments = ( $config['activate_comments'] ) ? '' : 'checked="checked" ';
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_activate_comments'],
		'I_SETTINGS_FORM' => '<input type="checkbox" name="activate_comments" value="1" ' . $activate_comments . '/>',
	) );
	
	// acccept_trackback
	$tpl->part_load();
	$accept_trackback = ( $config['accept_trackback'] ) ? 'checked="checked" ' : '';
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_accept_trackback'],
		'I_SETTINGS_FORM' => '<input type="checkbox" name="accept_trackback" value="1" ' . $accept_trackback . '/>',
	) );
	
	// limit_blog_entries
	$tpl->part_load();
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_delete_spam'],
		'I_SETTINGS_FORM' => '<input type="text" name="delete_spam" value="' . $config['delete_spam'] . '" size="3" />',
	) );

	// mod_rewrite
	$tpl->part_load();
	$mod_rewrite = ( $config['mod_rewrite'] ) ? 'checked="checked" ' : '';
	$tpl->fillin_array( array(
		'S_SETTINGS_FORM' => $lang['admin_settings_mod_rewrite'],
		'I_SETTINGS_FORM' => '<input type="checkbox" name="mod_rewrite" value="1" ' . $mod_rewrite . '/>',
	) );
	
	$plug->runhook( 'hook_admin_settings_form' );
	
	// finished
	$tpl->part_unite();
	
	$url = array( 'site' => 'settings', 'yabsonce' => $user->getOnce() );
	$tpl->fillin_array( array(
		'I_SETTINGS_FORM_SUBMIT' => '<input type="submit" name="settings_save" value="' . $lang['save'] . '" />',
		'L_SETTINGS_ACTION' => aurl( $url ),
	) );
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}

?>