<?php

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

$yabs_installer_version = '0.8.0beta2';

$time_zones = array( -12, -11, -10, -9, -8, -7, -6, -5, -4, -3.5, -3, -2, -1, 0, 1, 2, 3, 3.5, 4, 4.5, 5, 5.5, 6, 6.5, 7, 8, 9, 9.5, 10, 11, 12, 13);

function rrm( $path )
{
	/*    make sure the path exists    */
	if(!file_exists($path)) return false;

	/*    If it is a file or link, just delete it    */
	if(is_file($path) || is_link($path)) return @unlink($path);

	/*    Scan the dir and recursively unlink    */
	$files = scandir($path);
	foreach( $files as $filename ) {
		if($filename == '.' || $filename == '..') continue;
		$file = str_replace( '//' , '/', $path . '/' . $filename );
		rrm( $file );
	}

	/*    Remove the parent dir    */
	if( ! @rmdir( $path ) ) return false;
	return true;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
	<head>
		<title>YABS::Install</title>
		<link rel="stylesheet" href="style.css" type="text/css" />
	</head>
	<body>
<?php
	
	echo '<h1>YABS Install</h1>';
	
	switch(@$_POST['step']){
		default:
			echo '<h2>Welcome</h2>';
			echo '<table width="700"><tr><td>';
			echo 'This program will guide you through the install.<br />';
			echo 'Press Step 1 to start the install.';
			echo '</tr></td></table><br />';
			echo '<form action="install.php" method="post"><input type="submit" name="step" value="Step 1" /></form>';
			break;
		case 'Step 1':
			// Thanks to s9y for inspiration
			echo '<h2>Step 1: Checking System:</h2>';
			echo '<table width="700">';
			echo '<tr><td width="50%"><b>System</b></td><td width="50%">&nbsp;</td></tr>';
			$error = false;
			
			// OS
			echo '<tr><td>Operation System</td><td>'.php_uname('s').' '.php_uname('r').', '.php_uname('m').'</td></tr>';
			
			// PHP Version
			echo '<tr><td>PHP Version &gt; 5.0.0</td><td>';
			if( version_compare( phpversion(), '5.0.0' ) > 0 ) {
				echo '<span class="ok">OK</span> ('.phpversion().')';
			}else{
				echo '<span class="failed">Failed</span> ('.phpversion().')';
				$error = true;
			}
			echo '</td></tr>';
			
			// DB
			echo '<tr><td>DB Type</td><td>';
			$mysqli = false;
			if(extension_loaded('mysql')){
				echo '<span class="ok">OK</span> (mysql)';
			}else{
				echo '<span class="warning">Warning:</span> YABS only includes a DB layer for mysql. You have to install a 3rd party DB layer for your database type.';
			}
			echo '</td></tr>';
			
			// Session
			echo '<tr><td>Sessions</td><td>';
			if(extension_loaded('session')){
				echo '<span class="ok">OK</span>';
			}else{
				echo '<span class="failed">Failed</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			// zlib
			echo '<tr><td>zlib</td><td>';
			if(extension_loaded('zlib')){
				echo '<span class="ok">OK</span>';
			}else{
				echo '<span class="failed">Failed</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			// simpleXML
			echo '<tr><td>simpleXML</td><td>';
			if(extension_loaded('simplexml')){
				echo '<span class="ok">OK</span>';
			}else{
				echo '<span class="failed">Failed</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			/*
			echo '<table width="700">';
			echo '<tr><td width="50%"><b>php.ini</b></td><td width="50%">&nbsp;</td></tr>';
			
			// safe_mode
			echo '<tr><td>safe_mode</td><td>';
			if(!ini_get('safe_mode')){
				echo '<span class="ok">OFF</span>';
			}else{
				echo '<span class="warning">ON</span> (OFF)';
			}
			echo '</td></tr>';
			
			// register_globals
			echo '<tr><td>register_globals</td><td>';
			if(!ini_get('register_globals')){
				echo '<span class="ok">OFF</span>';
			}else{
				echo '<span class="warning">ON</span> (OFF)';
			}
			echo '</td></tr>';
			*/

			// URL fopen
			echo '<tr><td>allow_url_fopen</td><td>';
			if(ini_get('allow_url_fopen')){
				echo '<span class="ok">ON</span>';
			}else{
				echo '<span class="failed">OFF</span> (ON)';
				$error = true;
			}

			echo '</td></tr>';
			echo '</table><br />';
			
		
			echo '<table width="700">';
			echo '<tr><td width="50%"><b>Permissions</b></td><td width="50%">&nbsp;</td></tr>';
			
			// Config
			echo '<tr><td>';
			if(file_exists('../includes/config.php')){
				echo 'includes/config.php</td><td>';
				if(is_writeable('../includes/config.php')){
					echo '<span class="ok">Writeable</span>';
				}else{
					echo '<span class="failed">Not writeable</span>';
					$error = true;
				}
			} else {
				echo 'includes/</td><td>';
				if(is_writeable('../includes/')){
					echo '<span class="ok">Writeable</span>';
				}else{
					echo '<span class="failed">Not writeable</span>';
					$error = true;
				}
			}
			echo '</td></tr>';
			
			echo '<tr><td>.htaccess</td><td>';
			if(is_writeable('../.htaccess')){
				echo '<span class="ok">Writeable</span>';
			}else{
				echo '<span class="warning">Not writeable</span> (turning on mod_rewrite won\'t work)';
			}
			echo '</td></tr>';
			
			echo "<tr><td>images/</td><td>";
			if(is_writeable('../images')){
				echo '<span class="ok">Writeable</span>';
			}else{
				echo '<span class="warning">Not writeable</span> (uploading files with the buildin filemanager won\'t work ';
			}
			echo "</td></tr>";
			
			echo '</table>';
			
			
			if(!$error){
				echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
			}
			break;
		case 'Step 2':
			echo '<h2>Step 2: Config</h2>';
			if(file_exists('../includes/config.php') && filesize('../includes/config.php')){
				include('../includes/config.php');
			}
			echo '<form action="install.php" method="post">';
			
			// DB Config
			echo '<table width="700">';
			echo '<tr><td width="15%"><b>Database</b></td><td width="85%">&nbsp;</td></tr>';
			
			// DB Hoste
			echo '<tr><td>Host:</td><td><input type="text" name="dbhost" size="50" ';
			if(!empty($dbhost)){
				echo ' value="'.$dbhost.'" ';
			}else{
				echo ' value="localhost" ';
			}
			echo '/></td></tr>';
			
			// DB User
			echo '<tr><td>User:</td><td><input type="text" name="dbuser" size="50" ';
			if(!empty($dbuser)){
				echo ' value="'.$dbuser.'" ';
			}
			echo '/></td></tr>';
			
			// DB Pass
			echo '<tr><td>Pass:</td><td><input type="password" name="dbpass" size="50" ';
			if(!empty($dbpass)){
				echo ' value="'.$dbpass.'" ';
			}
			echo '/></td></tr>';
			
			// DB Name
			echo '<tr><td>Database:</td><td><input type="text" name="dbname" size="50" ';
			if(!empty($dbname)){
				echo ' value="'.$dbname.'" ';
			}
			echo '/></td></tr>';
			
			// DB Prefix
			echo '<tr><td>Prefix:</td><td><input type="text" name="dbprefix" size="50" ';
			if(!empty($dbprefix)){
				echo ' value="'.$dbprefix.'" ';
			}else{
				echo ' value="yabs_"';
			}
			echo '/></td></tr>';
			
			echo '</table><br />';
			/*
			// mod_rewrite Config
			echo '<table width="700">';
			echo '<tr><td width="15%"><b>Other</b></td><td width="85%">&nbsp;</td></tr>';
			echo '<tr><td>mod_rewrite</td><td><input type="checkbox" name="mod_rewrite" value="true" ';
			if(defined('MOD_REWRITE') && MOD_REWRITE){
				echo 'checked="checked" ';
			}
			echo '/></td></tr>';
			//echo '<tr><td>&nbsp;</td><td>Remember to edit your .htaccess file.</td></tr>';
			
			echo '</table><br />';
			*/
			/*
			if(!empty($yabs_version)){
				echo '<input type="hidden" name="yabs_old_version" value="'.$yabs_version.'" />';
			}*/
			if(!empty($dbtype)){
				echo '<input type="hidden" name="dbtype" value="'.$dbtype.'" />';
			}
			echo '<input type="submit" name="step" value="Step 3" /></form>';
			break;
		case 'Step 3':
			echo '<h2>Step 3: Write Config</h2>';
			echo '<table width="700">';
			$error = '';
			if(empty($_POST['dbhost'])) $error .= 'No DB-Host<br />';
			if(empty($_POST['dbuser'])) $error .= 'No DB-User<br />';
			if(empty($_POST['dbpass'])) $error .= 'No DB-Pass<br />';
			if(empty($_POST['dbname'])) $error .= 'No DB-Name<br />';
			if(empty($_POST['dbprefix'])) $error .= 'No DB-Prefix<br />';
			if(empty($error)){
				$error = false;
				if(extension_loaded('mysql')){
					echo '<tr><td width="50%">Testing DB settings:</td><td>';
					if($mysql = @mysql_connect($_POST['dbhost'], $_POST['dbuser'], $_POST['dbpass'])){
						if(mysql_select_db($_POST['dbname'])){
							mysql_close($mysql);
							echo '<span class="ok">Passed</span></td></tr>';
						}else{
							echo '<span class="failed">Failed:</span> '.mysql_error().'</td></tr></table>';
							echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
							$error = true;
						}
					}else{
						echo '<span class="failed">Failed:</span> '.mysql_error().'</td></tr></table>';
						echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
						$error = true;
					}
				}
				if(!$error){
					echo '<tr><td width="50%">Writing config</td><td>';
					$f = fopen('../includes/config.php', 'w');
					fwrite($f, '<?php'."\n");
					fwrite($f, '$dbhost = "'.$_POST['dbhost'].'";'."\n");
					fwrite($f, '$dbuser = "'.$_POST['dbuser'].'";'."\n");
					fwrite($f, '$dbpass = "'.$_POST['dbpass'].'";'."\n");
					fwrite($f, '$dbname = "'.$_POST['dbname'].'";'."\n");
					fwrite($f, '$dbprefix = "'.$_POST['dbprefix'].'";'."\n");
					if(!empty($_POST['dbtype'])) $dbtype = $_POST['dbtype'];
					else $dbtype = 'mysql';
					fwrite($f, '$dbtype = "'.$dbtype.'";'."\n");
					if(strtolower(substr(php_uname('s'), 0, 3)) == 'win'){
						fwrite($f, 'define(\'WINDOWS\', true);'."\n");
					}
					fwrite($f, '?>');
					fclose($f);/*
					if(!empty($_POST['mod_rewrite']) && $_POST['mod_rewrite'] == 'true'){
						$f = fopen( '../.htaccess', 'w+' );
						fwrite( $f, 'RewriteEngine on
RewriteBase /yabs/
RewriteRule ^trackback/ trackback.php [L]
RewriteRule ^feed/ feed.php [L]
RewriteRule /$ index.php [L]');
						fclose( $f );
					} */
					echo '<span class="ok">Done</span></td></tr>';
					echo '</table>';
					echo '<br /><form action="install.php" method="post">';
					/*
					if(!empty($_POST['yabs_old_version'])){
						echo '<input type="hidden" name="yabs_old_version" value="'.$_POST['yabs_old_version'].'" />';
					}*/
					echo '<input type="submit" name="step" value="Step 4" /></form>';
					
				}
			}else{
				echo '<tr><td><b>An error occured:</b><br />'.$error.'</td></tr></table>';
				echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
			}
			break;
		case 'Step 4':
			echo '<h2>Step 4: Installing database</h2>';
			echo '<table width="700">';
			$querys = array();
			define( 'INSIDE', true );
			include('../includes/config.php');
			include('../includes/tables.php');
			include('../includes/functions.php');
			include('../includes/class.' . $dbtype . '.php');
			$db = new $dbtype( $dbhost, $dbuser, $dbpass, $dbname );
			$res = $db->query( "SHOW TABLES"  );
			while( $row = $db->fetch_row( $res ) ) {
				if( $dbprefix . 'config' == $row[0] ) {
					$res = $db->query( "SELECT config_value FROM " . TABLE_CONFIG . " WHERE config_name = 'version';" );
					if( $db->numrows( $res ) ) {
						$row = $db->fetch( $res );
						$config['version'] = $row['config_value'];
					}
					break;
				}
			}
			if( empty( $config['version'] ) ) {
				include('db/install.php');
				$error = false;
				foreach($querys as $sql){
					echo '<tr><td><b>Executin query #'.($db->status('querynum')).'</b><br /><span style="font-family: Courier New;">'.nl2br($sql).'</span>';
					if($db->query($sql, __LINE__, __FILE__, false)){
						echo '<br /><span class="ok">Done</span><br />&nbsp;';
					}else{
						echo '<br /><span class="failed">Failed</span><br /><b>Error:</b> '.$db->status('error').'<br /><b>Errno:</b> '.$db->status('errno').'</td></tr>';
						$error = true;
						break;
					}
					echo '</td></tr>';
				}
				echo '</table>';
				if(!$error){
					echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 5" /></form>';
				}
			}else{
				// Hier kommt die Update-Funktion hin
				while( file_exists( './db/' . $config['version'] . '.php' ) ) {
					$querys = NULL;
					include( './db/' . $config['version'] . '.php' );
					foreach($querys as $sql){
						echo '<tr><td><b>Executin query #'.($db->status('querynum')).'</b><br /><span style="font-family: Courier New;">'.nl2br($sql).'</span>';
						if($db->query($sql, __LINE__, __FILE__, false)){
							echo '<br /><span class="ok">Done</span><br />&nbsp;';
						}else{
							echo '<br /><span class="failed">Failed</span><br /><b>Error:</b> '.$db->status('error').'<br /><b>Errno:</b> '.$db->status('errno').'</td></tr>';
							$error = true;
							break;
						}
						echo '</td></tr>';
					}
					$config['version'] = $next_version;
				}
				echo '</table>';
				if(!$error){
					echo '<br /><form action="http://'.$_SERVER['HTTP_HOST'].substr(dirname($_SERVER['PHP_SELF']), 0, strlen(dirname($_SERVER['PHP_SELF']))-7).'" method="post"><input type="submit" name="step" value="Finish" /></form>';
				}
			}
			break;
		case 'Step 5':
			define( 'INSIDE', true );
			include('../includes/config.php');
			include('../includes/tables.php');
			include('../includes/class.' . $dbtype . '.php');
			$db = new $dbtype( $dbhost, $dbuser, $dbpass, $dbname );
			$config = $db->query('SELECT * FROM ' . TABLE_USER);
			if($db->numrows($config)){
				echo '<a href="http://'.$_SERVER['HTTP_HOST'].substr(dirname($_SERVER['PHP_SELF']), 0, strlen(dirname($_SERVER['PHP_SELF']))-7).'">Blog</a>';
			}else{
				echo '<h2>Step 5: Configuring blog</h2>';
				
				echo '<form action="install.php" method="post"><table width="700">';				
				echo '<tr><td width="20%"><b>Config</b></td><td width="80%">&nbsp;</td>';
				echo '<tr><td>Blogname:</td><td><input type="text" name="title" size="50" /></td></tr>';
				echo '<tr><td>Timeformat:</td><td><input type="text" name="time_format" size="50" value="%m-%d-%Y %H:%M" /></td></tr>';
				
				// time_offset
				echo '<tr><td>Timezone:</td><td>';
				echo '<select name="time_offset">';
				foreach( $time_zones as $zone ) {
					echo '<option value="' . $zone . '"';
					if( $zone == 0 ) echo ' selected="selected"';
					echo '>GMT';
					if( $zone != 0 ) {
						echo ' ';
						if( $zone > 0 ) echo '+'; 
						echo $zone . ' ';
						if( $zone == 1 || $zone == -1 ) {
							echo $lang['hour'];  
						} else {
							echo $lang['hours'];
						}
					}
					echo '</option>';
				}
				echo "</select></td></tr>";
				
				echo '<tr><td>Language:</td><td>';
				$dirs = scandir( '../languages/' );
				echo '<select name="language">';
				foreach( $dirs as $dir ) {
					if( $dir != '.' && $dir != '..' && substr( $dir, strlen( $dir ) - 4, 4 ) == '.php' ) {
						echo '<option value="' . substr( $dir, 0, strlen( $dir ) - 4 ) . '">' . substr( $dir, 0, strlen( $dir ) - 4 ) . '</option>';
					}
				}
				echo '</select></td></tr>';
				
				echo '</table><br />';
				
				echo '<table width="700">';				
				echo '<tr><td width="20%"><b>User</b></td><td width="80%">&nbsp;</td>';
				echo '<tr><td>Name:</td><td><input type="text" name="user_name" size="50" /></td></tr>';
				echo '<tr><td>Email:</td><td><input type="text" name="user_mail" size="50" /></td></tr>';
				echo '<tr><td>Password:</td><td><input type="password" name="user_pass" size="50" /></td></tr>';
				echo '<tr><td>Password (again):</td><td><input type="password" name="user_pass2" size="50" /></td></tr>';
				echo '</table><br />';
				
				echo '<input type="submit" name="step" value="Step 6" /></form>';
			}
			break;
		case 'Step 6':
			define( 'INSIDE', true );
			include('../includes/config.php');
			include('../includes/functions.php');
			include('../includes/tables.php');
			include('../includes/class.' . $dbtype . '.php');
			$db = new $dbtype( $dbhost, $dbuser, $dbpass, $dbname );
			//$config = $db->query('SELECT * FROM '.$dbprefix.'config');
			echo '<table width="700">';	
			
			$error = '';
			if(empty($_POST['title'])) $error .= 'No title<br />';
			if(empty($_POST['time_format'])) $error .= 'No timeformat<br />';
			if( !isset( $_POST['time_offset'] ) || !is_numeric( $_POST['time_offset'] ) || !in_array( $_POST['time_offset'], $time_zones ) ) {
				$error .= 'Invalid timezone<br />';
			}
			if( !isset( $_POST['language'] ) || !file_exists( '../languages/' . $_POST['language'] . '.php' ) ) $error .= 'Invalid language<br />';
			
			if( empty( $_POST['user_name'] ) ) $error .= 'No username<br />';
			if(empty($_POST['user_mail'])){
				$error .= 'No email<br />';
			}else{
				if(!checkmail(trim($_POST['user_mail']))) $error .= 'Invalid email<br />';
			}
			if( empty($_POST['user_pass'] ) ) {
				$error .= 'No password<br />';
			} else {
				if( empty( $_POST['user_pass2'] ) || $_POST['user_pass'] != $_POST['user_pass'] ) {
					$error .= 'Password didn\'t match<br />';
				}
			}
			
			if( empty( $error ) ) {
				$querys = array();
				$querys[] = "UPDATE `" . TABLE_CONFIG . "`
SET
	config_value = '" . $db->escape( $_POST['title'] ) . "'
WHERE
	config_name = 'blog_title';";
			
				$querys[] = "UPDATE `" . TABLE_CONFIG . "`
SET
	config_value = '" . $db->escape( $_POST['time_format'] ) . "'
WHERE
	config_name = 'time_format';";
			
				$querys[] = "UPDATE `" . TABLE_CONFIG . "`
SET
	config_value = '" . $db->escape( $_POST['time_offset'] ) . "'
WHERE
	config_name = 'time_offset';";
				$querys[] = "UPDATE `" . TABLE_CONFIG . "`
SET
	config_value = '" . $db->escape( $_POST['language'] ) . "'
WHERE
	config_name = 'language';";
			
				$querys[] = "INSERT INTO " . TABLE_USER  . " (
	user_name,
	user_mail,
	user_password,
	user_cookie
) VALUES (
	'" . $db->escape( trim( $_POST['user_name'] ) ) . "',
	'" . $db->escape( trim( $_POST['user_mail'] ) ). "',
	'" . md5( $_POST['user_pass'] ) . "',
	'" . md5( microtime() ) . "'
);";

				
				$error = false;
				foreach($querys as $sql){
					echo '<tr><td><b>Executin query #'.($db->status('querynum')+1).'</b><br /><span style="font-family: Courier New;">'.nl2br($sql).'</span>';
					if($db->query($sql, __LINE__, __FILE__, false)){
						echo '<br /><span class="ok">Done</span><br />&nbsp;';
					}else{
						echo '<br /><span class="failed">Failed</span><br /><b>Error:</b> '.$db->status('error').'<br /><b>Errno:</b> '.$db->status('errno').'</td></tr>';
						$error = true;
						break;
					}
					echo '</td></tr>';
				}
				echo '</table>';
				
				if(!$error){
					
					if( !rrm( '../install' ) ) {
						echo '<br /><table width="700">';
						echo '<tr><td>Delete install/ and press finish.</td></tr>';
						echo '</table>';
					}
					
					echo '<br /><form action="http://'.$_SERVER['HTTP_HOST'].substr(dirname($_SERVER['PHP_SELF']), 0, strlen(dirname($_SERVER['PHP_SELF']))-7).'" method="post"><input type="submit" name="step" value="Finish" /></form>';
				}
			}else{
				echo '<tr><td><b>An error occured:</b><br />'.$error.'</td></tr></table>';
				echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 5" /></form>';
			}
			break;
	}

?>
	</body>
</html>