<?php

/*
 * yabs - Yet another blog system
 * ==============================
 * (c) 2005 - 2007 by Daniel Triendl <daniel@tac-ops.net>
 * http://yabs.tac-ops.net
 */

/*
 * @name: index.php
 * @desc: Main site
 * @created: May 11, 2005
 * @author: Daniel Triendl <daniel@tac-ops.net>
 * @copy: 2005-2007 yabs
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

define( 'INSIDE', true );

require('./includes/init.php');

// Init template
$tpl = new template( './templates/' . $config['template'] );
$tpl->add( 'header.tpl' );
	
if( isset( $_GET['site'] ) AND isset( $site[$_GET['site']] ) ) {
	require( $site[$_GET['site']] );
} else {
	require( $site['default'] );
}

	
//Add footer
$tpl->add( 'footer.tpl' );

$tpl->fillin('RSS20_HEAD', '');
$tpl->fillin('RSS10_HEAD', '');
$tpl->fillin('ATOM03_HEAD', '');

$tpl->part_seperate( 'E_SIDEBAR' );

$plug->runhook( 'hook_index_sidebar' );

$tpl->part_unite();

// Menu
$sql = "SELECT
			menu_name,
			menu_url
		FROM
			" . TABLE_MENU . "
		ORDER BY
			menu_order ASC;";
$res = $db->query( $sql );
$tpl->part_seperate( 'E_MENU' );
$first = true;
while( $row = $db->fetch( $res ) ) {
	$tpl->part_load();
	if( 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] == $row['menu_url'] && !$first) {
		$tpl->fillin_array( array(
			'S_MENU_SELECTED' => 'id="selected"',
			'S_MENU_SELECTED_FIRST' => '',
		) );
	} else {
		if( $first ) {
			$first = false;
			$tpl->fillin( 'S_MENU_SELECTED', '{S_MENU_SELECTED_FIRST}' );
		} else {
			$tpl->fillin( 'S_MENU_SELECTED', '' );
		}
	}
	$tpl->fillin( 'S_MENU_NAME', $row['menu_name'] );
	$tpl->fillin( 'L_MENU_URL', $row['menu_url'] );
}
$tpl->part_unite();
$tpl->fillin_array( array(
	'S_MENU_SELECTED_FIRST' => 'id="selected"',
) );
$db->free( $res );

$feed_entries = url();
if( $config['mod_rewrite'] ) {
	$feed_entries .= 'feed/';
} else {
	$feed_entries .= 'feed.php';
}

//Fillin some vars
$tpl->fillin_array( array(
	'S_BLOG_TITLE' => html2txt( $config['blog_title'] ),
	'S_QUERYNUM' => $db->status( 'querynum' ),
	'L_HOME' => url(),
	'L_TRUE_HOME' => site_true_home(),
	'S_ADMINPANEL' => '<a href="' . site_true_home() . '/admin.php">' . $lang['adminpanel'] . '</a>',
	'S_FEED_ENTRIES' => '<a href="' . $feed_entries . '">' . $lang['entries'] . '</a>',
) );
	
$db->disconnect();
	
//Calcualte Rendertime	
$rendertime = round( array_sum( explode( ' ', microtime() ) ) - $rendertime_start, 4 );
$tpl->fillin( 'S_RENDER_FILLIN', $rendertime );
	
// +-----------------------------------------------------+
// | Send Header                                         |
// +-----------------------------------------------------+
if( !headers_sent() ) {
	//header('X-Blog: yabs '.$yabs->get_version());
	header( 'Cache-control: private, pre-check=0, post-check=0, max-age=0' );
	header( 'Pragma: no-cache' );
	header( 'Expires: 0' );
	header( 'Content-Type: text/html; charset=' . $lang['charset'] );
}
	
$tpl->output();

?>