<?php
/*
 * @name: class.trackback.php
 * @desc: 
 * @created: February 09, 2007
 * @author: Daniel Triendl <daniel@tac-ops.net>
 * @copy: 2007 yabs
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class trackback extends socket {
	
	public function __construct()
	{
		
	}
	
	/*
	 * Error codes:
	 * 0 - No error
	 * 1 - Connection failed
	 * 2 - Invalid answer
	 * 3 - No errormessage
	 */
	
	public function sendTrackback( $url, $from, $blog_name = '', $title = '', $excerpt = '' )
	{
		$target = $this->makeTarget( $url );
		if( !$this->connect( $target['host'] ) ) {
			return 1;
		}

		$data = 'url=' . urlencode( $from );
		$data .= '&blog_name=' . urlencode( $blog_name );
		$data .= '&title=' . urlencode( $title );
		$data .= '&excerpt=' . urlencode( $excerpt );

		$this->write( 'POST ' . $target['path'] . $target['query'] . ' HTTP/1.1' . "\r\n");
		$this->write( 'Host: ' . $target['host'] . "\r\n" );
		$this->write( 'Content-type: application/x-www-form-urlencoded' . "\r\n" );
		$this->write( 'Content-length: ' . strlen( $data ) . "\r\n" );
		$this->write( 'User-agent: MoveableType (yabs)' . "\r\n");
		$this->write( 'Connection: Close' . "\r\n\r\n" );
		$this->write( $data );
		
		$return = $this->read( 4 );
		$this->disconnect();
		
		if ( preg_match( '#<error>(.*)</error>#U', $return, $errno ) ) {
			if ( $errno[1] == '0' ) {
				return 0;
			} else {
				if ( preg_match( '#<message>(.*)</message>#U', $return, $error ) ) {
					return $error[1];
				} else {
					return 3;
				}
			}
		} else {
			return 2;
		}
	}
	
	private function makeTarget( $url )
	{
		$target = parse_url( $url );
		if ( empty( $target['query'] ) ) {
			$target['query'] = '';
		} else {
			$target['query'] = '?' . $target['query'];
		}
		$taget['path'] = ( !empty( $target['path'] ) ) ? $target['path'] : '/';
		return $target;
	}
}

?>