<?php

/*
 * @name: class.mysql.php
 * @desc:
 * @created: March 24, 2007
 * @author: Daniel Triendl <daniel@tac-ops.net>
 * @copy: 2007 yabs
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class mysql {
	
    protected $_dbhandler = 0;
    private $_querynum = 0;
    private $_author = 'Daniel Triendl';
    private $_version = '1.0.2';

    public function __construct( $dbhost, $dbuser, $dbpass, $dbname )
    {
        $this->_dbhandler = mysql_connect( $dbhost, $dbuser, $dbpass );
        if ( $this->_dbhandler ) {
            $result = mysql_select_db( $dbname, $this->_dbhandler );
            if ( $result == false ) {
                $this->raise_error( 'Can\'t select database (' . $dbname . ').', 'database', __LINE__ );
            } 
        } else {
            $this->raise_error( 'Can\'t open database connection. ' . mysql_error(), 'database', __LINE__ );
        } 
    }

    public function query( $sql = '', $line=__LINE__, $file=__FILE__, $die = true )
    {
        $sql = trim( $sql );
        $result = mysql_query( $sql, $this->_dbhandler );
        if ( $result == false && $die ) {
            $this->raise_error( mysql_error( $this->_dbhandler ) . '<br /><b>Errno:</b> ' . 
				mysql_errno( $this->_dbhandler ), 'query', $line, $file, $sql );
        } 

        $this->_querynum++;
        return $result;
    } 

    public function fetch( $result )
    {
        if ( is_resource( $result ) ) {
            return mysql_fetch_assoc( $result );
        } else {
            $this->raise_error( 'Got invalid ressource.', 'fetch', __LINE__ );
        } 
    }
    
    public function fetch_row( $result ) 
{
        if ( is_resource( $result ) ) {
            return mysql_fetch_row( $result );
        } else {
            $this->raise_error( 'Got invalid ressource.', 'fetch', __LINE__ );
        } 
    }
    
    public function numrows( $result )
    {
        if ( is_resource( $result ) ) {
            return mysql_num_rows( $result );
        } else {
            $this->raise_errpr( 'Got invalid ressource.', 'numrows', __LINE__ );
        } 
    } 

    public function free( $result )
    {
        if ( is_resource( $result ) ) {
            mysql_free_result( $result );
        } else {
            $this->raise_error( 'Got invalid ressource.', 'free', __LINE__ );
        } 
    } 

    public function disconnect()
    {
        if ( $this->_dbhandler ) {
            mysql_close( $this->_dbhandler );
            $this->_dbhandler = 0;
        } else {
            $this->raise_errpr( 'No MySQL connection active.', 'disconnect', __LINE__ );
        } 
    } 

    public function status( $element = false )
    {
        $return['file'] = __FILE__;
        $return['version'] = $this->_version;
        $return['author'] = $this->_author;
        $return['querynum'] = $this->_querynum;
        $return['error'] = mysql_error( $this->_dbhandler );
        $return['errno'] = mysql_errno( $this->_dbhandler );
        $return['database'] = 'mysql';
        if ( $this->_dbhandler ) {
            $return['active'] = 1;
        } else {
            $return['active'] = 0;
        } 

        if ( $element != false && isset( $return[$element] ) ) {
            return $return[$element];
        } else {
            return $return;
        } 
    } 

    protected function raise_error( $error = '', $function = '', $line = __LINE__, $file=__FILE__, $sql = '' )
    {
        $msg = '<h1>An error occured</h1>';
        $msg .= '<b>Error:</b> ' . $error . '<br />';
        $msg .= '<b>Function:</b> database::' . $function . '()<br />';
        $msg .= '<b>File:</b> ' . $file . '<br />';
        $msg .= '<b>Line:</b> ' . $line . '<br />';
        if ( !empty( $sql ) ) {
            $msg .= '<b>Query:</br><pre>' . $sql . '</pre><br />';
        } 
        die( $msg );
    }
    
    public function escape( $str )
    {
    	if ( $this->_dbhandler ){
    		if ( get_magic_quotes_gpc() ) {
          	  $str = stripslashes( $str );
        	}
        	return mysql_real_escape_string( $str, $this->_dbhandler );
    	} else {
    		$this->raise_error( 'No MySQL connection active.', 'escape', __LINE__ );
    	}
    }
} 

?>