<?php
/*
 * name		user.php
 * begin	May 04, 2007
 * 
 * $Id: user.php 17 2008-02-24 17:14:09Z Trellmor $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if(  !$user->getRight('user' ) ) {
	$_GET['action'] = 'edit';
	$_GET['user_id'] = $user->getuser_id();
}

// Extend $rights this with your own rights
//  remember to also set $lang['admin_user_right_yourright']
$rights = array(
	'entry',
	'entry_other',
	'plugins',
	'links',
	'settings',
	'user',
	'comments',
	'fm_upload',
	'fm_modify',
);

/*
 * Allowed types:
 *  - bool (0|1) (default: 0)
 *  - string (default: )
 *  - number ([0-9]+) (default: 0)
 *  - array with select values ( array( 'value1' => 'Description1', 'value2' => 'Description2', 'value3' => 'Description3' ); )
 *     You should use the correct language for description, if you have translations
 *     (default: won't be set)
 * yabs will look in $lang for a key named admin_user_config_TheName (e.g admin_user_config_use_wysiwyg
 */
$user_config = array(
	'use_wysiwyg' => 'bool',
//	'teststring' => 'string',
//	'testnumber' => 'number',
//	'testarray' => array( 'foo' => 'footext', 'bar' => 'bartext' ),
);

$plug->runhook( 'hook_admin_user_init' );

if( !count( $_POST) || ( isset( $_GET['yabsonce'] ) && $_GET['yabsonce'] == $user->getOnce() ) ) {
	switch( @$_GET['action'] ) {
		case 'edit':	
			if( isset( $_GET['user_id'] ) && is_numeric( $_GET['user_id'] ) ) {				
				$sql = "SELECT
							user_id,
							user_name,
							user_mail
						FROM
							" . TABLE_USER . "
						WHERE
							user_id = '" . $db->escape( $_GET['user_id'] ) . "';";
				$res = $db->query( $sql );
				if( $db->numrows( $res ) ) {
					$row = $db->fetch( $res );
					$db->free( $res );
					$_GET['user_id'] = $row['user_id'];
					$user_error = array();
					
					// Save
					if( isset( $_POST['user_edit_submit'] ) ) {
						$user_sql = "UPDATE " . TABLE_USER . " SET ";
						if( $user->getRight('user' ) ) {
							// Check user_name
							if( !empty( $_POST['user_name'] ) ) {
								$sql = "SELECT user_id FROM " . TABLE_USER . " WHERE user_name = '" . $db->escape( $_POST['user_name'] ) . "' and user_id != '" . $db->escape( $_GET['user_id'] ) . "';";
								$res = $db->query( $sql );
								if( !$db->numrows( $res ) ) {
									$user_sql .= "user_name = '" . $db->escape( $_POST['user_name'] ) . "',";
								} else {
									$user_error['user_name'] = $lang['admin_error_user_name'];
								}
								$db->free( $res );
							} else {
								$user_error['user_name'] = $lang['admin_error_user_name'];
							}
						} else {
							// Check user_password
							$sql = "SELECT user_id FROM " . TABLE_USER . " WHERE user_id = '" . $db->escape( $_GET['user_id'] ). "' and user_password = '" . md5( $_POST['user_password'] ) . "';";
							$res = $db->query( $sql );
							if( !$db->numrows( $res ) ) {
								$user_error['user_password'] = $lang['admin_error_user_password'];
							}
							$db->free( $res );
						}
						
						// Check new password
						$user_logout = false;
						if( !empty( $_POST['user_password_new'] ) ) {
							if(  !empty( $_POST['user_password_new2'] ) && $_POST['user_password_new'] == $_POST['user_password_new2'] ) {
								$user_sql .= "user_password = '" . md5( $_POST['user_password_new'] ) . "', user_cookie = '" . md5( microtime() ) . "', user_session = '', ";
								if( $_GET['user_id'] == $user->getuser_id() ) $user_logout = true;
							} else {
								$user_error['user_password_new'] = $lang['admin_error_user_password_new'];
							}
						}
						
						if( !empty( $_POST['user_mail'] ) && checkmail( $_POST['user_mail'] ) ) {
							$user_sql .= "user_mail = '" . $db->escape( $_POST['user_mail'] ) . "' ";
						} else {
							$user_error['user_mail'] = $lang['error_mail'];
						}
						
						// settings
						if( $_GET['user_id'] == $user->getuser_id() ) {
							$ucfg_sql1 = "DELETE FROM " . TABLE_USER_CONFIG . " WHERE user_id = '" . $db->escape( $_GET['user_id'] ) . "' and user_permission = '0';";
							$ucfg_sql2 = '';
							foreach( $user_config as $uconf => $utype ) {
								if( is_array( $utype ) ) {
									if( isset( $_POST[$uconf] ) && isset( $utype[$_POST[$uconf]] ) ) {
										$ucfg_sql2 .= "\n('" . $db->escape( $_GET['user_id'] ) . "', '" . $db->escape( $uconf ) . "', '" . $db->escape( $_POST[$uconf] ) . "', '0'),";
									}
								}
								switch( $utype ) {
									case 'bool':
										if( isset( $_POST[$uconf] ) ) {
											$ucfg_sql2 .= "\n('" . $db->escape( $_GET['user_id'] ) . "', '" . $db->escape( $uconf ) . "', '1', '0'),";
										} else {
											$ucfg_sql2 .= "\n('" . $db->escape( $_GET['user_id'] ) . "', '" . $db->escape( $uconf ) . "', '0', '0'),";
										}
										break;
									case 'string':
										if( isset( $_POST[$uconf] ) ) {
											$ucfg_sql2 .= "\n('" . $db->escape( $_GET['user_id'] ) . "', '" . $db->escape( $uconf ) . "', '" . $db->escape( $_POST[$uconf] ) . "', '0'),";
										} else {
											$ucfg_sql2 .= "\n('" . $db->escape( $_GET['user_id'] ) . "', '" . $db->escape( $uconf ) . "', '', '0'),";
										}
										break;
									case 'number':
										if( isset( $_POST[$uconf] ) && is_numeric( $_POST[$uconf] ) ) {
											$ucfg_sql2 .= "\n('" . $db->escape( $_GET['user_id'] ) . "', '" . $db->escape( $uconf ) . "', '" . $db->escape( $_POST[$uconf] ) . "', '0'),";
										} else {
											$ucfg_sql2 .= "\n('" . $db->escape( $_GET['user_id'] ) . "', '" . $db->escape( $uconf ) . "', '0', '0'),";
										}
										break;
								}
							}
							$db->query( $ucfg_sql1 );
							if( !empty( $ucfg_sql2 ) ) {
								$ucfg_sql2 = "INSERT INTO " . TABLE_USER_CONFIG . " (user_id, user_config_name, user_config_value, user_permission) VALUES" . substr( $ucfg_sql2, 0, strlen( $ucfg_sql2 )- 1 ) . ";";
								$db->query( $ucfg_sql2 );
							}
						}
						
						if( !count( $user_error ) ) {
							$user_sql .= "WHERE user_id = '" . $db->escape( $_GET['user_id'] ) . "';";
							$db->query( $user_sql );
							if( $user->getRight('user' ) && isset( $_POST['user_permissions'] ) && is_array( $_POST['user_permissions'] ) ) {
								$sql = "DELETE FROM " . TABLE_USER_CONFIG . " WHERE user_id = '" . $db->escape( $_GET['user_id'] ) . "' and user_permission = '1';";
								$db->query( $sql );
								foreach( $_POST['user_permissions'] as $right ) {
									if( in_array( $right, $rights ) ) {
										$sql = "INSERT INTO " . TABLE_USER_CONFIG . " (user_id, user_config_name, user_permission) VALUES ('" . $db->escape( $_GET['user_id'] ) ."', '" . $db->escape( $right ) . "', '1');";
										$db->query( $sql );
									}
								}
							}
							if( $user_logout ) {
								session_destroy();
								header('location: ' . aurl() );
								die( 'Was unable to autoredirect.<br /><a href="' . aurl() . '">Continue</a>' );
							} else {
								$tpl->add( 'empty.tpl' );
								$tpl->fillin( 'S_CONTENT', $lang['admin_user_settings_saved'] );
							}
						}
					}
					
					// Edit
					$tpl->add( 'user_form.tpl' );
					$tpl->part_seperate( 'E_USER_FORM' );
					
					// user_name
					$tpl->part_load();
					$tpl->fillin( 'S_USER_FORM', $lang['name'] . ':' );
					if( $user->getRight('user' ) ) {
						if( isset( $user_error['user_name'] ) ) {
							if( isset( $_POST['user_name'] ) )$row['user_name'] = $_POST['user_name'];
							$tpl->fillin( 'I_USER_FORM', '<input type="text" name="user_name" class="yabs_form_error" value="' . $row['user_name'] . '" />' );
							$tpl->fillin( 'S_USER_FORM_ERROR', $user_error['user_name'] );
						} else {
							$tpl->fillin( 'I_USER_FORM', '<input type="text" name="user_name" value="' . $row['user_name'] . '" />' );
							$tpl->fillin( 'S_USER_FORM_ERROR', '' );
						}
					} else {
						$tpl->fillin( 'I_USER_FORM', '<b>' . $row['user_name'] . '</b>' );
						$tpl->fillin( 'S_USER_FORM_ERROR', '' );
					}
					
					// user_password (Only if user don't have permission to edit users.)
					if( !$user->getRight('user' ) ) {
						$tpl->part_load();
						$tpl->fillin( 'S_USER_FORM', $lang['password'] . ':' );
						if( isset( $user_error['user_password'] ) ) {
							$tpl->fillin_array( array(
								'S_USER_FORM_ERROR' => $user_error['user_password'], 
								'I_USER_FORM' => '<input type="password" name="user_password" class="yabs_form_error" />',
							) );
						} else {
							$tpl->fillin_array( array(
								'S_USER_FORM_ERROR' => '', 
								'I_USER_FORM' => '<input type="password" name="user_password" />',
							) );
						}
					}
					
					// new password
					$tpl->part_load();
					if( isset( $user_error['user_password_new'] ) ) {
						$user_error_class = ' class="yabs_form_error"';
					} else {
						$user_error_class = '';
					}
					$tpl->fillin_array( array(
						'S_USER_FORM' => $lang['admin_user_newpassword'] . ':',
						'I_USER_FORM' => '<input type="password" name="user_password_new" ' . $user_error_class . '/>',
					) );
					if( isset( $user_error['user_password_new'] ) ) {
						$tpl->fillin('S_USER_FORM_ERROR', $user_error['user_password_new'] );
					} else {
						$tpl->fillin('S_USER_FORM_ERROR', '' );
					}
					$tpl->part_load();
					$tpl->fillin_array( array(
						'S_USER_FORM' => $lang['admin_user_newpassword_again'] . ':',
						'I_USER_FORM' => '<input type="password" name="user_password_new2" ' . $user_error_class . '/>',
						'S_USER_FORM_ERROR' => '',
					) );
					$tpl->part_load();
					$tpl->fillin_array( array(
						'S_USER_FORM' => '&nbsp;',
						'I_USER_FORM' => $lang['admin_user_newpassword_keep'],
						'S_USER_FORM_ERROR' => '',
					) );
					
					// mail
					$tpl->part_load();
					if( isset( $user_error['user_mail'] ) ) {
						if( isset( $_POST['user_mail'] ) ) $row['user_mail'] = $_POST['user_mail'];
						$tpl->fillin_array( array(
							'S_USER_FORM' => $lang['mail'] . ':',
							'I_USER_FORM' => '<input type="text" name="user_mail" value="' . $row['user_mail'] .'" class="yabs_form_error" />',
							'S_USER_FORM_ERROR' => $user_error['user_mail'],
						) );
					} else {
						$tpl->fillin_array( array(
							'S_USER_FORM' => $lang['mail'] . ':',
							'I_USER_FORM' => '<input type="text" name="user_mail" value="' . $row['user_mail'] .'" />',
							'S_USER_FORM_ERROR' => '',
						) );
					}
					
					// settings
					if( $_GET['user_id'] == $user->getuser_id() ) {
						$tpl->part_load();
						$tpl->fillin_array( array(
							'S_USER_FORM' => '&nbsp;',
							'I_USER_FORM' => '&nbsp;',
							'S_USER_FORM_ERROR' => '',
						) );
						$tpl->part_load();
						$tpl->fillin_array( array(
							'S_USER_FORM' => '<strong>' . $lang['admin_user_settings'] . '</strong>',
							'I_USER_FORM' => '',
							'S_USER_FORM_ERROR' => '',
						) );
						foreach( $user_config as $uconf => $type ) {
							$tpl->part_load();
							if( isset( $lang['admin_user_config_' . $uconf] ) ) {
								$tpl->fillin( 'S_USER_FORM', $lang['admin_user_config_' . $uconf] . ':' );
							} else {
								$tpl->fillin( 'S_USER_FORM', $uconf . ':' );
							}
							if( is_array( $type ) ) {
								$select = '<select name="' . $uconf . '">';
								foreach( $type as $tkey => $tval ) {
									$select .= '<option value="' . $tkey . '"';
									if( $user->getConfig( $uconf ) == $tkey ) $select .= ' selected="selected"';
									$select .= '>' . $tval . '</option>';
								}
								$select .= '</select>';
								$tpl->fillin( 'I_USER_FORM', $select );
							}
							switch( $type ) {
								case 'bool':
									$checked = ( $user->getConfig( $uconf ) ) ? ' checked="checked"' : '';
									$tpl->fillin( 'I_USER_FORM', '<input type="checkbox" name="' . $uconf . '" value="1"' . $checked . ' />' );
									break;
								case 'string':
									$string = ( $user->getConfig( $uconf ) !== false ) ? $user->getConfig( $uconf )  : '';
									$tpl->fillin( 'I_USER_FORM', '<input type="text" name="' . $uconf . '" value="' . $string . '" />' );
									break;
								case 'number':
									$number = ( $user->getConfig( $uconf ) !== false && is_numeric( $user->getConfig( $uconf ) ) ) ? $user->getConfig( $uconf ) : 0;
									$tpl->fillin( 'I_USER_FORM', '<input type="text" name="' . $uconf . '" value="' . $number . '" size="10" />' );
									break;
								default:
									$tpl->fillin( 'I_USER_FORM', '' );
							}
						}
					}
					
					// permissions
					if( $user->getRight('user' ) ) {
						if( isset( $_POST['user_permissions'] ) && is_array( $_POST['user_permissions'] ) ) $user_permissions = $_POST['user_permissions'];
						else {
							$user_permissions = array();
							$sql = "SELECT user_config_name FROM " . TABLE_USER_CONFIG . " WHERE user_id = '" . $db->escape( $_GET['user_id'] ). "' and user_permission = '1';";
							$res = $db->query( $sql );
							while( $per = $db->fetch( $res ) ) {
								$user_permissions[] = $per['user_config_name'];
							}
							$db->free( $res );
						}
						$tpl->part_load();
						$tpl->fillin_array( array(
							'S_USER_FORM' => '&nbsp;',
							'I_USER_FORM' => '&nbsp;',
							'S_USER_FORM_ERROR' => '',
						) );
						$tpl->part_load();
						$tpl->fillin_array( array(
							'S_USER_FORM' => '<strong>' . $lang['admin_user_permissions'] . '</strong>',
							'I_USER_FORM' => '',
							'S_USER_FORM_ERROR' => '',
						) );
						
						// Extend $rights this with your own rights
						// remember to also set $lang['admin_user_right_yourright']
						foreach( $rights as $right ) {
							$tpl->part_load();
							if( isset( $lang['admin_user_right_' . $right] ) ) {
								$tpl->fillin( 'S_USER_FORM', $lang['admin_user_right_' . $right] );
							}else {
								$tpl->fillin( 'S_USER_FORM', $right);
							}
							$fillin = '<input type="checkbox" name="user_permissions[]" value="' . $right . '" ';
							if( in_array( $right, $user_permissions ) ) $fillin .= ' checked="checked"';
							$fillin .= '/>';
							$tpl->fillin('I_USER_FORM', $fillin );
							$tpl->fillin('S_USER_FORM_ERROR', '' );
						}
					}
					$tpl->part_unite();
					$url = array(
						'site' => 'user',
						'action' => 'edit',
						'yabsonce' => $user->getOnce(),
						'user_id' => $_GET['user_id'],
					);
					$tpl->fillin_array( array(
						'I_USER_FORM_SUBMIT' => '<input type="submit" name="user_edit_submit" value="' . $lang['save'] . '" />',
						'L_USER_EDIT_ACTION' => aurl( $url ),
					) );
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_user_notfound'] . $lang['back'] );	
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_user_notfound'] . $lang['back'] );
			}
			break;
		case 'delete':
			if ( isset( $_GET['yabsonce'] ) && $_GET['yabsonce'] == $user->getOnce() ) {
				if( isset( $_GET['user_id'] ) && is_numeric( $_GET['user_id'] ) ) {
					$sql = "SELECT
								user_id,
								user_name,
								user_mail
							FROM
								" . TABLE_USER . "
							WHERE
								user_id = '" . $db->escape( $_GET['user_id'] ) . "';";
					$res = $db->query( $sql );
					if( $db->numrows( $res ) ) {
						if( $_GET['user_id'] != $user->getuser_id() ) {
							$sql = "DELETE FROM " . TABLE_USER . " WHERE user_id = '" . $db->escape( $_GET['user_id'] ) . "';";
							$db->query( $sql );
							$sql = "DELETE FROM " . TABLE_USER_CONFIG . " WHERE user_id ='" . $db->escape( $_GET['user_id'] ) . "';";
							$db->query( $sql ); 
							$offset = ( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) && $_GET['start'] >= 0 ) ? $_GET['start'] : 0;
							$continue_url = array( 'site' => 'user', 'action' => 'list', 'start' => $offset );
							//header('Location: ' . aurl( $continue_url, false ) );
							//die( '<a href="' . aurl( $continue_url ) . '">' . $lang['continue'] . '</a>' );
							yabs_redirect( aurl( $continue_url ), $lang['continue'], '', 2 );
						} else {
							$tpl->add( 'empty.tpl' );
							$tpl->fillin( 'S_CONTENT', $lang['admin_error_user_deletehimself'] . $lang['back'] );
						}
					} else {
						$tpl->add( 'empty.tpl' );
						$tpl->fillin( 'S_CONTENT', $lang['admin_error_user_notfound'] . $lang['back'] );	
					}
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_invalid_link'] . $lang['back'] );
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_user_notfound'] . $lang['back'] );
			}
			break;
		case 'add':
			$user_error = array();
			
			if( isset( $_POST['user_add_submit'] ) ) {
				// Check user_name
				if( !empty( $_POST['user_name'] ) ) {
					$sql = "SELECT user_id FROM " . TABLE_USER . " WHERE user_name = '" . $db->escape( $_POST['user_name'] ) . "';";
					$res = $db->query( $sql );
					if( $db->numrows( $res ) ) {
						$user_error['user_name'] = $lang['admin_error_user_name'];
					}
					$db->free( $res );
				} else {
					$user_error['user_name'] = $lang['admin_error_user_name'];
				}
				if( empty( $_POST['user_password'] ) || empty( $_POST['user_password2'] ) || $_POST['user_password'] != $_POST['user_password2'] ) {
					$user_error['user_password'] = $lang['admin_error_user_password_new'];
				}
				if( empty( $_POST['user_mail'] ) || !checkmail( $_POST['user_mail'] ) ) {
					$user_error['user_mail'] = $lang['error_mail'];
				}
				
				// save
				if( !count( $user_error ) ) {
					$sql = "INSERT INTO " . TABLE_USER . " (
								user_name,
								user_mail,
								user_password,
								user_cookie
							) VALUES (
								'" . $db->escape( $_POST['user_name'] ) . "',
								'" . $db->escape( $_POST['user_mail'] ) . "',
								'" . md5( $_POST['user_password'] ) . "',
								'" . md5( microtime() )  . "'
							);";
					$db->query( $sql );
					$sql = "SELECT user_id FROM " . TABLE_USER . " WHERE user_name = '" . $db->escape( $_POST['user_name'] ) . "';";;
					$res = $db->query( $sql );
					$row = $db->fetch( $res );
					$db->free( $res );
					$continue_url = array( 'site' => 'user', 'action' => 'edit', 'user_id' => $row['user_id'] );
					//header('Location: ' . aurl( $continue_url, false ) );
					//die( '<a href="' . aurl( $continue_url ) . '">' . $lang['continue'] . '</a>' );
					yabs_redirect( aurl( $continue_url ), $lang['continue'], '', 2 );
				}
			}
			
			$tpl->add( 'user_form.tpl' );
			$tpl->part_seperate( 'E_USER_FORM' );
			
			// user_name
			$tpl->part_load();
			$tpl->fillin( 'S_USER_FORM', $lang['name'] );
			$user_name = ( isset( $_POST['user_name'] ) ) ? $_POST['user_name'] : '';
			if( isset( $user_error['user_name'] ) ) {
				$user_name = ( isset( $_POST['user_name'] ) ) ? $_POST['user_name'] : '';
				$tpl->fillin( 'I_USER_FORM', '<input type="text" name="user_name" class="yabs_form_error" value="' . $user_name . '" />' );
				$tpl->fillin( 'S_USER_FORM_ERROR', $user_error['user_name'] );
			} else {
				$tpl->fillin( 'I_USER_FORM', '<input type="text" name="user_name" value="' . $user_name . '" />' );
				$tpl->fillin( 'S_USER_FORM_ERROR', '' );
			}
			
			// user_password
			$tpl->part_load();
			if( isset( $user_error['user_password'] ) ) {
				$user_error_class = ' class="yabs_form_error"';
			} else {
				$user_error_class = '';
			}
			$tpl->fillin_array( array(
				'S_USER_FORM' => $lang['password'],
				'I_USER_FORM' => '<input type="password" id="user_password" name="user_password" ' . $user_error_class . '/>',
			) );
			if( isset( $user_error['user_password'] ) ) {
				$tpl->fillin('S_USER_FORM_ERROR', $user_error['user_password'] );
			} else {
				$tpl->fillin('S_USER_FORM_ERROR', '' );
			}
			$tpl->part_load();
			$tpl->fillin_array( array(
				'S_USER_FORM' => $lang['admin_user_password_again'],
				'I_USER_FORM' => '<input type="password" id="user_password2" name="user_password2" ' . $user_error_class . '/>',
				'S_USER_FORM_ERROR' => '',
			) );
			// Generate password form
			$tpl->part_load();
			$tpl->fillin_array( array(
				'S_USER_FORM' => '<script type="text/javascript">
function suggestPassword() {
    var pwchars = "abcdefghijklmnopgrstuvwxyz1234567890ABCDEFGHIJKLMNOPGRSTUVWXYZ.:,";
    var passwordlength = 8;    // do we want that to be dynamic?  no, keep it simple :)
    var passwd = document.getElementById(\'user_password_generated\');
    passwd.value = \'\';

    for ( i = 0; i < passwordlength; i++ ) {
        passwd.value += pwchars.charAt( Math.floor( Math.random() * pwchars.length ) )
    }
    return passwd.value;
}

function suggestPasswordCopy() {
    document.getElementById(\'user_password\').value = document.getElementById(\'user_password_generated\').value;
    document.getElementById(\'user_password2\').value = document.getElementById(\'user_password_generated\').value;
    return true;
}
</script>
<input type="button" value="' . $lang['admin_user_password_generate'] . '" onclick="suggestPassword()" />',
				'I_USER_FORM' => '<input type="text" id="user_password_generated" name="user_password_generated" size="20" />
<input type="button" value="' . $lang['admin_user_password_copy'] . '" onclick="suggestPasswordCopy(this.form)" />',
				'S_USER_FORM_ERROR' => '',
			) );
			
			$tpl->part_load();
			$user_mail = ( isset( $_POST['user_mail'] ) ) ? $_POST['user_mail'] : '';
			if( isset( $user_error['user_mail'] ) ) {
				$tpl->fillin_array( array(
					'S_USER_FORM' => $lang['mail'],
					'I_USER_FORM' => '<input type="text" name="user_mail" value="' . $user_mail .'" class="yabs_form_error" />',
					'S_USER_FORM_ERROR' => $user_error['user_mail'],
				) );
			} else {
				$tpl->fillin_array( array(
					'S_USER_FORM' => $lang['mail'],
					'I_USER_FORM' => '<input type="text" name="user_mail" value="' . $user_mail .'" />',
					'S_USER_FORM_ERROR' => '',
				) );
			}
			
			$tpl->part_unite();
			$url = array(
				'site' => 'user',
				'action' => 'add',
				'yabsonce' => $user->getOnce(),
			);
			$tpl->fillin_array( array(
				'I_USER_FORM_SUBMIT' => '<input type="submit" name="user_add_submit" value="' . $lang['save'] . '" />',
				'L_USER_EDIT_ACTION' => aurl( $url ),
			) );
			break;
		case 'list':
		default:
			$offset = ( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) && $_GET['start'] >= 0 ) ? $_GET['start'] : 0;
			$sql = "SELECT user_id, user_name, user_mail FROM " . TABLE_USER . " ORDER BY user_name ASC LIMIT " . $db->escape( $offset ) . ", 30;";
			$res = $db->query( $sql );
			$tpl->add( 'user_list.tpl' );
			$tpl->part_seperate( 'E_USER_LIST' );
			$i = 0;
			while( $row = $db->fetch( $res ) ) {
				$tpl->part_load();
				$delete_url = array( 
					'site' => 'user',
					'action' => 'delete', 
					'user_id' => $row['user_id'],
					'yabsonce' => $user->getOnce(),
				);
				if( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) && $_GET['start'] >= 0 ) {
					$delete_url['start'] = $_GET['start'];
				}
				$edit_url = array( 'site' => 'user', 'user_id' => $row['user_id'], 'action' => 'edit' );
				if ( $i == 0 ) {
					$css_table_row = 'yabs_table_row_dark';
					$i = 1;
				} else {
					$css_table_row =  'yabs_table_row_light';
					$i = 0;
				}
				$tpl->fillin_array( array(
					'S_USER_NAME' => $row['user_name'],
					'S_USER_MAIL' => '<a href="mailto:' . $row['user_mail'] . '">' . $row['user_mail'] . '</a>',
					'S_CSS_TABLE_ROW' => $css_table_row,
					'L_USER_EDIT_LINK' => aurl( $edit_url ),
					'L_USER_DELETE_LINK' => aurl( $delete_url ),
				) );
			}
			$db->free( $res );
			$tpl->part_unite();
			
			$sql = "SELECT user_id FROM " . TABLE_USER;
			$res = $db->query( $sql, __LINE__, __FILE__ );
			$num = ceil ( $db->numrows( $res ) / 30 );
			$db->free( $res );
			$pages = '';
			for( $i = 0; $i < $num; $i++ ){
				if( $i == $offset ) $pages .=  ( $i + 1 ) . ' ';
				else $pages .= '<a href="' . aurl( array( 'site' => 'entry_manage', 'start' => $i * 30 ) ) . '">' . ( $i + 1 ) . '</a> '; 
			}	
			
			$url = array( 'site' => 'user', 'action' => 'add' );
			$tpl->fillin_array( array(
				'I_USER_DELETE_CONFIRM' => 'onclick="return confirm(\'' . $lang['admin_user_delete_question'] . '\')""',
				'S_USER_DELETE_TEXT' => $lang['delete'],
				'S_USER_EDIT_TEXT' => $lang['edit'],
				'S_USER_NAME_TEXT' => $lang['name'],
				'S_USER_MAIL_TEXT' => $lang['mail'],
				'S_USER_PAGES' => $pages,
				'L_LINK_NEW' => aurl( $url ),
				'S_LINK_NEW' => $lang['admin_user_add'],
			) );
			break;
	}
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_error_invalid_link'] . $lang['back'] );
}

?>
