<?php

/*
 * name		class.template.php
 * begin	February 09, 2007
 * 
 * $Id: class.template.php 23 2008-07-24 23:49:32Z trellmor $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class template {
    protected $_tpl = '';
    protected $_part = '';
    protected $_path = './templates/';
    protected $_show_errors = true;
    private $_author = 'Daniel Triendl';
    private $_version = '2.0.3';

    /*
		* Initialisierung
		* 
		* Wird beim Erzeugen des Objekts aufgerufen.
		* 
		* Es werden folgende Array Elemente erkannt, diese mssen aber nicht gesetzt werden
		* 
		* gzip: Komprimierung beim Ausgeben des templates, Header wird gesendet [0-9], 0
		* 
		* show_errors: Unterdrck die Anzeige von Fehlern. Vorsichtig verwenden! [true, false], false
		* 
		* path: Der Standartpfad in dem nach dem Templatefile gesucht wird. [string], ./templates/
		*/

    public function __construct( $path = './templates/' )
    {
        $this->_path = $path;
    } 

    /*
		* Ldt ein Templatefile
		* 
		* name: Der Name des Templatefile. [string]
		* 
		* path: Optional, ein Order in der das tmpfile gesucht wird,
		* ansonsten wird der als Standartpfad eingestellte Ordner verwendet. [string]
		*/

    public function add( $name, $line = __LINE__, $file = __FILE__, $path = '' )
    {
        if ( empty( $path ) ) {
            $path = $this->_path;
        } 

		if ( !empty( $name ) ) {
			if ( file_exists( $path . '/' . $name ) ) {
				if ( filesize( $path . '/' . $name ) > 0 ) {
					$f = fopen( $path . '/' . $name, 'r' );
					if ( is_array( $this->_tpl ) ) {
						$this->_tpl[1] .= fread( $f, filesize( $path . '/' . $name ) );
					} else {
						$this->_tpl .= fread( $f, filesize( $path . '/' . $name ) );
					}
					fclose( $f );
				} 
			} else {
				$this->raise_error( 'Can\'t find template: ' . $path . '/' . $name, 'add', $line, $file );
			} 
		} else {
			$this->raise_error( 'No file specified', 'add', $line, $file );
		}
    } 

    /*
		* Ersetzt einen Platzhalter
		* 
		* search: Der Platzhalter ohne {}. [string]
		* 
		* replace: Der Text mit dem der Platzhalter ersetzt werden soll. [string]
		*/

    public function fillin( $search, $replace )
    {
		if ( is_array( $this->_tpl ) ) {
			$this->_tpl[1] = str_replace( '{' . $search . '}', $replace, $this->_tpl[1] );
            //$this->_tpl[1] = str_replace( 'S_MENU_SELECTED', 'lala', $this->_tpl[1] );
        } else {
            $this->_tpl = str_replace( '{' . $search . '}', $replace, $this->_tpl );
        } 
    } 

    /*
		* Anstatt nur einen Platzhalter pro aufruf zu ersetzten kann man auch ein Array mit Platzhalter/Ersatz
		* Kombinationen verwenden.
		* 
		* array: Ein Array, der Index entspricht dem Platzhalter, der Wert dem replace. [array]
		*/

    public function fillin_array( $array )
    {
        if ( is_array( $array ) ) {
            foreach( $array as $search => $replace ) {
                if ( is_array( $this->_tpl ) ) {
                    $this->_tpl[1] = str_replace( '{' . $search . '}', $replace, $this->_tpl[1] );
                } else {
                    $this->_tpl = str_replace( '{' . $search . '}', $replace, $this->_tpl );
                } 
            } 
        } else {
            $this->raise_error( 'Expecting array.', 'fillin_array', __LINE__ );
        } 
    } 

    /*
		* Es kann vorkommen, dass man einen Teil des Templates immer wieder ausgeben will, z.B. der Teil
		* eines Newsscripts wo die News stehen. Das Template wird dann an den markierten Stellen
		* zerlegt, und er Mittelteil kann wiederholt werden (siehe auch part_load, part_unite)
		* 
		* Es mssen exakt 3 Teile entstehen. (2x der Seperator im Template vorhanden sein)
		* 
		* seperator: Der String im Template
		*/

    public function part_seperate( $seperator, $line = __LINE__, $file = __FILE__ )
    {
        if ( !is_array( $this->_tpl ) ) {
            $this->_tpl = explode( '{' . $seperator . '}', $this->_tpl );
            if ( count( $this->_tpl ) >= 3 ) {
                $this->_part = $this->_tpl;
                for( $i = 1; $i < count( $this->_tpl ) - 1; $i++ ) {
                	$this->_tpl[$i] = '';
                }
            } else {
                $this->raise_error( 'Wrong number of parts created, minimum: 3, got: ' . count( $this->_tpl ) . '.', 'part_seperate', $line, $file );
            }
        } else {
            $this->raise_error( 'Template is alreasy seperated.', 'part_seperate', $line, $file );
        } 
    } 

    /*
		* Bereitet den Teil des Templates der wiederholt ausgegeben werden soll vor, damit die funktion fillin,
		* bzw fillin_array verwendet werden kann.
		*/

    public function part_load( $part = 1, $line = __LINE__, $file = __FILE__ )
    {
    	if ( is_array( $this->_tpl ) && isset( $this->_part[$part] ) ) {
            $this->_tpl[1] .= $this->_part[$part];
        } else {
            $this->raise_error( 'Template is not seperated or part not found.', 'part_load', $line, $file );
        } 
    } 

    /*
		* Fgt alle Teile eines Templates wieder zusammen, die durch part_seperate getrennt wurden. Das ist
		* ntig um weitere Templateteile mit der Funktion add anhngen zu knnen und das Template auszugeben.
		*/

    public function part_unite( $line = __LINE__, $file = __FILE__ )
    {
        if ( is_array( $this->_tpl ) ) {
            $this->_tpl = implode( '', $this->_tpl );
            $this->_part = NULL;
        } else {
            $this->raise_error( 'Template is already united.', 'part_unite', $line, $file );
        } 
    } 

    /*
		* Schickt das Template an den User. berflssige Platzhalter werden herausgefiltert. Template wird
		* mittel gzip komprimiert, wenn diese Option beim Init eingestellt wurde.
		*/

    public function output( $browser = true, $gzip = 0 )
    {
        if ( !is_array( $this->_tpl ) ) {
            if( !defined( 'DEBUG' ) || !DEBUG ) {
        		$this->_tpl = preg_replace( '/\{[A-Z0-9_]+\}/U', '', $this->_tpl );
            }
            if ( $gzip > 0 && isset( $_SERVER['HTTP_ACCEPT_ENCODING'] ) && preg_match( '/gzip/', $_SERVER['HTTP_ACCEPT_ENCODING'] ) && !headers_sent() ) {
                $this->_tpl = gzencode( $this->_tpl, $gzip );
                header( 'Content-Encoding: gzip' );
            } 
            if ( $browser ) {
                print $this->_tpl;
            } else {
                return $this->_tpl;
            } 
            $this->_tpl = '';
        } else {
            $this->raise_error( 'Can\'t output template before parts have been united.', 'output', __LINE__ );
        } 
    } 

    /*
		* Kurze Statusinformationen
		* 
		* element: Optional, gibt an welche Information ausgegeben werden soll. Wird element nicht
		* angegeben, werden alle Statusinformationen als Array ausgegeben. [file,version,author,false], false
		*/

    public function status( $element = false )
    {
        $return['file'] = __FILE__;
        $return['version'] = $this->_version;
        $return['author'] = $this->_author; 
        // Add more stuff ;)
        if ( $element != false && isset( $return[$element] ) ) {
            return $return[$element];
        } else {
            return $return;
        } 
    } 

    /*
		* Wird aufgerufen wenn ein Fehler auftritt, diese Funktion sollte nur innerhalb dieser Klasse aufgerufen werden.
		*/

    protected function raise_error( $error = '', $function = '', $line = __LINE__, $file = __FILE__ )
    {
        if ( $this->_show_errors ) {
            $msg = '<h1>An error occured</h1>';
            $msg .= '<b>Error:</b> ' . $error . '<br />';
            $msg .= '<b>Function:</b> template::' . $function . '()<br />';
            $msg .= '<b>File:</b> ' . $file . '</br>';
            $msg .= '<b>Line:</b> ' . $line . '</br>';
            session_write_close();
            die( $msg );
        } 
    } 
} 

?>
