<?php

/*
 * name		class.session.php
 * begin	September 10, 2007
 * 
 * $Id: class.session.php 18 2008-04-24 16:32:37Z trellmor $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class session {
	
	protected $lifetime = 0;
	protected static $instance;
	
	public function __construct( $default = false, $lifetime = false)
	{	
		if( !$default ) {
			if( $lifetime === false ) {
				// get lifetime
				$this->lifetime = get_cfg_var("session.gc_maxlifetime");
			} else {
				$this->lifetime = (int)$lifetime;
			}
			
			session_set_save_handler(
				array(&$this,"open"),
				array(&$this,"close"),
				array(&$this,"read"),
				array(&$this,"write"),
				array(&$this,"destroy"),
				array(&$this,"gc")
			);
		}
			
		ini_set( 'session.use_cookies', 1 );
		ini_set( 'session.use_only_cookies', 1 );
		ini_set( 'session.use_trans_sid', 0 );
		
		// more validation?
		if( !empty( $_GET['sid'] ) ) session_id( $_GET['sid'] );
		session_start();
		$_SESSION['yabs'] = true;
	}
	
	public static function singleton( $default = false, $lifetime = false )
	{
		if ( !isset( self::$instance ) ) {
			$c = __CLASS__;
			self::$instance = new $c( $default, $lifetime );
		}
		
		return self::$instance;
	}
	
	public function open( $savepath, $sname )
	{
		return true;
	}
	
	public function close()
	{
		$this->gc( $this->lifetime );
	}
	
	public function read( $sid )
	{
		global $db;
		
		$sql = "SELECT
					session_data
				FROM
					" . TABLE_SESSIONS . "
				WHERE
					session_id = '" . $db->escape( $sid ) . "' and
					session_expire > '" . (int)time() . "';";
		if( $row = $db->fetch( $db->query( $sql, __LINE__, __FILE__ ) ) ) {
			return (string)$row['session_data'];
		} else {
			return (string)'';
		}
	}
	
	public function write( $sid, $data )
	{
		global $db;
		
		$exp = time() + $this->lifetime;
		$sql = "SELECT session_id FROM " . TABLE_SESSIONS . " WHERE session_id = '" . $db->escape( $sid ) . "';";
		if( $db->numrows( $db->query( $sql, __LINE__, __FILE__ ) ) ) {
			$sql = "UPDATE
						" . TABLE_SESSIONS . "
					SET
						session_data = '" . $db->escape( $data ) . "',
						session_expire = '" . (int)$exp . "'
					WHERE
						session_id = '" . $db->escape( $sid ) . "';";
		} else {
			$sql = "INSERT INTO " . TABLE_SESSIONS . "
						(
						 session_id,
						 session_data,
						 session_expire
						)
					VALUES
						(
						 '" . $db->escape( $sid ) . "',
						 '" . $db->escape( $data ) . "',
						 '" . (int)$exp . "'
						);";
		}
		$db->query( $sql, __LINE__, __FILE__ );
		if( $db->affected_rows() ) {
			return true;
		} else {
			return false;
		}
	}
	
	public function destroy( $sid )
	{
		global $db;
		
		$sql = "DELETE FROM " . TABLE_SESSIONS . " WHERE session_id = '" . $db->escape( $sid ) . "';";
		$db->query( $sql, __LINE__, __FILE__ );
		if( $db->affected_rows() ) {
			return true;
		} else {
			return false;
		}
	}
	
	public function gc( $lifetime )
	{
		global $db;
		
		// we can ignore the lifetime, cos session_expire is time() + lifetime
		$sql = "DELETE FROM " . TABLE_SESSIONS . " WHERE session_expire < '" . time() . "';";
		$db->query( $sql, __LINE__, __FILE__ );
		return( $db->affected_rows() );
	}
}

?>
