<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
	<head>
		<title>YABS::Install</title>
		<link rel="stylesheet" href="style.css" type="text/css" />
	</head>
	<body>
<?php
	
	require_once('../inc/class.core.inc.php');
	$yabs = new yabs_core();
	
	echo '<h1>YABS Install</h1>';
	
	switch(@$_POST['step']){
		default:
			echo '<h2>Welcome</h2>';
			echo '<table width="700"><tr><td>';
			echo 'This program will guide you through the install.<br />';
			echo 'Press Step 1 to start the install.';
			echo '</tr></td></table><br />';
			echo '<form action="install.php" method="post"><input type="submit" name="step" value="Step 1" /></form>';
			break;
		case 'Step 1':
			// Thanks to s9y for inspiration
			echo '<h2>Step 1: Checking System:</h2>';
			echo '<table width="700">';
			echo '<tr><td width="50%"><b>System</b></td><td width="50%">&nbsp;</td></tr>';
			$error = false;
			
			// OS
			echo '<tr><td>Operation System</td><td>'.php_uname('s').' '.php_uname('r').', '.php_uname('m').'</td></tr>';
			
			// PHP Version
			echo '<tr><td>PHP Version &gt; 5.0.0</td><td>';
			if(phpversion() >= '5.0.0'){
				echo '<span class="ok">OK</span> ('.phpversion().')';
			}else{
				echo '<span class="failed">Failed</span> ('.phpversion().')';
				$error = true;
			}
			echo '</td></tr>';
			
			// DB
			echo '<tr><td>DB Type</td><td>';
			$mysqli = false;
			if(extension_loaded('mysql')){
				echo '<span class="ok">OK</span>';
			}else{
				echo '<span class="warning">Warning:</span> YABS only includes a DB layer for mysql. You have to install a 3rd party DB layer for your database type.';
			}
			echo '</td></tr>';
			
			// Session
			echo '<tr><td>Sessions</td><td>';
			if(extension_loaded('session')){
				echo '<span class="ok">OK</span>';
			}else{
				echo '<span class="failed">Failed</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			// GDlib
			echo '<tr><td>GDlib</td><td>';
			if(extension_loaded('session')){
				echo '<span class="ok">OK</span>';
			}else{
				echo '<span class="failed">Failed</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			// zlib
			echo '<tr><td>zlib</td><td>';
			if(extension_loaded('zlib')){
				echo '<span class="ok">OK</span>';
			}else{
				echo '<span class="failed">Failed</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			echo '</table><br />';
			
			echo '<table width="700">';
			echo '<tr><td width="50%"><b>php.ini</b></td><td width="50%">&nbsp;</td></tr>';
			
			// safe_mode
			echo '<tr><td>safe_mode</td><td>';
			if(!ini_get('safe_mode')){
				echo '<span class="ok">OFF</span>';
			}else{
				echo '<span class="warning">ON</span> (OFF)';
			}
			echo '</td></tr>';
			
			// register_globals
			echo '<tr><td>register_globals</td><td>';
			if(!ini_get('register_globals')){
				echo '<span class="ok">OFF</span>';
			}else{
				echo '<span class="warning">ON</span> (OFF)';
			}
			echo '</td></tr>';
			
			// magic_quotes_gpc
			echo '<tr><td>magic_quotes_gpc</td><td>';
			if(!ini_get('magic_quotes_gpc')){
				echo '<span class="ok">OFF</span>';
			}else{
				echo '<span class="warning">ON</span> (OFF)';
			}
			echo '</td></tr>';
			
			// magic_quotes_runtime
			echo '<tr><td>magic_quotes_runtime</td><td>';
			if(!ini_get('magic_quotes_runtime')){
				echo '<span class="ok">OFF</span>';
			}else{
				echo '<span class="warning">ON</span> (OFF)';
			}
			echo '</td></tr>';
			
			// session.use_trans_sid
			echo '<tr><td>session.use_trans_sid</td><td>';
			if(!ini_get('session.use_trans_sid')){
				echo '<span class="ok">OFF</span>';
			}else{
				echo '<span class="warning">ON</span> (OFF)';
			}
			echo '</td></tr>';
			
			// URL fopen
			echo '<tr><td>allow_url_fopen</td><td>';
			if(ini_get('allow_url_fopen')){
				echo '<span class="ok">ON</span>';
			}else{
				echo '<span class="failed">OFF</span> (ON)';
				$error = true;
			}
			echo '</td></tr>';
			echo '</table><br />';
			
			echo '<table width="700">';
			echo '<tr><td width="50%"><b>Permissions</b></td><td width="50%">&nbsp;</td></tr>';
			
			echo '<tr><td>inc/</td><td>';
			if(is_writeable('../inc')){
				echo '<span class="ok">Writeable</span>';
			}else{
				echo '<span class="failed">Not writeable</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			// Config
			echo '<tr><td>';
			if(file_exists('../inc/cfg.inc.php')){
				echo 'inc/cfg.inc.php</td><td>';
				if(is_writeable('../inc/cfg.inc.php')){
					echo '<span class="ok">Writeable</span>';
				}else{
					echo '<span class="failed">Not writeable</span>';
					$error = true;
				}
			}
			echo '</td></tr>';
			
			if(file_exists('inc/spam_urllist.txt')){
				echo '<tr><td>inc/spam_urllist.txt</td><td>';
				if(is_writeable('../inc/spam_urllist.txt')){
					echo '<span class="ok">Writeable</span>';
				}else{
					echo '<span class="failed">Not writeable</span>';
					$error = true;
				}
				echo '</td></tr>';
			}
			
			echo '<tr><td>cache/</td><td>';
			if(is_writeable('../cache')){
				echo '<span class="ok">Writeable</span>';
			}else{
				echo '<span class="failed">Not writeable</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			echo '<tr><td>cache/entries/</td><td>';
			if(is_writeable('../cache/entries')){
				echo '<span class="ok">Writeable</span>';
			}else{
				echo '<span class="failed">Not writeable</span>';
				$error = true;
			}
			echo '</td></tr>';
			
			echo '</table>';
			if(!$error){
				echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
			}
			break;
		case 'Step 2':
			echo '<h2>Step 2: Config</h2>';
			if(file_exists('../inc/cfg.inc.php') && filesize('../inc/cfg.inc.php')){
				include('../inc/cfg.inc.php');
			}
			
			echo '<form action="install.php" method="post">';
			
			// DB Config
			echo '<table width="700">';
			echo '<tr><td width="15%"><b>Database</b></td><td width="85%">&nbsp;</td></tr>';
			
			// DB Hoste
			echo '<tr><td>Host:</td><td><input type="text" name="dbhost" size="50" ';
			if(!empty($dbhost)){
				echo ' value="'.$dbhost.'" ';
			}else{
				echo ' value="localhost" ';
			}
			echo '/></td></tr>';
			
			// DB User
			echo '<tr><td>User:</td><td><input type="text" name="dbuser" size="50" ';
			if(!empty($dbuser)){
				echo ' value="'.$dbuser.'" ';
			}
			echo '/></td></tr>';
			
			// DB Pass
			echo '<tr><td>Pass:</td><td><input type="password" name="dbpass" size="50" ';
			if(!empty($dbpass)){
				echo ' value="'.$dbpass.'" ';
			}
			echo '/></td></tr>';
			
			// DB Name
			echo '<tr><td>Database:</td><td><input type="text" name="dbname" size="50" ';
			if(!empty($dbname)){
				echo ' value="'.$dbname.'" ';
			}
			echo '/></td></tr>';
			
			// DB Prefix
			echo '<tr><td>Prefix:</td><td><input type="text" name="dbprefix" size="50" ';
			if(!empty($dbprefix)){
				echo ' value="'.$dbprefix.'" ';
			}else{
				echo ' value="yabs_"';
			}
			echo '/></td></tr>';
			
			echo '</table><br />';
			
			// DB Config
			echo '<table width="700">';
			echo '<tr><td width="15%"><b>Other</b></td><td width="85%">&nbsp;</td></tr>';
			echo '<tr><td>mod_rewrite</td><td><input type="checkbox" name="mod_rewrite" value="true" ';
			if(defined('MOD_REWRITE') && MOD_REWRITE){
				echo 'checked="checked" ';
			}
			echo '/></td></tr>';
			echo '<tr><td>&nbsp;</td><td>Remember to edit your .htaccess file.</td></tr>';
			
			echo '</table><br />';
			// !!!FEHLER IM ALTEN INSTALLER: $yabs_old_config wurde anstannt von $yabs_old_version verwendet.
			if(!empty($yabs_old_config)){
				$yabs_old_version = $yabs_old_config;
			}
			if(!empty($yabs_old_version)){
				echo '<input type="hidden" name="yabs_old_version" value="'.$yabs_old_version.'" />';
			}
			if(!empty($dbtype)){
				echo '<input type="hidden" name="dbtype" value="'.$dbtype.'" />';
			}
			echo '<input type="submit" name="step" value="Step 3" /></form>';
			break;
		case 'Step 3':
			echo '<h2>Step 3: Write Config</h2>';
			echo '<table width="700">';
			$error = '';
			if(empty($_POST['dbhost'])) $error .= 'No DB-Host<br />';
			if(empty($_POST['dbuser'])) $error .= 'No DB-User<br />';
			if(empty($_POST['dbpass'])) $error .= 'No DB-Pass<br />';
			if(empty($_POST['dbname'])) $error .= 'No DB-Name<br />';
			if(empty($_POST['dbprefix'])) $error .= 'No DB-Prefix<br />';
			if(empty($error)){
				$error = false;
				if(extension_loaded('mysql')){
					echo '<tr><td width="50%">Testing DB settings:</td><td>';
					if($mysql = @mysql_connect($_POST['dbhost'], $_POST['dbuser'], $_POST['dbpass'])){
						if(mysql_select_db($_POST['dbname'])){
							mysql_close($mysql);
							echo '<span class="ok">Passed</span></td></tr>';
						}else{
							echo '<span class="failed">Failed:</span> '.mysql_error().'</td></tr></table>';
							echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
							$error = true;
						}
					}else{
						echo '<span class="failed">Failed:</span> '.mysql_error().'</td></tr></table>';
						echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
						$error = true;
					}
				}
				if(!$error){
					echo '<tr><td width="50%">Writing config</td><td>';
					$f = fopen('../inc/cfg.inc.php', 'w');
					fwrite($f, '<?php'."\n");
					fwrite($f, '$dbhost = "'.$_POST['dbhost'].'";'."\n");
					fwrite($f, '$dbuser = "'.$_POST['dbuser'].'";'."\n");
					fwrite($f, '$dbpass = "'.$_POST['dbpass'].'";'."\n");
					fwrite($f, '$dbname = "'.$_POST['dbname'].'";'."\n");
					fwrite($f, '$dbprefix = "'.$_POST['dbprefix'].'";'."\n");
					if(!empty($_POST['dbtype'])) $dbtype = $_POST['dbtype'];
					else $dbtype = 'mysql';
					fwrite($f, '$dbtype = "'.$dbtype.'";'."\n");
					fwrite($f, '$yabs_old_version = "'.$yabs->get_version().'";'."\n");
					if(!empty($_POST['mod_rewrite']) && $_POST['mod_rewrite'] == 'true'){
						fwrite($f, 'define(\'MOD_REWRITE\', true);'."\n");
					}
					if(strtolower(substr(php_uname('s'), 0, 3)) == 'win'){
						fwrite($f, 'define(\'WINDOWS\', true);'."\n");
					}
					fwrite($f, '?>');
					fclose($f);
					echo '<span class="ok">Done</span></td></tr>';
					echo '</table>';
					echo '<br /><form action="install.php" method="post">';
					if(!empty($_POST['yabs_old_version'])){
						echo '<input type="hidden" name="yabs_old_version" value="'.$_POST['yabs_old_version'].'" />';
					}
					echo '<input type="submit" name="step" value="Step 4" /></form>';
				}
			}else{
				echo '<tr><td><b>An error occured:</b><br />'.$error.'</td></tr></table>';
				echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 2" /></form>';
			}
			break;
		case 'Step 4':
			echo '<h2>Step 4: Installing database</h2>';
			echo '<table width="700">';
			$querys = array();
			include('../inc/cfg.inc.php');
			include('../inc/class.'.$dbtype.'.inc.php');
			$db = new database($dbhost, $dbuser, $dbpass, $dbname);
			if(empty($_POST['yabs_old_version'])){
				include('db/install.php');
				$error = false;
				foreach($querys as $sql){
					echo '<tr><td><b>Executin query #'.($db->get_querynum()+1).'</b><br /><span style="font-family: Courier New;">'.nl2br($sql).'</span>';
					if($db->query($sql, false)){
						echo '<br /><span class="ok">Done</span><br />&nbsp;';
					}else{
						echo '<br /><span class="failed">Failed</span><br /><b>Error:</b> '.$db->get_error().'<br /><b>Errno:</b> '.$db->get_errno().'</td></tr>';
						$error = true;
						break;
					}
					echo '</td></tr>';
				}
				echo '</table>';
				if(!$error){
					echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 5" /></form>';
				}
			}else{
				// Hier kommt die Update-Funktion hin
				echo '<br /><form action="http://'.$_SERVER['HTTP_HOST'].substr(dirname($_SERVER['PHP_SELF']), 0, strlen(dirname($_SERVER['PHP_SELF']))-7).'" method="post"><input type="submit" name="step" value="Finish" /></form>';
			}
			break;
		case 'Step 5':
			include('../inc/cfg.inc.php');
			include('../inc/class.'.$dbtype.'.inc.php');
			$db = new database($dbhost, $dbuser, $dbpass, $dbname);
			$config = $db->query('SELECT * FROM '.$dbprefix.'config');
			if($db->numrows($config)){
				echo '<a href="http://'.$_SERVER['HTTP_HOST'].substr(dirname($_SERVER['PHP_SELF']), 0, strlen(dirname($_SERVER['PHP_SELF']))-7).'">Blog</a>';
			}else{
				echo '<h2>Step 5: Configuring blog</h2>';
				
				echo '<form action="install.php" method="post"><table width="700">';				
				echo '<tr><td width="20%"><b>Config</b></td><td width="80%">&nbsp;</td>';
				echo '<tr><td>Blogname:</td><td><input type="text" name="title" size="50" /></td></tr>';
				echo '<tr><td>Timeformat:</td><td><input type="text" name="time_format" size="50" value="%m-%d-%Y %H:%M" /></td></tr>';
				echo '</table><br />';
				
				echo '<table width="700">';				
				echo '<tr><td width="20%"><b>User</b></td><td width="80%">&nbsp;</td>';
				echo '<tr><td>Name:</td><td><input type="text" name="name" size="50" /></td></tr>';
				echo '<tr><td>Email:</td><td><input type="text" name="email" size="50" /></td></tr>';
				echo '<tr><td>Password:</td><td><input type="password" name="pass" size="50" /></td></tr>';
				echo '<tr><td>Password:</td><td><input type="password" name="pass_wh" size="50" /></td></tr>';
				echo '</table><br />';
				
				echo '<input type="submit" name="step" value="Step 6" /></form>';
			}
			break;
		case 'Step 6':
			include('../inc/cfg.inc.php');
			include('../inc/class.'.$dbtype.'.inc.php');
			include('../inc/functions.inc.php');
			$db = new database($dbhost, $dbuser, $dbpass, $dbname);
			$config = $db->query('SELECT * FROM '.$dbprefix.'config');
			echo '<table width="700">';	
			
			$error = '';
			if(empty($_POST['title'])) $error .= 'No title<br />';
			if(empty($_POST['time_format'])) $error .= 'No timeformat<br />';
			if(empty($_POST['email'])){
				$error .= 'No email<br />';
			}else{
				if(!checkmail(trim($_POST['email']))) $error .= 'Invalid email<br />';
			}
			if(empty($_POST['pass'])){
				$error .= 'No password<br />';
			}else{
				if($_POST['pass'] != $_POST['pass_wh']){
					$error .= 'Password didn\'t match<br />';
				}
			}
			if(empty($error)){
				$sql = "INSERT INTO	".$dbprefix."config
							(
							 Title,
							 time_format,
							 uptime
							)
						VALUES
							(
							 '".slashes($_POST['title'])."',
							 '".slashes($_POST['time_format'])."',
							 '".time()."'
							);";
				echo '<tr><td><b>Configuring blog</b><br /><span style="font-family: Courier New;">'.nl2br($sql).'</span>';
				$error = false;
				if($db->query($sql)){
					echo '<br /><span class="ok">Done</span><br />&nbsp;</td></tr>';
					
					$sql = "INSERT INTO ".$dbprefix."user
								(
								 name,
								 email,
								 pass,
								 permission
								)
							VALUES
								(
								 '".slashes(trim($_POST['name']))."',
								 '".slashes(trim($_POST['email']))."',
								 '".md5($_POST['pass'])."',
								 '131071'
								);";
					echo '<tr><td><b>Creating user</b><br /><span style="font-family: Courier New;">'.nl2br($sql).'</span>';
					if($db->query($sql)){
						echo '<br /><span class="ok">Done</span><br />&nbsp;</td></tr>';
					}else{
						echo '<br /><span class="failed">Failed</span><br /><b>Error:</b> '.$db->get_error().'<br /><b>Errno:</b> '.$db->get_errno().'</td></tr>';
						$error = true;
					}
				}else{
					echo '<br /><span class="failed">Failed</span><br /><b>Error:</b> '.$db->get_error().'<br /><b>Errno:</b> '.$db->get_errno().'</td></tr>';
					$error = true;
				}
				echo '</table>';
				
				if(!$error){
					echo '<br /><form action="http://'.$_SERVER['HTTP_HOST'].substr(dirname($_SERVER['PHP_SELF']), 0, strlen(dirname($_SERVER['PHP_SELF']))-7).'" method="post"><input type="submit" name="step" value="Finish" /></form>';
				}
			}else{
				echo '<tr><td><b>An error occured:</b><br />'.$error.'</td></tr></table>';
				echo '<br /><form action="install.php" method="post"><input type="submit" name="step" value="Step 5" /></form>';
			}
			break;
	}

?>
	</body>
</html>