<?php

/* class.trackback.php
 * ===================
 *
 * Auto-trackback-finding ans sending
 * Started: 2005-05-25
 * Edited: 2005-06-01
 * (c) 2005 yabs
 */
 
	require_once('inc/class.socket.inc.php');
 
	class Trackback extends Socket
	{
		var $_get = "";
		var $_data = "";
		var $_TBping = "";
		var $_TBident = "";
		var $_TBerror = false;
		
		function Trackback($url, $autodiscover = true)
		{
			$this->_TBerror = false;
			//if(!($this->_data = @implode("", @file($url)))) $this->_TBerror = true;
			if($autodiscover){
				$target = parse_url($url);
				if(empty($target['query'])){
					$target['query'] = '';
				}else{
					$target['query'] = '?'.$target['query'];
				}
				if(empty($target['path'])) $target['path'] = '';
				
				$this->_url = $target['host'];
				if($this->connect()){
					$this->write("GET ".$target['path'].$target['query']." HTTP/1.1\r\n");
					$this->write("Host: ".$this->_url."\r\n");
					$this->write("User-Agent: MoveableType (yabs ".VERSION.")\r\n");
					$this->write("Connection: Close\r\n\r\n");
					$this->_data = $this->read();
					$this->disconnect();
				}else{
					$this->_TBerror = true;
				}
			}
		}
		
		function getTBdata()
		{
			if(!$this->_TBerror){
				return $this->_data;
			}else{
				return $this->_error." <".$this->_errno.">";
			}
		}
		
		function searchTBident()
		{
			//Search ident
			//echo $this->_data;
			if(preg_match('/dc:identifier="(.*)"/U', $this->_data, $match)){
				$this->_TBident = $match['1'];
				return true;
			}else{
				$this->_TBident = false;
				$this->_TBerror = true;
				return false;
			}
		}
		
		function getTBping()
		{
			//Search Ping
			//echo $this->_data;
			if(preg_match('/trackback:ping="(.*)"/U', $this->_data, $match)){
				$this->_TBping =  $match[1];
			}else{
				$this->_TBping = false;
				$this->_TBerror = true;
			}
			return $this->_TBping;
		}
		
		function setTBping($TBping)
		{
			$this->_TBping = $TBping;
		}
		
		function matchTBident($url)
		{
			if($url == $this->_TBident){
				$this->_TBident = true;
			}else{
				$this->_TBident = false;
				$this->_TBerror = true;
			}
			return $this->_TBident;
		}
		
		function sendTB($blog_name, $url, $title, $excerpt)
		{
			$target = parse_url($this->_TBping);
			$this->_url = $target['host'];
			if(!empty($target['port'])){
				$this->_port = $target['port'];
			}
			if(!empty($target['query'])){
				$query = "?".$target['query'];
			}else{
				$query = "";
			}
			$this->connect() || $this->_TBerror = true;
			$return = -1;
			if(!$this->_TBerror){
				$data = "title=".$this->tb_encode($title)."&url=".urlencode($url)."&excerpt=".$this->tb_encode($excerpt)."&blog_name=".$this->tb_encode($blog_name);
				$this->write("POST ".$target['path'].$query." HTTP/1.1\r\n");
				$this->write("Host: ".$this->_url."\r\n");
				$this->write("Content-Type: application/x-www-form-urlencoded\r\n");
				$this->write("Content-Length: ".strlen($data)."\r\n");
				$this->write("User-Agent: MoveableType (yabs ".VERSION.")\r\n");
				$this->write("Connection: Close\r\n\r\n");
				$this->write($data);
				$this->_data = $this->read();
				//echo $this->_data;
				$this->disconnect();
				if(preg_match('#<error>(.*)</error>#U', $this->_data, $errno)){
					if($errno[1] == '0'){
						$return = 0;
					}else{
						if(preg_match('#<message>(.*)</message>#U', $this->_data, $error)){
							$return = $error[1];
						}else{
							$return = -1;
						}
					}
				}else{
					$return = -1;
				}
			}
			return $return;
		}
		
		function getTBstatus(){
			if($this->_TBerror){
				return false;
			}else{
				return true;
			}
		}
		
		function getTBerror()
		{
			if($this->_TBerror){
				return $this->_error." <".$this->_errno.">";
			}else{
				return "Success";
			}
		}
		
		function tb_encode($text)
		{
			$text = str_replace('', 'ae', $text);
			$text = str_replace('', 'oe', $text);
			$text = str_replace('', 'ue', $text);
			$text = str_replace('', 'ss', $text);
			$text = urlencode($text);
			return $text;
		}
	}
	
?>