<?php

	class plugin
	{
		private $_hooks = array();
		private $_sites = array();
		
		public function plugin()
		{
			$this->set_hooks($this->GetHooks());
			$this->set_sites($this->GetSites());
		}
		
		
		// +-----------------------------------------------------+
		// | Set vars                                            |
		// +-----------------------------------------------------+
		
		private function set_hooks($hooks)
		{
			$this->_hooks = $hooks;
		}
		
		private function set_sites($sites)
		{
			$this->_sites = $sites;
		}
		
		
		// +-----------------------------------------------------+
		// | Get vars                                            |
		// +-----------------------------------------------------+
		
		private function get_sites()
		{
			return $this->_sites;
		}
		
		
		// +-----------------------------------------------------+
		// | Get hooks                                           |
		// +-----------------------------------------------------+
		
		public function get_HookedEvent($event)
		{
			return false;
		}
		
		public function get_subsite($site)
		{
			$return = false;
			$sites = $this->get_sites();
			if(isset($sites[$site])){
				$return = 'plugins/'.$sites[$site]['pluginID'].'/'.$sites[$site]['file'];
			}
			return $return;
		}
		
		
		// +-----------------------------------------------------+
		// | Hook sites and events                               |
		// +-----------------------------------------------------+
		
		public function hook_adminmenu($plugin, $name, $remove = false)
		{
			global $dbprefix;
			global $db;
			if(!$remove){
				$sql = "INSERT INTO	".$dbprefix."admin_menu
							(
							 name,
							 pluginID
							)
						VALUES
							(
							 '".slashes(trim($name))."',
							 '".slashes(trim($plugin))."'
							);";
					
			}else{
				$sql = "DELETE FROM
							".$dbprefix."admin_menu
						WHERE
							pluginID = '".slashes(trim($plugin))."';";
			}
			$db->query($sql);
			return true;
		}
		/*
		public function hook_event($plugin, $file, $event, $remove = false){
			if(!$remove){
				$sql = "INSERT INTO ".MYSQL_PREFIX."hooks
							(
							 pluginID,
							 file,
							 event,
							 config
							)
						VALUES
							(
							 '".slashes($plugin)."',
							 '".slashes($file)."',
							 '".slashes($event)."',
							 '".CONFIG."'
							);";
			}else{
				$sql = "DELETE FROM
							".MYSQL_PREFIX."hooks
						WHERE
							pluginID = '".slashes($plugin)."' and
							file = '".slashes($file)."' and
							event = '".slashes($event)." and
							config = '".CONFIG.";";
			}
			new Query($sql);
			return true;
		}
		*/
		public function hook_subsite($plugin, $site, $file, $remove = false)
		{
			global $dbprefix;
			global $db;
			global $yabs;
			
			$return = false;
			if(!$remove){
				$test = "	SELECT
								pluginID
							FROM
								".$dbprefix."subsites
							WHERE
								pluginID = '".slashes($plugin)."' and
								file = '".slashes($file)."' and
								site = '".slashes($site)."';";
				$res = $db->query($test);
				if($db->numrows($res)){
					$return = false;
				}else{
					$sql = "INSERT INTO ".$dbprefix."subsites
								(
								 pluginID,
								 file,
								 site
								)
							VALUES
								(
								 '".slashes($plugin)."',
								 '".slashes($file)."',
								 '".slashes($site)."'
								);";
					$db->query($sql);
					$return = true;
				}
			}else{
				$sql = "DELETE FROM
							".$dbprefix."subsites
						WHERE
							pluginID = '".slashes($plugin)."' and
							file = '".slashes($file)."' and
							site = '".slashes($site)."';";
				$db->query($sql);
				$return = true;
			}
			$yabs->savecachedarray('plugin_sites', $this->GetSitesFromDB());
			return $return;
		}
		
		
		// +-----------------------------------------------------+
		// | Load hooked sites and events from the DB            |
		// +-----------------------------------------------------+
		
		private function GetHooksFromDB()
		{
			return array();
		}
		
		private function GetSitesFromDB()
		{
			global $dbprefix;
			global $db;
			$sql = "SELECT
						pluginID,
						site,
						file
					FROM
						".$dbprefix."subsites;";
			$res = $db->query($sql);
			$sites = array();
			while($row = $db->fetch($res)){
				$sites[$row['site']] = $row;
			}
			return $sites;
		}
		
		private function GetSites()
		{
			global $yabs;
			if(!file_exists('cache/plugin_sites')){
				$yabs->savecachedarray('plugin_sites', $this->GetSitesFromDB());
			}
			$return = $yabs->loadcachedarray('plugin_sites');
			if(is_array($return)){
				return $return;
			}else{
				$yabs->death_event('Can\'t load plugin cache (Sites)');
			}
		}
		
		private function GetHooks()
		{
			global $yabs;
			if(!file_exists('cache/plugin_hooks')){
				$yabs->savecachedarray('plugin_hooks', $this->GetHooksFromDB());
			}
			$return = $yabs->loadcachedarray('plugin_hooks');
			if(is_array($return)){
				return $return;
			}else{
				
				$yabs->death_event('Can\'t load plugin cache (Hooks)');
			}
		}
	}

?>