<?php

/* blog.php
 * ========
 *
 * Blog output
 * Started: 2005-05-10
 * (c) 2005 yabs
 */

	$anzahl_sql = "	SELECT 
						ID,
						Autor,
						date,
						Titel,
						Inhalt,
						extended,
						cat,
						nofeedback,
						hidden
					FROM ".$dbprefix."blog";
	if(isset($_GET['kat']) && trim($_GET['kat']) != "") $anzahl_sql .= " WHERE kat = '".trim($_GET['kat']."'");
	$anzahl = $db->query($anzahl_sql.";");
	$anzahl_all = $db->numrows($anzahl);

	if(isset($_GET['offset']) && trim($_GET['offset']) != "") $offset = trim($_GET['offset']);
	else $offset = 0;
	
	$blog_sql = "SELECT	* FROM ".$dbprefix."blog WHERE";
	if(isset($_GET['entry'])) $blog_sql .= " ID = '".trim($_GET['entry'])."' and";
	if(isset($_GET['cat']) && is_numeric($_GET['cat'])) $blog_sql .= " cat = '".trim($_GET['cat'])."' and";
	if(isset($_GET['date']) && is_numeric($_GET['date'])){
		if(isset($_GET['day']) && $_GET['day'] == 1) $blog_sql .= " Date > '".($_GET['date'] - 1)."' AND Date < '".($_GET['date'] + 3600*24)."' and";
		else $blog_sql .= " Date > '".mktime(23, 59, 59, date('m', $_GET['date']), 0, date('Y', $_GET['date']))."' AND Date < '".mktime(0, 0, 0, date('m', $_GET['date'])+1, 1, date('Y', $_GET['date']))."' and";
	}
	if($config['show_future'] == 0){
		$blog_sql .= " Date <= '".time()."' and";
	}
	$blog_sql .= " hidden = '0' ORDER BY Date DESC LIMIT ".$offset.", ".$config['limit_blog_entries'].";";
	$blog_res = $db->query($blog_sql);
	if($anzahl = $db->numrows($blog_res)){
		$tpl->add_tpl($config['template'].'/blog.tpl');
		$fillin = $tpl->parse_explodes(1);
		$finalecho = "";
		$Titel = "";
	}elseif(isset($_GET['entry'])){
		$tpl->add_tpl($config['template'].'/empty.tpl');
		$tpl->fillin('CONTENT', $lang['error_noentry'].'<a href="'.url().'">'.$config['Title'].'</a>');
		if(!headers_sent()){
			header('HTTP/1.0 404 Not Found');
		}
	}

	// Preloading Authors and Cats
	$author_sql = "	SELECT
						ID,
						name,
						email
					FROM
						".$dbprefix."user;";
	$author_res = $db->query($author_sql);
	$authors = array();
	while($author = $db->fetch($author_res)){
		$authors[$author['ID']] = $author;
	}
	$cat_sql = "SELECT
					ID,
					Name
				FROM
					".$dbprefix."cat;";
	$cat_res = $db->query($cat_sql);
	$cats = array();
	while($cat = $db->fetch($cat_res)){
		$cats[$cat['ID']] = $cat;
	}
	
	// Output Entries
	while($blog = $db->fetch($blog_res)){
		if(!($blog['cache'] = $yabs->getcachedentry($blog['ID']))){
			$yabs->savecachedentry($blog['ID']);
			$blog['cache'] = $yabs->getcachedentry($blog['ID']);
		}
		$nofeedback = $blog['nofeedback'];
		if(array_key_exists($blog['Autor'], $authors)){
			$echo = $tpl->fillin_explode("AUTOR", $authors[$blog['Autor']]['name'], $fillin);
			$echo = $tpl->fillin_explode("EMAIL", $authors[$blog['Autor']]['email'], $echo);
		}else{
			$echo = $tpl->fillin_explode('AUTOR', '', $fillin);
			$echo = $tpl->fillin_explode('EMAIL', '', $echo);
		}
		
		if(array_key_exists($blog['cat'], $cats)){
			$cat_url = array();
			$cat_url['cat'] = $blog['cat'];
			$echo = $tpl->fillin_explode('CATEGORIE', '<a href="'.url($cat_url).'">'.$cats[$blog['cat']]['Name'].'</a>', $echo);
		}else{
			$echo = $tpl->fillin_explode('CATEGORIE', '<a href="'.url(array()).'">'.$lang['admin_blog_nocat'].'</a>', $echo);
		}
		$query = array();
		$query['site'] = "blog";
		$query['entry'] = $blog['ID'];
		$echo = $tpl->fillin_explode("TITEL", "<a href=\"".url($query, 1, 'index.php', $blog['Titel'])."\">".changetext($blog['Titel'], 1)."</a>", $echo);
		$echo = $tpl->fillin_explode("DATE", strftime($config['time_format'], $blog['date']), $echo);
		if(isset($_GET['entry']) && is_numeric($_GET['entry'])){
			$echo = $tpl->fillin_explode("INHALT", changetext($blog['Inhalt']).'<br />'.changetext($blog['extended']), $echo);
		}else{
			if(empty($blog['extended'])){
				$echo = $tpl->fillin_explode("INHALT", changetext($blog['Inhalt']), $echo);
			}else{
				$echo = $tpl->fillin_explode("INHALT", changetext($blog['Inhalt']).'<br /><br /><a href="'.url($query, 1, 'index.php', $blog['Titel']).'">'.$lang['read_more'].'</a>', $echo);
			}
		}
		$echo = $tpl->fillin_explode("COMMENTS", "<a href=\"".url($query, 1, 'index.php', $blog['Titel'])."#comment\">".str_replace("{N}", $blog['cache']['comments'], $lang['comments'])."</a>", $echo);
		$echo = $tpl->fillin_explode("TRACKBACKS", "<a href=\"".url($query, 1, 'index.php', $blog['Titel'])."#trackback\">".str_replace("{N}", $blog['cache']['trackbacks'], $lang['trackbacks'])."</a>", $echo);
		$finalecho .= $echo;
		$Titel = $blog['Titel'];
	}
	if($anzahl){
		$tpl->replace_array($finalecho, 1);
		$tpl->parse_implode();
	}
	
	//Trackback Creation
	$trackback = '';
	if(isset($_GET['entry']) && $anzahl){
		$tpl->fillin('SITE_TITLE', blank_text($Titel, 255, 1, 1).' - '.blank_text($config['Title'], 255, 1, 1));
		$trackback = "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n";
		$trackback .= "    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n";
		$trackback .= "    xmlns:trackback=\"http://madskills.com/public/xml/rss/module/trackback/\">\n";
		$trackback .= "<rdf:Description\n";
		$tb = array();
		$tb['site'] = 'blog';
		$tb['id'] = $_GET['entry'];
		if(empty($_GET['requested_site'])){
			$trackback .= "    rdf:about=\"".url($query, 0, 'index.php', $blog['Titel'])."\"\n";
			$trackback .= "    dc:identifier=\"".url($query, 0, 'index.php', $blog['Titel'])."\"\n";
		}else{
			$trackback .= "    rdf:about=\"".url($query, 0, 'index.php', $_GET['requested_site'])."\"\n";
			$trackback .= "    dc:identifier=\"".url($query, 0, 'index.php', $_GET['requested_site'])."\"\n";
		}
		$trackback .= "    dc:title=\"".blank_text($Titel)."\"\n";
		$trackback .= "    trackback:ping=\"".tb_url($_GET['entry'])."\" />\n";
		$trackback .= "</rdf:RDF>\n";
		//$i = 0;
		
		$tb_sql = "	SELECT
						ID,
						url,
						blog_name,
						date,
						title,
						excerpt
					FROM
						".$dbprefix."trackback
					WHERE
						BlogID = '".$_GET['entry']."' and
						active = '1'
					ORDER BY
						Date ASC;";
		$tb_res = $db->query($tb_sql);
		if($db->numrows($tb_res)){
			$tpl->add_tpl($config['template'].'/trackback.tpl');
			$fillin = $tpl->parse_explodes(1);
			$finalecho = "";
			while($tb = $db->fetch($tb_res)){
				$echo = $tpl->fillin_explode('SENDER', "<a href=\"".str_replace('&', '&amp;', $tb['url'])."\" target=\"_blank\">".changetext($tb['blog_name'], 1)."</a>", $fillin);
				$echo = $tpl->fillin_explode('DATE', strftime($config['time_format'], $tb['date']), $echo);
				$echo = $tpl->fillin_explode('TITLE', blank_text($tb['title']), $echo);
				$echo = $tpl->fillin_explode('EXCERPT', blank_text($tb['excerpt']), $echo);
				$finalecho .= $echo;
				//$i++;
			}
			$tpl->replace_array($finalecho, 1);
			$tpl->parse_implode();
		}
		
		//Starting Comment Output
		$comm_sql = "	SELECT
							ID,
							HP,
							autor,
							date,
							comment,
							email
						FROM
							".$dbprefix."comments
						WHERE
							BlogID = '".$_GET['entry']."' and
							active = '1' and
							spam = '0'
						ORDER BY
							Date ASC;";
		$comm_res = $db->query($comm_sql);
		if($db->numrows($comm_res)){
			$tpl->add_tpl($config['template'].'/comment.tpl');
			$fillin = $tpl->parse_explodes(1);
			$finalecho = "";
			while($comm = $db->fetch($comm_res)){
				$comm['HP'] = htmlspecialchars($comm['HP']);
				$echo = $tpl->fillin_explode('AUTOR', "<a href=\"http://".$comm['HP']."\" target=\"_blank\">".changetext($comm['autor'], 1)."</a>", $fillin);
				$echo = $tpl->fillin_explode('DATE', strftime($config['time_format'], $comm['date']), $echo);
				$echo = $tpl->fillin_explode('COMMENT', changetext($comm['comment']), $echo);
				$echo = $tpl->fillin_explode('GRAVATAR', "http://www.gravatar.com/avatar.php?gravatar_id=".md5($comm['email']), $echo);
				$echo = $tpl->fillin_explode('COMID', 'com'.$comm['ID'], $echo);
				$finalecho .= $echo;
			}
			$tpl->replace_array($finalecho, 1);
			$tpl->parse_implode();
		}
		
		if(!$nofeedback) $tpl->add_tpl($config['template'].'/comment_add.tpl');
		$extend_script = '	<script type="text/javascript">
							function extend(id) {
								if (document.getElementById) {
									el = document.getElementById(id);
									if (el.style.display == \'none\') {
										document.getElementById(\'extendimg\').src = \''.site_true_home().'/templates/'.$config['template'].'/images//minus.png\';
										el.style.display = \'\';
									} else {
										document.getElementById(\'extendimg\').src = \''.site_true_home().'/templates/'.$config['template'].'/images/plus.png\';
										el.style.display = \'none\';
									}
								}
							}
						</script>';
		$query = array();
		$query['site'] = "cwrite";
		$tpl->fillin('ACTION', url($query));
		if(isset($_COOKIE['comment_name'])){
			$tpl->fillin('INPUT_NAME', '<input type="text" name="autor" maxlength="30" value="'.$_COOKIE['comment_name'].'" />');
		}else{
			$tpl->fillin('INPUT_NAME', '<input type="text" name="autor" maxlength="30" />');
		}
		if(isset($_COOKIE['comment_email'])){
			$tpl->fillin('INPUT_EMAIL', '<input type="text" name="email" maxlength="50" value="'.$_COOKIE['comment_email'].'" />');
		}else{
			$tpl->fillin('INPUT_EMAIL', '<input type="text" name="email" maxlength="50" />');
		}
		$tpl->fillin('INPUT_COMMENT', '<textarea name="comment" rows="6" cols="35"></textarea>');
		if(isset($_COOKIE['comment_hp'])){
			$tpl->fillin('INPUT_HP', '<input type="text" name="HP" maxlength="50" value="'.$_COOKIE['comment_hp'].'" />');
		}else{
			$tpl->fillin('INPUT_HP', '<input type="text" name="HP" maxlength="50" value="http://" />');
		}
		$tpl->fillin('INPUT_HIDDEN', '<input type="hidden" name="ID" value="'.$_GET['entry'].'" />');
		$tpl->fillin('INPUT_SUBMIT', '<input type="submit" name="submit" value="'.$lang['form_submit'].'" />');
		$tpl->fillin('FORM_NAME', $lang['form_name']);
		$tpl->fillin('FORM_EMAIL', $lang['form_email']);
		$tpl->fillin('FORM_HP', $lang['form_hp']);
		$tpl->fillin('FORM_COMMENT', $lang['form_comment']);
		$tpl->fillin('TRACKBACKURI', tb_url($_GET['entry'], 1));
		$tpl->fillin('FORM_TBURI', $lang['form_tburi']);
		$tpl->fillin('COMMENT_HEADLINE', $lang['comment']);
		$tpl->fillin('TRACKBACK_HEADLINE', $lang['trackback']);
		$tpl->fillin('BUTTON_BOLD', '<a href="#" onclick="insert_basic(document.forms[\'yabs_entry\'][\'comment\'], \'b\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/button_bold.png" alt="" border="0" /></a>');
		$tpl->fillin('BUTTON_IMAGE', '<a href="#" onclick="insert_image(document.forms[\'yabs_entry\'][\'comment\'], \''.$lang['form_image_location'].'\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/button_image.png" alt="" border="0" /></a>');
		$tpl->fillin('BUTTON_LINK', '<a href="#" onclick="insert_link(document.forms[\'yabs_entry\'][\'comment\'], \''.$lang['form_link_location'].'\', \''.$lang['form_link_text'].'\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/button_link.png" alt="" border="0" /></a>');
		$tpl->fillin('BUTTON_QUOTE', '<a href="#" onclick="insert_basic(document.forms[\'yabs_entry\'][\'comment\'], \'quote\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/button_quote.png" alt="" border="0" /></a>');
		$tpl->fillin('BUTTON_STROKE', '<a href="#" onclick="insert_basic(document.forms[\'yabs_entry\'][\'comment\'], \'s\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/button_stroke.png" alt="" border="0" /></a>');
		$tpl->fillin('BUTTON_UNDERLINE', '<a href="#" onclick="insert_basic(document.forms[\'yabs_entry\'][\'comment\'], \'u\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/button_underline.png" alt="" border="0" /></a>');
		$tpl->fillin('BUTTON_ITALIC', '<a href="#" onclick="insert_basic(document.forms[\'yabs_entry\'][\'comment\'], \'i\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/button_italic.png" alt="" border="0" /></a>');
		$tpl->fillin('SCRIPT_EDITOR', '<script type="text/javascript" src="'.site_true_home().'/inc/editor.js"></script>');
		$tpl->fillin('FORM_OPTIONS', $lang['admin_form_options']);
		$tpl->fillin('SCRIPT_EXTENDED', $extend_script);
		$tpl->fillin('ID_OPTIONS', 'options');
		$tpl->fillin('IMAGE_OPTIONS', '<a href="#" onclick="extend(\'options\'); return false"><img src="'.site_true_home().'/templates/'.$config['template'].'/images/plus.png" id="extendimg" alt="+/-" border="0" /></a>');
		$tpl->fillin('SCRIPT_HIDE_EXTENDED', '	<script type="text/javascript">
													document.getElementById("options").style.display = "none";
												</script>');
		$tpl->fillin('FORM_SAVE_DATES', $lang['form_save_dates']);
		if(isset($_COOKIE['comment_name'])){
			$checked = 'checked="checked" ';
		}else{
			$checked = '';
		}
		$tpl->fillin('INPUT_SAVE_DATES', '<input type="checkbox" name="save_dates" value="true" '.$checked.'/>');
		
		if($config['captcha']){
			//$_SESSION['captcha'] = substr(md5(microtime()), 0, 6);
			$tpl->fillin('CAPTCHA_INPUT', '<input type="text" name="captcha" maxlength="6" size="7" />');
			//captcha($_SESSION['captcha'], session_id(), $config['captcha_size'], $config['captcha_bgcolor'], $config['captcha_textcolor'], $config['captcha_gridcolor']);
			$tpl->fillin('CAPTCHA_FORM', "<img src=\"{SITE_TRUE_HOME}/captcha.php\" alt=\"Captcha\" />");
		}else{
			$tpl->fillin('CAPTCHA_INPUT', '');
			$tpl->fillin('CAPTCHA_FORM', '');
		}
		
	}
	$query = array();
	if(!isset($_GET['entry']) && $anzahl){
		$query['site'] = 'blog';
		if(isset($_GET['cat']) && is_numeric($_GET['cat'])){
			$query['cat'] = $_GET['cat'];
		}
		if(isset($_GET['date']) && is_numeric($_GET['date'])){
			if(isset($_GET['day']) && $_GET['day'] == 1) $query['day'] = 1;
			$query['date'] = $_GET['date'];
		}
		if($anzahl == $config['limit_blog_entries']){
			$query['offset'] = $offset + $config['limit_blog_entries'];
			if(isset($_GET['cat']) && is_numeric($_GET['cat'])){
				$query['cat'] = $_GET['cat'];
			}
			$tpl->fillin('OLDER_ENTRIES', "<a href=\"".url($query)."\">".$lang['older_entries']."</a>");
		}else{
			$tpl->fillin('OLDER_ENTRIES', '&nbsp;');
		}
		if(isset($_GET['offset']) && $offset > 0){
			$offset_newer = $offset - $config['limit_blog_entries'];
			if($offset_newer < 0) $offset_newer = 0;
			$query['offset'] = $offset_newer;
			if(isset($_GET['cat']) && is_numeric($_GET['cat'])){
				$query['cat'] = $_GET['cat'];
			}
			$tpl->fillin('NEWER_ENTRIES', "<a href=\"".url($query)."\">".$lang['newer_entries']."</a>");
		}else{
			$tpl->fillin('NEWER_ENTRIES', '&nbsp;');
		}
		// +-----------------------------------------------------+
		// | Seiten                                              |
		// +-----------------------------------------------------+
		$anzahl_sql = "	SELECT
								ID
							FROM
								".$dbprefix."blog
							WHERE
								hidden = '0'";
		if(isset($_GET['cat']) && is_numeric($_GET['cat'])){
			$anzahl_sql .= " and cat = '".$_GET['cat']."';";
		}
		if(isset($_GET['date']) && is_numeric($_GET['date'])){
			if(isset($_GET['day']) && $_GET['day'] == 1) $anzahl_sql .= " and Date > '".($_GET['date'] - 1)."' AND Date < '".($_GET['date'] + 3600*24)."'";
			else $anzahl_sql .= " and Date > '".mktime(23, 59, 59, date('m', $_GET['date']), 0, date('Y', $_GET['date']))."' AND Date < '".mktime(0, 0, 0, date('m', $_GET['date'])+1, 1, date('Y', $_GET['date']))."'";
		}
		$anzahl_res = $db->query($anzahl_sql);
		$anzahl = $db->numrows($anzahl_res);
		$pages = ceil($anzahl / $config['limit_blog_entries']);
		$page = "";	
		for($i = ceil($offset / $config['limit_blog_entries']) - 3; $i <= ceil($offset / $config['limit_blog_entries'] + 3); $i++){
			if($i >= 0 && $i < $pages){
				if($i == $offset / $config['limit_blog_entries']){
					$page .= ($i + 1).' ';
				}else{
					$query['offset'] = $i * $config['limit_blog_entries'];
					$page .= '<a href="'.url($query).'">'.($i + 1).'</a> ';
				}
			}
		}
		if(ceil($offset / $config['limit_blog_entries']) != 0){
			$query['offset'] = 0;
			$add = '<a href="'.url($query).'">&lt;&lt;</a> ';
			$off = $offset - $config['limit_blog_entries'];
			if($off < 0) $off = 0;
			$query['offset'] = $off;
			$add .= '<a href="'.url($query).'">&lt;</a> ';
			$page = $add.$page;
		}
		if(ceil($offset) + $config['limit_blog_entries'] < $pages * $config['limit_blog_entries']){
			$off = $offset + $config['limit_blog_entries'];
			if($off > $pages * $config['limit_blog_entries'] - 1) $off = $pages * $config['limit_blog_entries'] - $config['limit_blog_entries'];
			$query['offset'] = $off;
			$page .= ' <a href="'.url($query).'">&gt;</a>';
			$query['offset'] = $pages * $config['limit_blog_entries'] - $config['limit_blog_entries'];
			$page .= ' <a href="'.url($query).'">&gt;&gt;</a>';
		}
		if(empty($page)) $page = '&nbsp;';
		$tpl->fillin('PAGES', $page);
	}else{
		$tpl->fillin('TRACKBACK', $trackback);
		$tpl->fillin('OLDER_ENTRIES', '&nbsp;');
		$tpl->fillin('NEWER_ENTRIES', '&nbsp;');
		$tpl->fillin('PAGES', '&nbsp;');
	}

?>