<?php

###################################################################################
### rss.php                                                                     ###
	$version = "1.3.1";
### Erstellt: 2005-02-27                                                        ###
### (c) 2005 by Daniel Triendl                                                  ###
### http://www.falke666.at.tt                                                   ###
###################################################################################

	//Auf 0 setzten fr Betrieb
	error_reporting(E_ALL);
	
	require_once("inc/cfg.inc.php");
	require_once('inc/class.core.inc.php');
	$yabs = new yabs_core();
	require_once('inc/class.'.$dbtype.'.inc.php');
	require_once("inc/functions.inc.php");
	require_once('inc/class.template.inc.php');
	
	// +-----------------------------------------------------+
	// | mod_rewrite                                         |
	// +-----------------------------------------------------+
	if(!defined('MOD_REWRITE')){
		define('MOD_REWRITE', false);
	}
	
	if(MOD_REWRITE){
		make_get();
	}
	
	//Connect DB
	$db = new database($dbhost, $dbuser, $dbpass, $dbname);
	
	//Serve the feed as rss+xml
	header("Content-Type: application/xml; charset=ISO-8859-1");
	
	if(isset($_GET['feed']) && $_GET['feed'] != ""){
	    $v = $_GET['feed'];
	}else{
	    $v = "RSS20";
	}
	
	// +-----------------------------------------------------+
	// | Check if config is given and load it                |
	// +-----------------------------------------------------+
	if(!isset($_GET['config']) || !is_numeric($_GET['config'])){
		$_GET['config'] = 1;
	}
	
	// +-----------------------------------------------------+
	// | Load the Config from the Server                     |
	// +-----------------------------------------------------+
	$cfg_sql = "SELECT
					*
				FROM
					".$dbprefix."config
				LIMIT
					0, 1;";
	$cfg_res = $db->query($cfg_sql);
	if($db->numrows($cfg_res) == 0){
		$yabs->death_event('Can\'t load config.');
	}
	$config = $db->fetch($cfg_res);
	
	require_once('lang/'.$config['lang'].'.lang.php');
	
	if(!empty($_GET['cat']) && is_numeric($_GET['cat'])){
		$news_sql = "	SELECT
							*
						FROM
							".$dbprefix."blog
						WHERE
							cat = '".$_GET['cat']."' and
							hidden = '0'";
		if($config['show_future'] == 0) $news_sql .= " and date <= '".time()."'";
		$news_sql .= "	ORDER BY
							date DESC
						LIMIT
							0, 15;";
	
		$mod_sql = "SELECT
						date
					FROM
						".$dbprefix."blog
					WHERE
						cat = '".$_GET['cat']."' and
						hidden = '0'";
		if($config['show_future'] == 0) $mod_sql .= " and date <= '".time()."'";
		$mod_sql .= "	
					ORDER BY
						date DESC
					LIMIT
						0, 1;";
		
		$cat_sql = "SELECT
						ID,
						name
					FROM
						".$dbprefix."cat
					WHERE
						ID = '".$_GET['cat']."';";
		$cat_res = $db->query($cat_sql);
		if($db->numrows($cat_res) > 0){
			$cat = $db->fetch($cat_res);
		}else{
			$cat['name'] = 'Blog';
			$cat['ID'] = 0;
		}
	
	}else{
		$news_sql = "	SELECT
							*
						FROM
							".$dbprefix."blog
						WHERE
							hidden = '0'";
		if($config['show_future'] == 0) $news_sql .= " and date <= '".time()."'";
		$news_sql .= "
						ORDER BY
							date DESC
						LIMIT
							0, 15;";
	
		$mod_sql = "SELECT
						date
					FROM
						".$dbprefix."blog
					WHERE
						hidden = '0'";
		if($config['show_future'] == 0) $mod_sql .= " and date <= '".time()."'";
		$mod_sql .= "
					ORDER BY
						date DESC
					LIMIT
						0, 1;";
		
		$cat['name'] = 'Blog';
		$cat['ID'] = 0;
	}
	
	$admin_sql = "	SELECT
						ID,
						name,
						email
					FROM
						".$dbprefix."user
					ORDER BY
						ID ASC
					LIMIT 0, 1;";
	
	$news_result = $db->query($news_sql);
	$mod_result = $db->query($mod_sql);
	$admin_res = $db->query($admin_sql);
	$admin_row = $db->fetch($admin_res);
	$mod_row = $db->fetch($mod_result);
	
	$query['site'] = 'blog';
	if($cat['ID'] > 0){
		$query['cat'] = $cat['ID'];
	}
	
	switch($v){
	    case "RSS20":
		    echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
		    echo "<rss version=\"2.0\">\n";
			echo "<channel>\n";
			
			if(isset($_GET['cat']) && is_numeric($_GET['cat'])){
				echo "<title>".$config['Title']." (".$cat['name'].")</title>";
			}else{
				echo "<title>".$config['Title']."</title>\n";
			}
			echo "<link>".url()."</link>\n";
			echo "<description>Feed for ".$config['Title']."</description>\n";
			
			echo "<webMaster>".$admin_row['email']."</webMaster>\n";
			echo "<copyright>Copyright by ".$config['Title']."</copyright>\n";
			echo "<generator>Danis feed generator version ".$version."</generator>\n";
			
			echo "<category>".$cat['name']."</category>\n";
			echo "<lastBuildDate>".date('r', $mod_row['date'])."</lastBuildDate>\n";
			echo "<language>".$lang['ISO-639']."</language>\n";
			while($news_row = $db->fetch($news_result)){
			    echo "<item>\n";
				echo "<title>".blank_text($news_row['Titel'])."</title>\n";
				$query['entry'] = $news_row['ID'];
				echo "<link>".url($query, 1, 'index.php', $news_row['Titel'])."</link>\n";
				echo "<description>".substr(blank_text($news_row['Inhalt']), 0, 150)."...</description>\n";
				echo "<guid>".url($query, 1, 'index.php', $news_row['Titel'])."</guid>\n";
				echo "<comments>".url($query, 1, 'index.php', $news_row['Titel'])."#comments</comments>\n";
				$autor_sql = "	SELECT
									name,
									email
								FROM
									".$dbprefix."user
								WHERE
									ID = '".$news_row['Autor']."';";
				$autor_result = $db->query($autor_sql);
				$autor_row = $db->fetch($autor_result);
				echo "<author>".$autor_row['email']." (".$autor_row['name'].")</author>\n";
				echo "<pubDate>".date('r', $news_row['date'])."</pubDate>\n";
				echo "</item>\n";
			}
			echo "</channel>\n";
			echo "</rss>";
			break;
		case "ATOM":
			echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
			echo "<feed version=\"0.3\" xmlns=\"http://purl.org/atom/ns#\">";
			
			if(isset($_GET['cat']) && is_numeric($_GET['cat'])){
				echo "<title>".$config['Title']." (".$cat['name'].")</title>";
			}else{
				echo "<title>".$config['Title']."</title>\n";
			}
			echo "<tagline>Feed for ".$config['Title']."</tagline>\n";
			
			echo "<id>".url()."</id>\n";
			echo "<link rel=\"alternate\" type=\"text/html\" href=\"".url()."\"/>\n";

			echo "<modified>".strftime("%Y-%m-%dT%H:%M:%S+01:00", $mod_row['date'])."</modified>\n";
			
			echo "<generator>Danis feed generator version ".$version."</generator>\n";
			echo "<copyright>Copyright by ".$config['Title']."</copyright>\n";
			while($news_row = $db->fetch($news_result)){
				echo "<entry>\n";
				echo "<title>".blank_text($news_row['Titel'])."</title>\n";
				$query['entry'] = $news_row['ID'];
				echo "<link rel=\"alternate\" type=\"text/html\" href=\"".url($query, 1, 'index.php', $news_row['Titel'])."\"/>\n";
				echo "<id>".url($query, 1, 'index.php', $news_row['Titel'])."</id>\n";
				echo "<created>".strftime("%Y-%m-%dT%H:%M:%S+01:00", $news_row['date'])."</created>\n";
				echo "<issued>".strftime("%Y-%m-%dT%H:%M:%S+01:00", $news_row['date'])."</issued>\n";
				echo "<modified>".strftime("%Y-%m-%dT%H:%M:%S+01:00", $news_row['date'])."</modified>\n";
				$autor_sql = "	SELECT
									name,
									email
								FROM
									".$dbprefix."user
								WHERE
									ID = '".$news_row['Autor']."';";
				$autor_result = $db->query($autor_sql);
				$autor_row = $db->fetch($autor_result);
				echo "<author>\n";
				echo "<name>".$autor_row['name']."</name>\n";
				echo "<email>".$autor_row['email']."</email>\n";
				echo "</author>\n";
				echo "<summary>".substr(blank_text($news_row['Inhalt']), 0, 150)."...</summary>\n";
				echo "</entry>\n";
			}
			echo "</feed>\n";
			break;
		case "RSS10":
			echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
			echo "<?xml-stylesheet href=\"http://www.w3.org/2000/08/w3c-synd/style.css\" type=\"text/css\"?>\n";
			echo "<!-- generator=\"Danis feed generator version ".$version."\" -->\n";
			
			echo "<rdf:RDF\n";
			echo " xmlns=\"http://purl.org/rss/1.0/\"\n";
            echo " xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n";
            echo " xmlns:trackback=\"http://madskills.com/public/xml/rss/module/trackback/\"\n";
			echo " xmlns:slash=\"http://purl.org/rss/1.0/modules/slash/\"\n";
			echo " xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n";
			echo ">\n";
			
			$about = array();
			$about['feed'] = 'RSS10';			
			echo "<channel rdf:about=\"".url($about, 1, 'rss.php')."\">\n";
			if(isset($_GET['cat']) && is_numeric($_GET['cat'])){
				echo "<title>".$config['Title']." (".$cat['name'].")</title>";
			}else{
				echo "<title>".$config['Title']."</title>\n";
			}
			echo " <description>Feed for ".$config['Title']."</description>\n";
        	echo " <link>".url()."</link>\n";
			
			echo " <dc:rights>Copyright by ".$config['Title']."</dc:rights>\n";
			echo " <dc:creator>".$admin_row['name']." (mailto ".$admin_row['email'].")</dc:creator>\n";
			echo " <dc:date>".strftime("%Y-%m-%dT%H:%M:%S+01:00", $mod_row['date'])."</dc:date>\n";
			echo " <dc:publisher>".$config['Title']."</dc:publisher>\n";
			
			echo " <items>\n";
			echo "  <rdf:Seq>\n";
			
			$seq = "";
			$items = "";
			while($news_row = $db->fetch($news_result)){
				$query['entry'] = $news_row['ID'];
				$seq .= "   <rdf:li rdf:resource=\"".url($query, 1, 'index.php', $news_row['Titel'])."\"/>\n";
				
				$items .= "   <item rdf:about=\"".url($query, 1, 'index.php', $news_row['Titel'])."\">\n";
				$items .= "    <title>".blank_text($news_row['Titel'])."</title>\n";
				$items .= "    <link>".url($query, 1, 'index.php', $news_row['Titel'])."</link>\n";				
				$items .= "    <dc:description>".substr(blank_text($news_row['Inhalt']), 0, 150)."...</dc:description>\n";
				
				$items .= "    <dc:publisher>".$config['Title']."</dc:publisher>\n";
				$autor_sql = "	SELECT
									name,
									email
								FROM
									".$dbprefix."user
								WHERE
									ID = '".$news_row['Autor']."';";
				$autor_result = $db->query($autor_sql);
				$autor_row = $db->fetch($autor_result);
				$items .= "    <dc:creator>".$autor_row['name']." (mailto:".$autor_row['email'].")</dc:creator>\n";
				$items .= "    <dc:format>text/html</dc:format>\n";
				$items .= "    <dc:date>".strftime("%Y-%m-%dT%H:%M:%S+01:00", $news_row['date'])."</dc:date>\n";
				$items .= "   </item>\n";

			}
			
			echo $seq;
			echo "  </rdf:Seq>\n";
			echo " </items>\n";
			echo "</channel>\n";
			echo $items;
			echo "</rdf:RDF>\n";
			break;
		default:
			echo "Error";
			break;
	}

?>