<?php

###################################################################################
### class.kalender.php                                                          ###
### Version 1.3                                                                 ###
### Erstellt: 2005-02-10                                                        ###
### (c) 2005 by Daniel Triendl <d.triendl@gmx.at>                               ###
### http://www.evacuation.at.tt                                                 ###
###################################################################################

###################################################################################
### This program is free software; you can redistribute it and/or modify        ###
### it under the terms of the GNU General Public License as published by        ###
### the Free Software Foundation; either version 2 of the License, or           ###
### (at your option) any later version.                                         ###
###                                                                             ###
### This program is distributed in the hope that it will be useful,             ###
### but WITHOUT ANY WARRANTY; without even the implied warranty of              ###
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               ###
### GNU General Public License for more details.                                ###
###################################################################################

	class Kalender{
	
	    var $_kalender = "";
		var $_front_text = "";
		var $_last_text = "";
		var $_hdays = array();
	
	    function Kalender($front_text = "", $last_text = "", $day_selected = 0){
		    $this->_front_text = $front_text;
			$this->_last_text = $last_text;
		    $month = strftime('%m', time());
			$year =  strftime('%Y', time());
		    $this->CreateMonth($month, $year, $day_selected);
		}
		
		function CreateMonth($month, $year, $day_selected=0)
		{
			global $dbprefix;
			global $db;
			
		    $this_day = strftime('%d', time());
			$this_month = $month;
			$this_year = $year;
			
			if($this_month != strftime('%m', time())){
			    $this_day = 0;
			}else{
			    if($this_year != strftime('%Y', time())){
				    $this_day = 0;
				}
			}
			
			if($day_selected){
			    $this_day = $day_selected;
			}
			
			if(defined('WINDOWS')){
			    $month_first_day = strftime('%w', mktime(0, 0, 0, $this_month, 1, $this_year));
				if($month_first_day == 0){
				   $month_first_day = 7;
				}
			}else{
				$month_first_day = strftime('%u', mktime(0, 0, 0, $this_month, 1, $this_year));
			}
			/*
			switch($this_month){
			    case 1: case 3: case 5: case 7: case 8: case 10: case 12:
				    $month_length = 31;
					break;
				case 4: case 6: case 9: case 11:
				    $month_length = 30;
					break;
				case 2:
				    $year = strftime('%y', mktime(0, 0, 0, 1, 1, $this_year));
					$month_length = -1;
					while($month_length == -1){
					    if($year < 1){
						    if($year == 0){
							    $month_length = 29;
							}else{
							    $month_length = 28;
							}
						}else{
						    $year -= 4;
						}
					}
				    break;
			}*/
			$month_length = date('d',  mktime(0, 0, 0, $month+1, 0, $year));
			/*
			switch($this_month){
			    case 1:
				    $this_date_text = $lang['month1'];
					break;
			    case 2:
				    $this_date_text = $lang['month2'];
					break;
			    case 3:
				    $this_date_text = $lang['month3'];
					break;
			    case 4:
				    $this_date_text = $lang['month4'];
					break;
			    case 5:
				    $this_date_text = $lang['month5'];
					break;
			    case 6:
				    $this_date_text = $lang['month6'];
					break;
			    case 7:
				    $this_date_text = $lang['month7'];
					break;
			    case 8:
				    $this_date_text = $lang['month8'];
					break;
			    case 9:
				    $this_date_text = $lang['month9'];
					break;
			    case 10:
				    $this_date_text = $lang['month10'];
					break;
			    case 11:
				    $this_date_text = $lang['month11'];
					break;
			    case 12:
				    $this_date_text = $lang['month12'];
					break;
			}*/
			$this_date_text = strftime('%B', mktime(0, 0, 0, $this_month, 1, $this_year));
			$this_date_text .= strftime(' %Y', mktime(0, 0, 0, 1, 1, $this_year));
			
			$this_date_day['mo'] = strftime('%a', 3600*24*4);
			$this_date_day['di'] = strftime('%a', 3600*24*5);
			$this_date_day['mi'] = strftime('%a', 3600*24*6);
			$this_date_day['do'] = strftime('%a', 3600*24*0);
			$this_date_day['fr'] = strftime('%a', 3600*24*1);
			$this_date_day['sa'] = strftime('%a', 3600*24*2);
			$this_date_day['so'] = strftime('%a', 3600*24*3);
			
			//$this_month_text = strftime('%M', mktime(0, 0, 0, $this_month, $this_day, $this_year));
			
			$kalender = "<table cellspacing=\"0\" class=\"calendar\">\n";
			$kalender .= "<tr>\n";
			$query = array();
			$query['site'] = 'blog';
			$query['date'] = mktime(0, 0, 0, $this_month-1, 1, $this_year);
			$kalender .= "<td width=\"10%\"><a href=\"".url($query)."\">&lt;&lt;</a></td>\n";
			$kalender .= "<td align=\"center\"><b>".$this_date_text."</b></td>\n";
			$query['date'] = mktime(0, 0, 0, $this_month+1, 1, $this_year);
			$kalender .= "<td width=\"10%\"><a href=\"".url($query)."\">&gt;&gt;</a></td>\n";
			$kalender .= "</tr>\n";
			$kalender .= "</table>\n";
			$kalender .= "<table cellspacing=\"0\" class=\"calendar\">\n";
			$kalender .= "<tr>\n";
			$kalender .= "<td width=\"14%\"><b>".$this_date_day['mo']."</b></td>\n";
			$kalender .= "<td width=\"14%\"><b>".$this_date_day['di']."</b></td>\n";
			$kalender .= "<td width=\"14%\"><b>".$this_date_day['mi']."</b></td>\n";
			$kalender .= "<td width=\"14%\"><b>".$this_date_day['do']."</b></td>\n";
			$kalender .= "<td width=\"14%\"><b>".$this_date_day['fr']."</b></td>\n";
			$kalender .= "<td width=\"14%\"><b>".$this_date_day['sa']."</b></td>\n";
			$kalender .= "<td width=\"15%\"><b>".$this_date_day['so']."</b></td>\n";
			$kalender .= "</tr>\n<tr>\n";
			
			// Set day to be searched by highlight_day
			$day_sql = "SELECT
							Date
						FROM
							".$dbprefix."blog
						WHERE
							Date > '".mktime(0, 0, 0, $month, 0, $year)."' and
							Date < '".mktime(0, 0, 0, ($month+1), 1, $year)."' and
							hidden = '0';";
			$day_res = $db->query($day_sql);
			$this->_hdays = array();
			while($day_row = $db->fetch($day_res)){
				$this->_hdays[] = mktime(0, 0, 0, date('m', $day_row['Date']), date('d', $day_row['Date']), date('Y', $day_row['Date']));
			}
			
			for($i=1;$i<$month_first_day; $i++){
				$kalender .= "<td>&nbsp;</td>\n";
			}
			
			$new_tr = $month_first_day - 1;
			
			for($i=1;$i<=$month_length;$i++){
			    if($new_tr == 7){
				    $kalender .= "</tr>\n<tr>\n";
					$new_tr = 0;
				}
				$new_tr++;
				/*
				if($this_day == $i){
					if($this->highlight_day($this_year, $this_month, $i)){
						$text = $this->parse_text($this->_front_text."<span class=\"calendar_this_day\">".$i."</span>".$this->_last_text, $this_year, $this_month, $i);
					}else{
						$text = "<span class=\"calendar_mark_day\">".$i."</span>";
					}
				}else{
					if($this->highlight_day($this_year, $this_month, $i)){
						$text = $this->parse_text($this->_front_text.$i.$this->_last_text, $this_year, $this_month, $i);
				    }else{
						$text = $i;
					}
				}
				
				$kalender .= "<td";
				$kalender .= ">".$text."</td>\n";
				*/
				if($this_day == $i){
					if($this->highlight_day($this_year, $this_month, $i)){
						$kalender .= '<td class="calendar_this_day">'.$this->parse_text($this->_front_text.$i.$this->_last_text, $this_year, $this_month, $i).'</td>';
					}else{
						$kalender .= '<td class="calendar_this_day">'.$i.'</td>';
					}
				}else{
					if($this->highlight_day($this_year, $this_month, $i)){
						$kalender .= '<td class="calendar_mark_day">'.$this->parse_text($this->_front_text.$i.$this->_last_text, $this_year, $this_month, $i).'</td>';
					}else{
						$kalender .= '<td>'.$i.'</td>';
					}
				}
			}
			$kalender .= "</tr>\n";
			$kalender .= "</table>\n";
			$this->_kalender = $kalender;
		}
		
		function print_kalender()
		{
		    print $this->_kalender;
		}
		
		function return_kalender()
		{
		    return $this->_kalender;
		}
		
		function set_front_text($text){
		    $this->_front_text = $text;
		}
		
		function set_last_text($text){
		    $this->_last_text = $text;
		}
		
		function parse_text($text, $year, $month, $day)
		{
		    $text = str_replace("{Y}", $year, $text);
			$text = str_replace("{M}", $month, $text);
			$text = str_replace("{D}", $day, $text);
			$text = str_replace("{DATE}", mktime(0, 0, 0, $month, $day, $year), $text);
			
			return $text;
		}
		
		function highlight_day($year, $month, $day)
		{
			return in_array(mktime(0, 0, 0, $month, $day, $year), $this->_hdays);
		}

	}

?>