<?php
	
	//Rights :D
 	define('RIGHT_ADMIN', 1);
	define('RIGHT_USER', 2);
	define('RIGHT_ENTRIES', 4);
	define('RIGHT_CAT', 8);
	define('RIGHT_BLOGROLL', 16);
	define('RIGHT_SETTINGS', 32);
	define('RIGHT_DESIGN', 64);
	define('RIGHT_ANTISPAM', 128);
	define('RIGHT_URL2CFG', 256);
	define('RIGHT_MENU', 512);
	define('RIGHT_FEEDBACK', 1024);
	define('RIGHT_EDITALLENTRIES', 2048);
	define('RIGHT_ENTRYACTIVATION', 4096);
	define('RIGHT_PLUGIN', 8192);
	define('RIGHT_SPEZIAL_A', 16384);
	define('RIGHT_SPEZIAL_B', 32768);
	define('RIGHT_SPEZIAL_C', 65536);

	class yabs_core
	{
		private $_menu = array();
	
		public function yabs_core()
		{
			if(!($this->_menu = $this->loadcachedarray('menu'))){
				$this->_menu = array();
			}
		}
		
		public function test_install(){
			if(file_exists('install')){
				$this->death_event('Delete install.');
			}
		}
		
		public function death_event($error)
		{
			$die = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
			$die .= '<html><head><title>YABS::Error</title></head><body>';
			$die .= '<h2>An error occurred:</h1><br />';
			$die .= $error.'</body></html>';
			die($die);
		}
		
		public function get_version($name = false){
			$version = '0.7.2';
			$version_name = 'Still funny when alone';
			if($name){
				return $version . ' ' . $version_name;
			}else{
				return $version;
			}
		}
		
		public function login($user, $pass)
		{
			$return = false;
			
			$user = trim($user);
			if(!empty($user)){
				if(login_right(getuserid($user), md5($pass))){
					if(($_SESSION['right'] = get_right(getuserid($user)))){
						$_SESSION['UserID'] = getuserid($user);
						$_SESSION['Password'] = md5($pass);
						$return = true;
					}
				}
			}
			
			return $return;
		}
		
		public function loadcachedarray($file)
		{
			$return = false;
			if(file_exists('cache/'.$file)){
				$return = unserialize(implode(file('cache/'.$file)));
			}
			return $return;
		}
		
		public function get_cats(){
			$query = array();
			$return = '';
			$query['site'] = 'blog';
			if(!empty($this->_menu['cats'])){
				foreach($this->_menu['cats'] as $cat){
					$query['cat'] = $cat['ID'];
					$return .= "<a href=\"".url($query)."\">".$cat['Name']."</a><br />\n";
				}
			}
			return $return;
		}
		
		public function get_blogroll(){
			$return = '';
			if(!empty($this->_menu['blogroll'])){
				foreach($this->_menu['blogroll'] as $roll){
					$return .= "<a href=\"".$roll['Link']."\" target=\"_blank\">".$roll['Text']."</a><br />\n";
				}
			}
			return $return;
		}
		
		public function get_hmenu(){
			$return = array();
			if(!empty($this->_menu['hmenu'])){
				$return = $this->_menu['hmenu'];
			}
			return $return;
		}
		
	
		public function savecachedarray($file, $array){
			$f = @fopen('cache/'.$file, 'w');
			if($f){
				fwrite($f, serialize($array));
				fclose($f);
				return true;
			}else{
				return false;
			}
		}
		
		public function getcachedentry($entry){
			$entry = $this->loadcachedarray('entries/entry_'.$entry);
			if(!empty($entry)){
				return $entry;
			}else{
				return false;
			}
		}
		
		public function savecachedentry($entry){
			global $db;
			global $dbprefix;
			
			$save['ID'] = $entry;
			
			$sql = "SELECT
						ID
					FROM
						".$dbprefix."comments
					WHERE
						BlogID = '".$entry."' and
						active = '1' and
						spam = '0';";
			$res = $db->query($sql);
			$save['comments'] = $db->numrows($res);
			
			$sql = "SELECT
						ID
					FROM
						".$dbprefix."trackback
					WHERE
						BlogID = '".$entry."' and
						active = '1';";
			$res = $db->query($sql);
			$save['trackbacks'] = $db->numrows($res);
			
			$this->savecachedarray('entries/entry_'.$entry, $save);
		}
		
		public function deletecachedentry($entry){
			if(file_exists('cache/entries/entry_'.$entry)){
				unlink('cache/entries/entry_'.$entry);
			}
			return true;
		}
	}

?>