<?php

// +-----------------------------------------------------+
// | Server the stored image with some header            |
// | information                                         |
// +-----------------------------------------------------+

	if(empty($_SERVER['HTTP_REFERER'])) $_SERVER['HTTP_REFERER'] = '';
	$referer = parse_url($_SERVER['HTTP_REFERER']);
	$self = parse_url('http://'.$_SERVER['HTTP_HOST']);
	
	if(!empty($referer['host']) && $referer['host'] == $self['host']){
		header("Expires: Mon, 01 Jul 1990 00:00:00 GMT"); 
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") ." GMT"); 
		header("Pragma: no-cache"); 
		header("Cache-Control: no-store, no-cache, max-age=0, must-revalidate");
		header("Content-type: image/jpeg", true);
		
		require_once('inc/cfg.inc.php');
		require_once('inc/class.core.inc.php');
		$yabs = new yabs_core();
		require_once('inc/class.mysql.inc.php');
		$db = new database($dbhost, $dbuser, $dbpass, $dbname);
		require_once('inc/functions.inc.php');
		
		// +-----------------------------------------------------+
		// | mod_rewrite                                         |
		// +-----------------------------------------------------+
		if(!defined('MOD_REWRITE')){
			define('MOD_REWRITE', false);
		}
		
		if(MOD_REWRITE){
			make_get();
		}
		
		session_start();
		
		$sql = "SELECT
					captcha_bgcolor,
					captcha_gridcolor,
					captcha_textcolor,
					captcha_size
				FROM
					".$dbprefix."config;";
		$res = $db->query($sql);
		$config = $db->fetch($res);
		$db->free($res);
		
		$width = imagefontwidth($config['captcha_size']) * strlen($_SESSION['captcha']) + 4;
		$height = imagefontheight($config['captcha_size']) + 4;
	
		$image = imagecreate($width, $height) or exit(1);
			
		$bgcolor = explode(',', $config['captcha_bgcolor']);
		$bgcolor = imagecolorallocate($image, $bgcolor[0], $bgcolor[1], $bgcolor[2]);
		$textcolor = explode(',', $config['captcha_textcolor']);
		$textcolor = imagecolorallocate($image, $textcolor[0], $textcolor[1], $textcolor[2]);
		$gridcolor = explode(',', $config['captcha_gridcolor']);
		$gridcolor = imagecolorallocate($image, $gridcolor[0], $gridcolor[1], $gridcolor[2]);
	
		// Draw grid
		$i = 0;
		while($i < $height){
			imageline($image, 0, $i, $width, $i, $gridcolor);
			$i += 5;
		}
		imageline($image, 0, $height-1, $width, $height-1, $gridcolor);		
		$i = 0;
		while($i < $width){
			imageline($image, $i, 0, $i, $height, $gridcolor);
			$i += 5;
		}
		imageline($image, $width-1, 0, $width-1, $height, $gridcolor);
		
		imagestring($image, $config['captcha_size'], 2, 2, $_SESSION['captcha'], $textcolor);
		
		imagejpeg($image);
		imagedestroy($image);
	}

?>