<?php

###################################################################################
### yabs - Yet another blog system                                              ###
### ==============================                                              ###
### (c) 2005 by Daniel Triendl <d.triendl@gmx.at                                ###
### http://www.evacuation.at.tt                                                 ###
###################################################################################

###################################################################################
### This program is free software; you can redistribute it and/or modify        ###
### it under the terms of the GNU General Public License as published by        ###
### the Free Software Foundation; either version 2 of the License, or           ###
### (at your option) any later version.                                         ###
###                                                                             ###
### This program is distributed in the hope that it will be useful,             ###
### but WITHOUT ANY WARRANTY; without even the implied warranty of              ###
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               ###
### GNU General Public License for more details.                                ###
###################################################################################

// +-----------------------------------------------------+
// | index.php                                           |
// | =========                                           |
// |                                                     |
// | The main site                                       |
// | Created: 2005-05-09                                 |
// | Modified: 2005-06-27                                |
// | (c) 2005 yabs                                       |
// +-----------------------------------------------------+

	//Debugging
	error_reporting(E_ALL);
	
	//Render Time
	$rendertime_start = array_sum(explode(" ", microtime()));

	//Load required includes
	require_once('inc/class.core.inc.php');
	$yabs = new yabs_core();
	$yabs->test_install();
	require_once('inc/cfg.inc.php');
	//define('MYSQL_PREFIX', $mysql_prefix);
	require_once('inc/class.template.inc.php');
	//require_once('inc/class.mysql.inc.php');
	require_once('inc/class.'.$dbtype.'.inc.php');
	require_once('inc/sites.inc.php');
	require_once('inc/functions.inc.php');
	require_once('inc/class.kalender.inc.php');
	require_once('inc/class.spamfilter.inc.php');
	//require_once('lang/German.lang.php');
	//require_once('inc/class.pingback.inc.php');
	require_once('inc/class.plugin.inc.php');
	
	// +-----------------------------------------------------+
	// | mod_rewrite                                         |
	// +-----------------------------------------------------+
	if(!defined('MOD_REWRITE')){
		define('MOD_REWRITE', false);
	}
	
	if(MOD_REWRITE){
		make_get();
	}
	define('VERSION', $yabs->get_version());
	
	//Start a connection to the mysql server
	$db = new database($dbhost, $dbuser, $dbpass, $dbname);
	

	
	// +-----------------------------------------------------+
	// | Init session                                        |
	// | NOT php <5 compatible                               |
	// | php 4 support stopped                               |
	// +-----------------------------------------------------+
	session_start();
	
	// +-----------------------------------------------------+
	// | Load the Config from the Server                     |
	// +-----------------------------------------------------+
	$cfg_sql = "SELECT
					*
				FROM
					".$dbprefix."config
				LIMIT
					0, 1;";
	$cfg_res = $db->query($cfg_sql);
	if($db->numrows($cfg_res) == 0){
		$yabs->death_event('Can\'t load config.');
	}
	$config = $db->fetch($cfg_res);
	// +-----------------------------------------------------+
	// | Config-Code End                                     |
	// +-----------------------------------------------------+

	//Ok, now we know the language, so load the language file
	require_once('lang/'.$config['lang'].'.lang.php');
	
	// +-----------------------------------------------------+
	// | INIT Plugin Handler                                 |
	// +-----------------------------------------------------+
	$yabs_plugin = new plugin();
	
	if(isset($_GET['action']) AND $_GET['action'] == "logout"){
		session_destroy();
		if(!empty($_COOKIE['UserID']) && !empty($_COOKIE['Password'])){
			setcookie('UserID', '0', time(), dirname($_SERVER['PHP_SELF']));
			setcookie('Password', '0', time(), dirname($_SERVER['PHP_SELF']));
		}
		header("location: ".url());
		exit();
	}
	
	if(!isset($_SESSION['saved'])){
		$_SESSION['saved'] = false;
	}
	// Time for some Counter and log stuff, but don't log Bots like googlebot, or msnbot
	if(!$_SESSION['saved'] && !preg_match('/bot/Uis', $_SERVER['HTTP_USER_AGENT'])){
		$config['counter']++;
		$sql = "UPDATE
					".$dbprefix."config
				SET
					counter = '".$config['counter']."';";
		$db->query($sql);
		
		if(!empty($_COOKIE['UserID']) && !empty($_COOKIE['Password'])){
			$_SESSION['UserID'] = $_COOKIE['UserID'];
			$_SESSION['Password'] = $_COOKIE['Password'];
			setcookie('UserID', $_COOKIE['UserID'], time() + 60*60*24*356, dirname($_SERVER['PHP_SELF']));
			setcookie('Password', $_COOKIE['Password'], time() + 60*60*24*356, dirname($_SERVER['PHP_SELF']));
		}
		$_SESSION['captcha'] = substr(md5(microtime()), 0, 6);
		$_SESSION['saved'] = true;
	}
	
	//Init template
	$tpl = new Template();
	$tpl->open_tpl($config['template'].'/header.tpl');
	
	// The main part, everything else is more or less useles 
	if(isset($_GET['site']) AND $plugin_site = $yabs_plugin->get_subsite($_GET['site'])){
		require($plugin_site);
	}else{
		if(isset($_GET['site']) AND isset($site[$_GET['site']])) {
	        require($site[$_GET['site']]);
	    }else{
	        require($site['default']);
	    }
	}
	
	//Add footer
	$tpl->add_tpl($config['template'].'/footer.tpl');
	
	//Generate Headermenu
	$hmenu = new Template();
	$hmenu->open_tpl($config['template'].'/head_menu.tpl');
	$fillin = $hmenu->parse_explodes(1);
	$finalecho = '';
	foreach($yabs->get_hmenu() as $hmenu_row){
		$echo = $tpl->fillin_explode('LINK', $hmenu_row['link'], $fillin);
		$echo = $tpl->fillin_explode('NAME', $hmenu_row['name'], $echo);
		$finalecho .= $echo;
	}
	$hmenu->replace_array($finalecho, 1);
	$hmenu->parse_implode();
	$tpl->fillin('HEADER_MENU', $hmenu->return_tpl());
	
	//Fillin some vars
	$tpl->fillin('COUNTER_FILLIN', $config['counter']);
	$tpl->fillin('VERSION_FILLIN', $yabs->get_version(1));
	$tpl->fillin('UPTIME_FILLIN', uptime($config['uptime'], $lang['uptime']));
	$tpl->fillin('SITE_TITLE', blank_text($config['Title'], 255, 1, 1));
	
	$right_menu = '<table border="0" width="100%" cellpadding="0" cellspacing="0" id="yabs_rightmenu">';
	
	//Calendar
	$right_menu .= "\n<tr>\n";
	$right_menu .= "<td class=\"menuheader\">".$lang['calendar']."</td>\n";
	$right_menu .= "</tr>\n";
	$query = array();
	$query['site'] = 'blog';
	$query['date'] = '{DATE}';
	$query['day'] = '1';
	$kalender = new Kalender("<a href=\"".url($query)."\">", "</a>", strftime('%d', time()));
	if(isset($_GET['date'])){
		if(isset($_GET['day'])){
			$kalender->CreateMonth(date('m', $_GET['date']), date('Y', $_GET['date']), date('d', $_GET['date']));
		}else{
			$kalender->CreateMonth(date('m', $_GET['date']), date('Y', $_GET['date']));
		}
	}
	$right_menu .= "<tr>\n<td class=\"menucontent\">".$kalender->return_kalender()."</td>\n</tr>\n";
	$right_menu .= "<tr>\n<td class=\"menufooter\">&nbsp;</td>\n</tr>\n";
	
	//Blogroll
	if($config['blogroll']){
		$right_menu .= "<tr>\n<td class=\"menuheader\">".$lang['blogroll']."</td>\n</tr>\n";
		$right_menu .= "<tr>\n<td class=\"menucontent\">".$yabs->get_blogroll()."</td>\n</tr>\n";
		$right_menu .= "<tr>\n<td class=\"menufooter\">&nbsp;</td>\n</tr>\n";
	}
	//Categories
	if($config['cats']){
		$right_menu .= "<tr>\n<td class=\"menuheader\">".$lang['categories']."</td>\n</tr>\n";
		$right_menu .= "<tr>\n<td class=\"menucontent\">".$yabs->get_cats()."</td>\n</tr>\n";
		$right_menu .= "<tr>\n<td class=\"menufooter\">&nbsp;</td>\n</tr>\n";
	}
	
	if($config['rss']){
		$right_menu .= "<tr>\n<td class=\"menuheader\">".$lang['syndication']."</td>\n</tr>\n";
		$right_menu .= "<tr>\n<td class=\"menucontent\">\n";
		if(!isset($_GET['cat']) || !is_numeric($_GET['cat'])){
			$_GET['cat'] = '';
		}
		$right_menu .= "<a href=\"".rss_url('RSS20', $_GET['cat'])."\"><img src=\"".site_true_home()."/images/rss20.png\" border=\"0\" alt=\"RSS 2.0\" /></a><br />\n";
		$right_menu .= "<a href=\"".rss_url('RSS10', $_GET['cat'])."\"><img src=\"".site_true_home()."/images/rss10.png\" border=\"0\" alt=\"RSS 1.0\" /></a><br />\n";
		$right_menu .= "<a href=\"".rss_url('ATOM', $_GET['cat'])."\"><img src=\"".site_true_home()."/images/atom03.png\" border=\"0\" alt=\"ATOM 0.3\" /></a><br />\n";
		$right_menu .= "</td>\n</tr>\n";
		$right_menu .= "<tr>\n<td class=\"menufooter\">&nbsp;</td>\n</tr>\n";
	}
	
	$title_rss20 = 'RSS 2.0';
	$title_rss10 = 'RSS 1.0';
	$title_atom03 = 'ATOM 0.3';
	if(!isset($_GET['cat']) || !is_numeric($_GET['cat'])){
		$_GET['cat'] = '';
	}else{
		$title_rss20 .= ' (Categorie='.$_GET['cat'].')';
		$title_rss10 .= ' (Categorie='.$_GET['cat'].')';
		$title_atom03 .= ' (Categorie='.$_GET['cat'].')';
	}
	$tpl->fillin('RSS20_HEAD', '<link rel="alternate" type="application/rss+xml" title="'.$title_rss20.'" href="'.rss_url('RSS20', $_GET['cat']).'" />');
	$tpl->fillin('RSS10_HEAD', '<link rel="alternate" type="application/rss+xml" title="'.$title_rss10.'" href="'.rss_url('RSS10', $_GET['cat']).'" />');
	$tpl->fillin('ATOM03_HEAD', '<link rel="alternate" type="application/atom+xml" title="'.$title_atom03.'" href="'.rss_url('ATOM', $_GET['cat']).'" />');
		
	$right_menu .= "</table>";
	$tpl->fillin('RIGHT_MENU', $right_menu);
	
	$query = array();
	$query['site'] = 'admin';
	//$tpl->fillin('ADMINPANEL', "<a href=\"".url($query)."\">".$lang['adminpanel']."</a>");
	$tpl->fillin('ADMINPANEL', '<a href="'.site_true_home().'/admin.php">'.$lang['adminpanel'].'</a>');
	$tpl->fillin('QUERYNUM', $db->get_querynum());
	
	$tpl->fillin('SITE_HOME', url());
	$tpl->fillin('SITE_TRUE_HOME', site_true_home());
	
	$db->disconnect();
	
	//Calcualte Rendertime	
	$rendertime = round(array_sum(explode(' ', microtime())) - $rendertime_start, 4);
	$tpl->fillin('RENDER_FILLIN', $rendertime);
	
	// +-----------------------------------------------------+
	// | Send Header                                         |
	// +-----------------------------------------------------+
	if(!headers_sent()){
		header('X-Blog: yabs '.$yabs->get_version());
		header('Cache-control: private, pre-check=0, post-check=0, max-age=0');
		header("Pragma: no-cache");
		header('Expires: 0');
	}
	
	$tpl->print_tpl();

?>