<?php

###################################################################################
### class.template.php                                                          ###
### Erstellt: 2004-08-08                                                        ###
### Bearbeitet: 2005-06-01                                                      ###
### (c) 2004 by Daniel Triendl                                                  ###
### http://www.falke666.at.tt                                                   ###
###################################################################################

###################################################################################
### This program is free software; you can redistribute it and/or modify        ###
### it under the terms of the GNU General Public License as published by        ###
### the Free Software Foundation; either version 2 of the License, or           ###
### (at your option) any later version.                                         ###
###                                                                             ###
### This program is distributed in the hope that it will be useful,             ###
### but WITHOUT ANY WARRANTY; without even the implied warranty of              ###
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               ###
### GNU General Public License for more details.                                ###
###################################################################################


###################################################################################
### Gzip verwenden, 0-9, 0 = off, 9 = best                                      ###
### Default = 6                                                                 ###
### Funktioniert nur wenn auch der Browser gzip untersttzt                     ###
###################################################################################
	define('TEMPLATE_GZIP', 0);

	class Template{
	
		var $_tpl = "";
		var $_error = "";
		var $_errno = 0;
		var $_version = 2.2;

###################################################################################
### bool open_tpl(string "tpl-file-name")                                       ###
### ffnet ein Template und speichert es in $_tpl                               ###
### Erwartete Parameter: tpl-file-name - Name des Templtes ohne .tpl            ###
###                                      Das Template muss in templates/        ###
###                                      liegen.                                ###
### Optionale Parameter: -                                                      ###
### Beispiel: $tpl->open_tpl("Template");                                       ###
### Note: open_tpl gibt eine Warnung aus, wenn sie ohne Parameter               ###
###       aufgerufen wird.                                                      ###
###################################################################################

		function open_tpl($file, $subdir = "")
		{
			global $yabs;
			$this->_error = "No Error";
		    $this->_errno = 0;
			if(empty($subdir)){
			    $file = 'templates/'.trim($file);
			}else{
				$file = trim($subdir).'/'.trim($file);
			}
		    
		    if($this->_check($file)){
				$this->_read_file($file, false);
		    }else{
				$yabs->death_event("<b>Template Error:</b> ".$this->_error);
		    }
		}
		
###################################################################################
### void add_tpl(string "tpl-file-name")                                        ###
### ffnet ein Template und hngt es an $_tpl anl                               ###
### Erwartete Parameter: tpl-file-name - Name des Templtes ohne .tpl            ###
###                                      Das Template muss in templates/        ###
###                                      liegen.                                ###
### Optionale Parameter: -                                                      ###
### Beispiel: $tpl->add_tpl("Template");                                        ###
### Note: add_tpl gibt eine Warnung aus, wenn sie ohne Parameter                ###
###       aufgerufen wird.                                                      ###
###################################################################################

		function add_tpl($file, $subdir = "")
		{		    
		    global $yabs;
			$this->_error = "No Error";
		    $this->_errno = 0;
		    
		    if(empty($subdir)){
			    $file = 'templates/'.trim($file);
			}else{
				$file = trim($subdir).'/'.trim($file);
			}
		    
		    if($this->_check($file)){
				$this->_read_file($file, true);
		    }else{
				$yabs->death_event("<b>Template Error:</b> ".$this->_error);
		    }
		}
		
###################################################################################
### float version()                                                             ###
### Gibt Version zurck.                                                        ###
### Erwartete Parameter: -                                                      ###
### Optionale Parameter: -                                                      ###
###################################################################################
		
		function version()
		{
			return $this->_version;
		}
		
###################################################################################
### void fillin(string VARIABLE, string WERT)                                   ###
### Ersetzt in einem Template einen Platzhalter ( {VARIABLE} ) durch einen Wert ###
### Erwartete Parameter: VARIABLE      - Name des Platzhalters im Template ohne ###
###                                      Klammern ( {} ).                       ###
###                      WERT          - String druch den der Platzhalter       ###
###                                      ersetzt werden soll.                   ###
### Optionale Parameter: -                                                      ###
### Beispiel: $tpl->fillin("VARIABLE" "Das ist der Wert);                       ###
### Zugehriges Template: {VARIABLE}                                            ###
###################################################################################
		
		function fillin($var, $wert)
		{
			$this->_tpl = str_replace('{'.$var.'}', $wert, $this->_tpl);
		}
		
###################################################################################
### string fillin_explode(string VARIABLE, string WERT, string TEMPLATE         ###
### Ersetzt einen Platzhalter durch einen String. Im Gegensatz zu fillin() muss ###
### hier auch ein String (TEMPLATE) angegeben in dem der Platzhalter ersetzt    ###
### werden soll und nach den ersetzen wird ein String zurckgegeben.            ###
### Diese Funktion eignet sich Z.B. fr ein Template-Teil, das man von          ###
### parse_explodes() erhalten hat.                                              ###
### Erwartete Parameter: VARIABLE      - Name des Platzhalters im Template ohne ###
###                                      Klammern ( {} ).                       ###
###                      WERT          - String druch den der Platzhalter       ###
###                                      ersetzt werden soll.                   ###
###                      TEMPLATE      - String in dem der Platzhalter          ###
###                                      enthalten ist.                         ###
### Optionale Parameter: -                                                      ###
### Beispiel: $explode->fillin_explode($variable, $wert, $template);            ###
### Note: fillin_explode() gibt eine Warnung aus, wenn sie ohne Parameter       ###
###       aufgerufen wird.                                                      ###
###       Siehe auch parse_explodes() und return_tpl();                         ###
###################################################################################
		
		function fillin_explode($var, $wert, $template)
		{
			return str_replace('{'.$var.'}', $wert, $template);
		}
		
###################################################################################
### string parse_explodes([int PIECE])                                          ###
### Zerlegt ein Template in verschiedene Teile. Die Teile werden innerhalb des  ###
### Templates durch {EXPLODE} getrennt.                                         ###
### Erwartete Parameter: -                                                      ###
### Optionale Parameter: PIECE        - Teil des Templates der returned         ###
###                                     wird. Der 1. Teil des Templates hat     ###
###                                     den Index 0. Default: 0                 ###
### Beispiel: $explode=$tpl->parse_explodes(0)                                  ###
###           while(BEDINGUNG){                                                 ###
###               $explode->fillin_explode("VARIABLE", "WERT", $explode);       ###
###               print $explode;                                               ###
###           }                                                                 ###
### Note: Sollte das Template mehrere Pieces haben knnen diese ber            ###
###       print_array ausgegeben bzw ber return_tpl returned werden.           ###
###       Siehe auch fillin_explode()                                           ###
###################################################################################
		
		function parse_explodes($piece = 0)
		{
			$this->_tpl = explode('{EXPLODE}', $this->_tpl);
			return $this->_tpl[$piece];
		}
		
###################################################################################
### bool parse_implode()                                                        ###
### Fgt einen zuvor mit parse_explode() zerlegtes Template wieder zusammen.    ###
### Gibt false zurck, wenn $_tpl kein Array ist.                               ###
### Erwartete Parameter: -                                                      ###
### Optionale Parameter: -                                                      ###
### Beispiel: $tpl->parse_implode();                                            ###
### Note: Eine berprfung ob das File ein Array ist, ist normalerweise nicht   ###
###       ntig, da es dann soweiso ein normaler String ist.                    ###
###################################################################################
		
		function parse_implode()
		{
		    $error = false;
			if(is_array($this->_tpl)){
				$this->_tpl = implode($this->_tpl);
			}else{
			    $error = true;
			}
			return !$error;
		}
		
###################################################################################
### bool replace_array(string "str", int "piece")                               ###
### Ersetzt ein Beliebiges Array von $str, oder legt es an, sofern $_tpl schon  ###
### ein Array ist.                                                              ###
### Wenn $_tpl kein Array ist, wird false zurckgeeben.                         ###
### Erwartete Parameter: STR           - Der String, mit dem das Array ersetzt  ###
###                                      werden soll.                           ###
###                      PIECE         - Die Nummer des Array das ersetzt       ###
###                                      werden soll.                           ###
### Optionale Parameter: -                                                      ###
### Beispiel: $tpl->replace_array($string, 0);                                  ###
### Note: Eine berprfung ob das File ein Array ist, ist normalerweise nicht   ###
###       ntig, da man diese Funktion eigendlich nur verwendet, nachdem man    ###
###       mit parse_explode() $_tpl in ein Array aufgespaten hat.               ###
###################################################################################

		function replace_array($str, $piece)
		{
			$error = false;
		    if(is_array($this->_tpl)){
				$this->_tpl[$piece] = $str;
			}else{
				$error = true;
			}
			return !$error;
		}

###################################################################################
### void print_tpl($gzip)                                                       ###
### Gibt das Template aus.                                                      ###
### Erwartete Parameter: gzip         - Ausgabe wird mit dem Angegebenen gzip   ###
###                                     Level komprimiert (0 off, 9 best)       ###
### Optionale Parameter: -                                                      ###
### Beispiel: $tpl->print_tpl();                                                ###
### Note: Funktioniert nicht, wenn vorher parse_explodes() ohne parse_implode() ###
###       benutzt wurde. In diesem Fall dann bitte print_array() benutzen.      ###
###################################################################################
		
		function print_tpl($gzip = TEMPLATE_GZIP)
		{
			if($gzip > 0 && isset($_SERVER['HTTP_ACCEPT_ENCODING']) && preg_match('/gzip/', $_SERVER['HTTP_ACCEPT_ENCODING']) && !headers_sent()){
				$this->_tpl = gzencode($this->_tpl, $gzip);
				header('Content-Encoding: gzip');
			}
			print $this->_tpl;
		}
		
###################################################################################
### void print_array(int PIECE)                                                 ###
### Gibt einen bestimmten Teil des Templates aus, wenn vorher parse_explodes()  ###
### benutzt wurde.                                                              ###
### Erwartete Parameter: PIECE        - Teil des Templates der returned         ###
###                                     wird. Der 1. Teil des Templates hat     ###
###                                     den Index 0. Default: 0                 ###
### Optionale Parameter: -                                                      ###
### Beispiel: $tpl->print_array(1);                                             ###
### Note: parse_hf() gibt eine Warnung aus, wenn sie ohne Parameter             ###
###       aufgerufen wird.                                                      ###
###       Kann bei falscher Benutzung einen Error, bzw eine Warunung            ###
###       ausgeben.                                                             ###
###       Siehe auch parse_explodes() und fillin_explode();                     ###
###################################################################################

		function print_array($piece)
		{
			if($gzip > 0 && isset($_SERVER['HTTP_ACCEPT_ENCODING']) && preg_match('/gzip/', $_SERVER['HTTP_ACCEPT_ENCODING']) && !headers_sent()){
				$this->_tpl[$piece] = gzencode($this->_tpl[$piece], $gzip);
				header('Content-Encoding: gzip');
			}
			print $this->_tpl[$piece];
		}
		
###################################################################################
### string return_array([int PIECE])                                            ###
### Returned das Template.                                                      ###
### Erwartete Parameter: -                                                      ###
### Optionale Parameter: PIECE         - Wenn vorher parse_explodes() benutzt   ###
###                                      wurde wird automatisch nur ein Teil    ###
###                                      des Templates ausgegeben. Welcher Teil ###
###                                      das ist wird durch PIECE angegeben.    ###
### Beispiel $tpl->return_tpl();                                                ###
### Note: Kann bei falscher benutzung einen Error, bzw eine Warunung            ###
###       ausgeben.                                                             ###
###       Siehe auch parse_explodes() und fillin_explode();                     ###
###################################################################################

		function return_tpl($piece = 0)
		{
			if(is_array($this->_tpl)){
				return $this->_tpl[$piece];
			}else{
				return $this->_tpl;
			}
		}

###################################################################################
### void _read_file(string "file", bool append)                                 ###
### -Private Funktion, nicht direkt aufrufen-                                   ###
###################################################################################

		function _read_file($file, $append)
		{
		    $f = fopen($file, 'r');
		    $inhalt = $inhalt = fread($f, filesize($file));
		    fclose($f);
		    
		    if($append){
		        $this->_tpl .= $inhalt;
		    }else{
				$this->_tpl = $inhalt;
		    }
		       
		}
		
###################################################################################
### bool _check(string "file")                                                  ###
### -Private Funktion, nicht direkt aufrufen-                                   ###
###################################################################################

		function _check($file)
		{
			if(file_exists($file)){
				if(filesize($file) > 0){
					$error = false;
					$this->_error = "No error";
					$this->_errno = 0;
				}else{
					$error = true;
					$this->_error = "Wrong filesize: 0 Byte (".$file.")";
					$this->_errno = 2;
				}
			}else{
				$error = true;
				$this->_error = "File not found (".$file.")";
				$this->_errno = 1;
			}
			
			return !$error;
		}

	}

?>