<?php

// +-----------------------------------------------------+
// | class.pingbck.inc.php                               |
// | =====================                               |
// |                                                     |
// | Sends a pingback-request to a site                  |
// | Started: 2005-07-07                                 |
// +-----------------------------------------------------+

	require_once('inc/class.socket.inc.php');

	class Pingback extends Socket
	{
		var $_PingError = false;
		var $_data = "";
		
		function Pingback($url, $autodiscover = true)
		{
			$this->_TBerror = false;
			//if(!($this->_data = @implode("", @file($url)))) $this->_TBerror = true;
			if($autodiscover){
				$target = parse_url($url);
				if(empty($target['query'])){
					$target['query'] = '';
				}else{
					$target['query'] = '?'.$target['query'];
				}
				if(empty($target['path'])) $target['path'] = '';
				
				$this->_url = $target['host'];
				if($this->connect()){
					$this->write("GET ".$target['path'].$target['query']." HTTP/1.1\r\n");
					$this->write("Host: ".$this->_url."\r\n");
					$this->write("Connection: Close\r\n\r\n");
					$this->_data = $this->read();
					//echo $this->_data;
					$this->disconnect();
				}else{
					$this->_PingError = true;
				}
			}
		}
		
		function SearchPing()
		{
			if(preg_match('/X-Pingback: (.+)\s/Uis', $this->_data, $match)){
				var_dump($match);
				$this->_Ping = $match[1];
				$return = true;
			}else{
				if(preg_match('/<link rel="pingback" href="([^"]+)"/Uis', $this->_data, $match)){
					$this->_Ping = $match[1];
					$return = true;
				}else{
					$return = false;
				}
			}
			
			$this->_Ping = str_replace('&amp;', '&', $this->_Ping);
			
			return $return;
		}
		
		function SendPing($sourceURI, $targetURI)
		{
			$data = "<?xml version=   \"1.0\"?>\n";
			$data .= "<methodCall\n>";
			$data .= "<methodName>pingback.ping</methodName>\n";
			$data .= "<params>\n";
			//$data .= "<param>\n";
			//$data .= "<name>sourceURI</name>\n";
			//$data .= "<value><string>".$sourceURI."</string></value>\n";
			//$data .= "</param>\n";
			$data .= "<param>\n";
			$data .= "<name>targetURI</name>\n";
			$data .= "<value><string>".$targetURI."</string></value>\n";
			$data .= "</param>\n";
			$data .= "</params>\n";
			$data .= "</methodCall>\n";
			$datalength = strlen($data);
			
			$target = parse_url($this->_Ping);
			$this->_url = $target['host'];
			if(!empty($target['port'])){
				$this->_port = $target['port'];
			}
			if(!empty($target['query'])){
				$query = "?".$target['query'];
			}else{
				$query = "";
			}
			
			$this->connect() || $this->_TBerror = true;
			if(!$this->_TBerror){
				$this->write("POST ".$query." HTTP/1.0\r\n");
				$this->write("User-Agent: yabs xmlrpc\r\n");
				$this->write("Host: ".$this->_url."\r\n");
				$this->write("Content-Type: text/xml\r\n");
				$this->write("Content-Length: ".$datalength."\r\n\r\n");
				$this->write($data);
				$this->_data = $this->read();
				$this->disconnect();
				echo $this->_data;
			}else{
				$return = "";
			}
			return $return;
		}
		
		function GetPingStatus(){
			if($this->_PingError){
				return false;
			}else{
				return true;
			}
		}		
	}

?>