<?php

/*
 * name		trackback.php
 * begin	May 20, 2005
 * 
 * $Id: trackback.php 103 2007-08-21 02:10:36Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

define( 'INSIDE', true );

require( './includes/init.php' );

$tpl = new template();
$tpl->add( 'trackback.txml' );

$error = '';

if( $config['accept_trackback'] == 1 ) {
	if( !empty( $_GET['trackback'] ) ) {
		$sql = "SELECT entry_id, entry_title, entry_nofeedback, comment_number FROM " . TABLE_BLOG . " WHERE entry_title = '" . $db->escape( urldecode( $_GET['trackback'] ) ) . "';";
		$res = $db->query( $sql );
		if( $db->numrows( $res ) ) {
			$row = $db->fetch( $res );
			$db->free( $res );
			if( $row['entry_nofeedback'] == 0 ) {
				if( !empty( $_POST['url'] ) && preg_match( '/^(http|https):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,6}((:[0-9]{1,5})?\/.*)?$/i', $_POST['url'] ) ) {
					$trackback['url'] = $_POST['url'];
					$trackback['blog_name'] = ( !empty( $_POST['blog_name'] ) ) ? $_POST['blog_name'] : substr( $_POST['url'], 0, 30 );
					$trackback['title'] =  ( !empty($_POST['title'] ) ) ? $_POST['title'] : substr( $_POST['url'], 0, 30 );
					$trackback['excerpt'] = ( !empty( $_POST['excerpt'] ) ) ? $_POST['excerpt'] : '[...]';
					$trackback['spam'] = 0;
					$plug->runhook( 'hook_trackback_validating' );
					if( empty( $error ) ) {
						$sql = "INSERT INTO " . TABLE_COMMENTS . " (
									entry_id,
									comment_author_name,
									comment_title,
									comment_content,
									comment_author_ip,
									comment_author_hostname,
									comment_author_url,
									comment_date,
									comment_active,
									comment_spam
								) VALUES (
									'" . $db->escape( $row['entry_id'] ) . "',
									'" . $db->escape( $trackback['blog_name'] ) . "',
									'" . $db->escape( $trackback['title'] ) . "',
									'" . $db->escape( $trackback['excerpt'] ) . "',
									'" . $_SERVER['REMOTE_ADDR'] . "',
									'" . gethostbyaddr( $_SERVER['REMOTE_ADDR'] ) . "',
									'" . $db->escape( $trackback['url'] ) . "',
									'" . time_utc() . "',
									'" . $config['activate_comments'] . "',
									'" . $db->escape( $trackback['spam'] ) . "'
								);";
						$db->query( $sql );
						if( !$trackback['spam'] && $config['activate_comments'] ) {
							$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . ( $row['comment_number'] + 1 ) . "' WHERE entry_id = '" . $row['entry_id'] . "';";
							$db->query( $sql );
						}
					}
				} else {
					$error = 'URL missing'; 
				}
			} else {
				$error = 'Trackback not allowed';
			}
		} else {
			$error = 'Entry not found';
		}
	} else {
		$error = 'Entry not found';
	}
} else {
	$error = 'Trackback not allowed';
}

header( 'Content-Type: text/xml; charset=' . $lang['charset'] );

if( empty( $error ) ) {
	$error = 0;
	$message = '';
} else {
	$message = '<message>' . $error . '</message>';
	$error = 1;
}

$tpl->fillin_array( array(
	'S_CHARSET' => $lang['charset'],
	'S_MESSAGE' => $message,
	'S_ERROR' => $error,
) );

$tpl->output();

?>