<?php
/*
 * name		plugins.php
 * begin	Februray 11, 2007
 * 
 * $Id: plugins.php 99 2007-08-09 12:49:57Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if ( $user->getRight( 'plugins' ) ) {
	
	if ( isset( $_GET['plugin'] ) ) {
		if( file_exists( './plugins/' . $_GET['plugin'] . '/plugin.xml' ) && 
			file_exists( './plugins/' . $_GET['plugin'] . '/plugin.php' ) ) {
			$_GET['action'] = ( !empty( $_GET['action'] ) ) ? $_GET['action'] : '';
			$_GET['plugin'] = urldecode( $_GET['plugin'] );
			$plugin = object2array( new SimpleXMLElement( './plugins/' . $_GET['plugin'] . '/plugin.xml', NULL, true ) );
			if( !empty( $plugin['name'] ) && !empty( $plugin['version'] ) ) {
				if( file_exists( './plugins/' . $_GET['plugin'] . '/install.php' ) ) {
					require_once( './plugins/' . $_GET['plugin'] . '/install.php' );
				}
				switch ( $_GET['action'] ) {
					case 'install':
						$tpl->add( 'empty.tpl' );
						$sql = "SELECT
									plugin_name
								FROM
									" . TABLE_PLUGINS ."
								WHERE
									plugin_name = '" . $db->escape( $_GET['plugin']) . "';";
						$res = $db->query( $sql );
						if ( !$db->numrows( $res ) ) {
							if ( !function_exists( 'install') || install() ) {
								$sql = "INSERT INTO " . TABLE_PLUGINS ." (
											plugin_name,
											plugin_version )
										VALUES (
											'" . $db->escape( $_GET['plugin'] ) . "',
											'" . $db->escape( $plugin['version'] ) . "' );";
								$db->query( $sql );
								$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_installed'] );
								//$_GET['action'] = 'rebuild';
							} else {
								$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_error_install_failed'] );
							}
						} else {
							$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_error_already_installed'] );
						}
						break;
					case 'uninstall':
						$tpl->add( 'empty.tpl' );
						$sql = "SELECT
									plugin_name
								FROM
									" . TABLE_PLUGINS ."
								WHERE
									plugin_name = '" . $db->escape( $_GET['plugin']) . "';";
						$res = $db->query( $sql );
						if ( $db->numrows( $res ) ) {
							if ( !function_exists( 'uninstall') || uninstall() ) {
								$sql = "DELETE FROM " . TABLE_PLUGINS ." WHERE plugin_name = '" . $db->escape( $_GET['plugin'] ) . "';";
								$db->query( $sql );
								$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_uninstalled'] );
								//$_GET['action'] = 'rebuild';
							} else {
								$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_error_uninstall_failed'] );
							}
						} else {
							$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_error_not_installed'] );
						}
						break;
					case 'update':
						$tpl->add( 'empty.tpl' );
						$sql = "SELECT
									plugin_name
								FROM
									" . TABLE_PLUGINS ."
								WHERE
									plugin_name = '" . $db->escape( $_GET['plugin']) . "';";
						$res = $db->query( $sql );
						if ( $db->numrows( $res ) ) {
							if ( !function_exists( 'update' ) || update() ) {
								$sql = "UPDATE
											" . TABLE_PLUGINS ."
										SET
											plugin_version = '" . $db->escape( $plugin['version'] ) . "' 
										WHERE
											plugin_name = '" . $db->escape( $_GET['plugin'] ) . "';";
								$db->query( $sql );
								$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_updated'] );
								//$_GET['action'] = 'rebuild';
							} else {
								$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_error_update_failed'] );
							}
						} else {
							$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_error_not_installed'] );
						}
						break;
					default:
						break;
				}
			}
		}
	}
	/*
	if ( isset( $_GET['action'] ) && $_GET['action'] == 'rebuild' ) {
		$tpl->add( 'empty.tpl' );
		if ( is_writable( './plugins/plugins.php' ) ) {
			$sql = "SELECT
						plugin_name
					FROM
						" . TABLE_PLUGINS .";";
			$res = $db->query( $sql );
			$write = '<?php' . "\n";
			while ( $row = $db->fetch( $res ) ) {
				if ( file_exists( './plugins/' . $row['plugin_name'] . '/plugin.php' ) &&
						file_exists( './plugins/' . $row['plugin_name'] . '/plugin.xml' ) ) {
					$write .= 'include_once(\'./plugins/' . $row['plugin_name'] . '/plugin.php\');' . "\n";
				} else {
					$sql = "DELETE FROM " . TABLE_PLUGINS ." WHERE plugin_name = '" . $db->escape( $row['plugin_name'] ) . "';";
					$db->query( $sql ); 
				}
			}
			$write .= '?>';
			$f = fopen( './plugins/plugins.php', 'w+' );
			fwrite( $f, $write );
			fclose( $f );
			$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_rebuilded'] );
		} else {
			$tpl->fillin( 'S_CONTENT', $lang['admin_plugin_error_not_writeable'] );
		}
	}
	*/
	$dir = scandir( './plugins' );
	$tpl->add( 'plugins.tpl' );
	$tpl->part_seperate( 'E_PLUGINS' );
	$i = 0;
	foreach ( $dir as $folder ) {
		if ( $folder != '.' && $folder != '..' && is_dir( './plugins/' . $folder ) && substr( $folder, 0, 5 ) != 'yabs_' ) {
			if ( file_exists( './plugins/' . $folder . '/plugin.xml' ) && 
					file_exists( './plugins/' . $folder . '/plugin.php' ) ) {
				$plugin = object2array( new SimpleXMLElement( './plugins/' . $folder . '/plugin.xml', NULL, true ) );
				if ( !empty( $plugin['name'] ) && !empty( $plugin['version'] ) ) {
					if ( $i == 0 ) {
						$css_table_row = 'yabs_table_row_dark';
						$i = 1;
					} else {
						$css_table_row =  'yabs_table_row_light';
						$i = 0;
					}
					$tpl->part_load();
					$sql = "SELECT
								plugin_name,
								plugin_version
							FROM
								" . TABLE_PLUGINS ."
							WHERE
								plugin_name = '" . $db->escape( $plugin['name'] ) . "';";
					$res = $db->query( $sql );
					$plugin['installed_version'] = '';
					if ( $db->numrows( $res ) ) {
						$row = $db->fetch( $res );
						if ( version_compare( $row['plugin_version'], $plugin['version'] ) == -1 ) {
							$plugin['action'] = '<span class="yabs_text_middle">' . $lang['admin_plugin_update'] . '</span>';
							$action_url = array(
								'site' => 'plugins',
								'action' => 'update',
								'plugin' => urlencode( $folder ),
							);
							$plugin['installed_version'] = $row['plugin_version'];
						} else {
							$plugin['action'] = '<span class="yabs_text_false">' . $lang['admin_plugin_uninstall'] . '</span>';
							$action_url = array(
								'site' => 'plugins',
								'action' => 'uninstall',
								'plugin' => urlencode( $folder ),
							);
							$plugin['installed_version'] = $row['plugin_version'];
						}
					} else {
						$plugin['action'] = '<span class="yabs_text_true">' . $lang['admin_plugin_install'] . '</span>';
						$action_url = array(
							'site' => 'plugins',
							'action' => 'install',
							'plugin' => urlencode( $folder ),
						);
					}
					$plugin['description'] = ( !empty( $plugin['description'] ) ) ? $plugin['description'] : '';
					$plugin['author'] = ( !empty( $plugin['author'] ) ) ? $plugin['author'] : '';
					$tpl->fillin_array( array( 
						'S_PLUGIN_NAME' => $plugin['name'],
						'S_PLUGIN_VERSION' => $plugin['version'],
						'S_PLUGIN_INSTALLED_VERSION' => $plugin['installed_version'],
						'S_PLUGIN_ACTION' => '<a href="' . aurl( $action_url ) . '">' . $plugin['action'] . '</a>',
						'S_PLUGIN_DESCRIPTION' => $plugin['description'],
						'S_PLUGIN_AUTHOR' => $plugin['author'],
						'S_CSS_TABLE_ROW' => $css_table_row,
					) );
				}
			}
		}
	}
	$tpl->part_unite();
	$rebuild_url = array( 'site' => 'plugins', 'action' => 'rebuild' );
	$tpl->fillin_array( array(
		'S_PLUGIN_NAME_TEXT' => $lang['name'],
		'S_PLUGIN_VERSION_TEXT' => $lang['version'],
		'S_PLUGIN_INSTALLED_VERSION_TEXT' => $lang['admin_plugin_installed_version'],
		'S_PLUGIN_DESCRIPTION_TEXT' => $lang['description'],
		'S_PLUGIN_AUTHOR_TEXT' => $lang['author'],
//		'S_PLUGIN_REBUILD' => '<a href="' . aurl( $rebuild_url ) . '">' . $lang['admin_plugin_rebuild'] . '</a>',
	) );
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}

?>