<?php
/*
 * name		menu.php 
 * begin	May 16, 2007
 * 
 * $Id: menu.php 99 2007-08-09 12:49:57Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if( $user->getRight('settings' ) ) {
	switch( @$_GET['action'] ) {
		case 'edit':
			if( isset( $_POST['menu_save'] ) ) {
				$menu_error = array();
				if( !isset( $_POST['menu_name'] ) ) $_POST['menu_name'] = '';
				if( !isset( $_POST['menu_url'] ) ) $_POST['menu_url'] = '';
				if( empty( $_POST['menu_name'] ) ) $menu_error['menu_name'] = $lang['error_noname'];
				if( empty( $_POST['menu_url'] ) ) $menu_error['menu_url'] = $lang['admin_error_menu_url'];
				if( count( $menu_error ) == 0 ) {
					$sql = '';
					if( isset( $_GET['menu_id'] ) && is_numeric( $_GET['menu_id'] ) ) {
						$sql = "SELECT menu_id FROM " . TABLE_MENU . " WHERE menu_id = '" . $db->escape( $_GET['menu_id'] ) . "';";
						$res = $db->query( $sql );
						if( $db->numrows( $res ) ) {
							$row = $db->fetch( $res );
							$sql = "UPDATE
										" . TABLE_MENU . "
									SET
										menu_name = '" . $db->escape( $_POST['menu_name'] ) . "',
										menu_url = '" . $db->escape( $_POST['menu_url'] ) . "'
									WHERE
										menu_id = '" . $db->escape( $row['menu_id'] ) . "';";
						}
						$db->free( $res );
					}
					if( empty( $sql ) ) {
						$sql = "SELECT menu_id FROM " . TABLE_MENU . ";";
						$res = $db->query( $sql );
						$num = $db->numrows( $res );
						$db->free( $res );
						$num += 1;
						$sql = "INSERT INTO " . TABLE_MENU . " (
									menu_name,
									menu_url,
									menu_order
								) VALUES (
									'" . $db->escape( $_POST['menu_name'] ) . "',
									'" . $db->escape( $_POST['menu_url'] ) . "',
									'" . $db->escape( $num ) . "'
								);";
					}
					$db->query( $sql );
					header( 'Location:' . aurl( array( 'site' => 'menu' ), false ) );
					die( '<a href="' . aurl( array('site' => 'menu' ) ) . '">' . $lang['continue'] . '</a>' );
				}
			}
			$tpl->add( 'menu_form.tpl' );
			if( isset( $menu_error['menu_name'] ) ) {
				$tpl->fillin_array( array(
					'S_SITEMENU_NAME_ERROR' => $menu_error['menu_name'],
					'I_SITEMENU_NAME' => '<input type="text" name="menu_name" value="' . $_POST['menu_name'] . '" class="yabs_form_error" />',
				) );
			} elseif( isset( $_POST['menu_name'] ) ) {
				$tpl->fillin( 'I_SITEMENU_NAME', '<input type="text" name="menu_name" value="' . $_POST['menu_name'] . '" />' );
			}
			if( isset( $menu_error['menu_url'] ) ) {
				$tpl->fillin_array( array(
					'S_SITEMENU_URL_ERROR' => $menu_error['menu_url'],
					'I_SITEMENU_URL' => '<input type="text" name="menu_url" value="' . $_POST['menu_url'] . '" class="yabs_form_error" />',
				) );
			} elseif( isset( $_POST['menu_url'] ) ) {
				$tpl->fillin( 'I_SITEMENU_URL', '<input type="text" name="menu_url" value="' . $_POST['menu_url'] . '" />' );
			}
			if( isset( $_GET['menu_id'] ) && is_numeric( $_GET['menu_id'] ) ) {
				$sql = "SELECT menu_id, menu_name, menu_url FROM " . TABLE_MENU . " WHERE menu_id = '" . $db->escape( $_GET['menu_id'] ) . "';";
				$res = $db->query( $sql );
				if( $db->numrows( $res ) ) {
					$row = $db->fetch( $res );
					$tpl->fillin_array( array( 
						'I_SITEMENU_NAME' => '<input type="text" name="menu_name" value="' . $row['menu_name'] . '" />',
						'I_SITEMENU_URL' => '<input type="text" name="menu_url" value="' . $row['menu_url'] . '" />',
						'L_SITEMENU_ACTION' => aurl( array( 'site' => 'menu', 'action' => 'edit', 'menu_id' => $row['menu_id'] ) ),
					) );
				}
				$db->free( $res );
			}
			$tpl->fillin_array( array(
				'S_SITEMENU_NAME' => $lang['name'] . ':',
				'I_SITEMENU_NAME' => '<input type="text" name="menu_name" />',
				'S_SITEMENU_URL' => $lang['link_url'] . ':',
				'I_SITEMENU_URL' => '<input type="text" name="menu_url" />',
				'L_SITEMENU_ACTION' => aurl( array( 'site' => 'menu', 'action' => 'edit' ) ),
				'I_SITEMENU_SUBMIT' => '<input type="submit" name="menu_save" value="' . $lang['save'] . '" />',
				'S_SITEMENU_NAME_ERROR' => '',
				'S_SITEMENU_URL_ERROR' => '',
			) );
			break;
		case 'delete':
			if( isset( $_GET['menu_id'] )  && is_numeric( $_GET['menu_id'] ) ) {
				if ( isset( $_GET['yabsonce'] ) && $_GET['yabsonce'] == $user->getOnce() ) {
					$sql = "SELECT menu_id, menu_order FROM " . TABLE_MENU . " WHERE menu_id = '" . $db->escape( $_GET['menu_id'] ) . "';";
					$res = $db->query( $sql );
					if( $db->numrows( $res ) ) {
						$row = $db->fetch( $res ); 
						$sql = "DELETE FROM " . TABLE_MENU . " WHERE menu_id = '" . $db->escape( $row['menu_id'] ) . "';";
						$db->query( $sql );
						$sql = "SELECT menu_id FROM " . TABLE_MENU . " WHERE menu_order > '" . $db->escape( $row['menu_order'] ) . "' ORDER BY menu_order ASC;";
						$res = $db->query( $sql );
						$order = $row['menu_order'];
						while( $row = $db->fetch( $res ) ) {
							$sql = "UPDATE " . TABLE_MENU . " SET menu_order = '" . $db->escape( $order ) . "' WHERE menu_id = '" . $db->escape( $row['menu_id'] ) . "';";
							$db->query( $sql );
							$order += 1;
						}
						header( 'Location: ' . aurl( array( 'site' => 'menu' ) , false) );
						die( '<a href="' . aurl( array('site' => 'menu' ) ) . '">' . $lang['continue'] . '</a>' );
					} else {
						$tpl->add( 'empty.tpl' );
						$tpl->fillin( 'S_CONTENT', $lang['admin_error_menu_notfound'] . $lang['back'] );
					}
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_invalid_link'] . $lang['back'] );
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_menu_notfound'] . $lang['back'] );
			}
			break;
		case 'move':
			if( isset( $_GET['menu_id'] )  && is_numeric( $_GET['menu_id'] )  && isset( $_GET['direction'] ) && ( $_GET['direction'] == 'up' || $_GET['direction'] == 'down' ) ) {
				$sql = "SELECT menu_id, menu_order FROM " . TABLE_MENU . " WHERE menu_id = '" . $db->escape( $_GET['menu_id'] ) . "';";
				$res = $db->query( $sql );
				$sql = '';
				if( $db->numrows( $res ) ) {
					$row = $db->fetch( $res );
					if( $_GET['direction'] == 'up' ) {
						if( $row['menu_order'] > 1) {
							$sql = "SELECT menu_id, menu_order FROM " . TABLE_MENU . " WHERE menu_order = '" . $db->escape( $row['menu_order'] - 1 ) . "';";
						}
					} elseif( $_GET['direction'] == 'down' ) {
						$sql = "SELECT menu_id, menu_order FROM " . TABLE_MENU . " WHERE menu_order = '" . $db->escape( $row['menu_order'] + 1 ) . "';";
					}
					if( !empty( $sql ) ) {
						$res = $db->query( $sql );
						if( $db->numrows( $res ) ) {
							$row2 = $db->fetch( $res );
							$sql = "UPDATE " . TABLE_MENU . " SET menu_order = '" . $db->escape( $row2['menu_order'] ) . "' WHERE menu_id = '" . $db->escape( $row['menu_id'] ) . "';";
							$db->query( $sql );
							$sql = "UPDATE " . TABLE_MENU . " SET menu_order = '" . $db->escape( $row['menu_order'] ) . "' WHERE menu_id = '" . $db->escape( $row2['menu_id'] ) . "';";
							$db->query( $sql );
						}
					}
				}
			}
			header( 'Location: ' . aurl( array( 'site' => 'menu' ) , false) );
			die( '<a href="' . aurl( array('site' => 'menu' ) ) . '">' . $lang['continue'] . '</a>' );
			break;
		case 'list':
		default:
			$sql = "SELECT
						menu_id,
						menu_name,
						menu_url
					FROM
						" . TABLE_MENU . "
					ORDER BY
						menu_order;";
			$res = $db->query( $sql );
			$tpl->add( 'menu_list.tpl' );
			$tpl->part_seperate( 'E_SITEMENU' );
			$i = 0;
			while( $row = $db->fetch( $res ) ) {
				if ( $i == 0 ) {
					$css_table_row = 'yabs_table_row_dark';
					$i = 1;
				} else {
					$css_table_row =  'yabs_table_row_light';
					$i = 0;
				}
				$tpl->part_load();
				$tpl->fillin_array( array(
					'S_SITEMENU_NAME' => $row['menu_name'],
					'L_SITEMENU_EDIT_LINK' => aurl( array( 'site' => 'menu', 'menu_id' => $row['menu_id'], 'action' => 'edit' ) ),
					'L_SITEMENU_DELETE_LINK' => aurl( array( 'site' => 'menu', 'menu_id' => $row['menu_id'], 'action' => 'delete', 'yabsonce' => $user->getOnce() ) ),
					'L_SITEMENU_VIEW_LINK' => $row['menu_url'],
					'S_CSS_TABLE_ROW' => $css_table_row,
					'L_SITEMENU_UP_LINK' => aurl( array( 'site' => 'menu', 'menu_id' => $row['menu_id'], 'action' => 'move', 'direction' => 'up' ) ),
					'L_SITEMENU_DOWN_LINK' => aurl( array( 'site' => 'menu', 'menu_id' => $row['menu_id'], 'action' => 'move', 'direction' => 'down' ) ),
				) );
			}
			$tpl->part_unite();
			$tpl->fillin_array( array(
				'I_SITEMENU_DELETE_CONFIRM' => 'onclick="return confirm(\'' . $lang['admin_sitemenu_delete_question'] . '\')""',
				'S_SITEMENU_DELETE_TEXT' => $lang['delete'],
				'S_SITEMENU_EDIT_TEXT' => $lang['edit'],
				'S_SITEMENU_VIEW_TEXT' => $lang['view'], 
				'S_SITEMENU_DATE_TEXT' => $lang['date'],
				'S_SITEMENU_NAME_TEXT' => $lang['name'],
				'S_SITEMENU_UP_LINK' => $lang['admin_sitemenu_up'],
				'S_SITEMENU_DOWN_LINK' => $lang['admin_sitemenu_down'],
				'S_SITEMENU_NEW' => '<a href="' . aurl( array( 'site' => 'menu', 'action' => 'edit' ) ) . '">' . $lang['admin_sitemenu_new'] . '</a>',
			) );
			break;
	}
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}
?>