<?php

/*
 * name		comments.php
 * begin	June 7, 2007
 * 
 * $Id: comments.php 99 2007-08-09 12:49:57Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if( $user->getRight('comments' ) ) {
	switch( @$_GET['action'] ) {
		case 'view':
			if ( isset( $_GET['comment_id'] ) && is_numeric( $_GET['comment_id'] ) ) {
				$sql = "SELECT
							comment_id,
							comment_author_name,
							comment_author_mail,
							comment_author_url,
							comment_author_ip,
							comment_author_hostname,
							comment_title,
							comment_content,
							comment_date,
							comment_active,
							comment_spam
						FROM " . TABLE_COMMENTS . " WHERE comment_id = '" . $db->escape( $_GET['comment_id'] ) . "';";
				$res = $db->query( $sql );
				if( $db->numrows( $res ) ) {
					$comment = $db->fetch( $res );
					$tpl->add( 'comment_view.tpl' );
					$comment_content = $plug->runfilter( 'filter_comment_content', $comment['comment_content'] );
					if( !empty( $comment['comment_title'] ) ) {
						$comment_content = $plug->runfilter( 'filter_comment_title', $comment['comment_title'] ) . '<br /><br />' . $comment_content; 
					}
					$tpl->fillin_array( array(
						'S_COMMENT_ID' => $comment['comment_id'],
						'S_COMMENT_CONTENT' => $comment_content,
						'S_COMMENT_AUTHOR_NAME' => $plug->runfilter( 'filter_comment_author_name', $comment['comment_author_name'] ),
						'S_COMMENT_AUTHOR_URL' => $plug->runfilter( 'filter_comment_author_url', $comment['comment_author_url'] ),
						'S_COMMENT_AUTHOR_MAIL' => $comment['comment_author_mail'],
						'S_COMMENT_DATE' => strftime( $config['time_format'], time_lokal( $comment['comment_date'] ) ),
						'S_COMMENT_AUTHOR_IP' => $comment['comment_author_ip'],
						'S_COMMENT_AUTHOR_HOSTNAME' => $comment['comment_author_hostname'],
						'S_COMMENT_ID_TEXT' => $lang['admin_comment_id'] . ':',
						'S_COMMENT_AUTHOR_NAME_TEXT' => $lang['name'] . ':',
						'S_COMMENT_AUTHOR_MAIL_TEXT' => $lang['mail'] . ':',
						'S_COMMENT_AUTHOR_URL_TEXT' => $lang['admin_comment_author_url'] . ':',
						'S_COMMENT_DATE_TEXT' => $lang['date'] . ':',
						'S_COMMENT_AUTHOR_IP_TEXT' => $lang['admin_comment_author_ip'] . ':',
						'S_COMMENT_AUTHOR_HOSTNAME_TEXT' => $lang['admin_comment_author_hostname'] . ':',
						'S_COMMENT_CONTENT_TEXT' => $lang['admin_comment_content'] . ':',
						'S_BACK' => $lang['back'],
					) );
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );
			}
			break;
		case 'edit':
			break;
		case 'spam':
			if ( isset( $_GET['comment_id'] ) && is_numeric( $_GET['comment_id'] ) ) {
				$sql = "SELECT comment_id, comment_spam, comment_active, entry_id FROM " . TABLE_COMMENTS . " WHERE comment_id = '" . $db->escape( $_GET['comment_id'] ) . "';";
				$res = $db->query( $sql );
				if( $db->numrows( $res ) ) {
					$row = $db->fetch( $res );
					$sql = "UPDATE " . TABLE_COMMENTS . " SET comment_spam = '" . $db->escape( !$row['comment_spam'] ) . "' WHERE comment_id = '" . $row['comment_id'] . "';";
					$db->query( $sql );
					$sql = "SELECT entry_id, comment_number FROM " . TABLE_BLOG . " WHERE entry_id = '" . $row['entry_id'] . "';";
					$res = $db->query( $sql );
					$erow = $db->fetch( $res );
					if( $row['comment_spam'] ) {
						$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . ( $erow['comment_number'] + 1 ) . "' WHERE entry_id = '" . $erow['entry_id'] . "';"; 
					} else {
						$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . ( $erow['comment_number'] - 1 ) . "' WHERE entry_id = '" . $erow['entry_id'] . "';";
					}
					if( $row['comment_active'] ) {
						$db->query( $sql );
					}
					$plug->runhook( 'hook_admin_comments_spam', $row['comment_id'] );
					$continue_url = array(
						'site' => 'comments',
						'action' => 'list'
					);
					if( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) ) {
						$continue_url['start'] = $_GET['start'];
					}
					header('Location: ' . aurl( $continue_url, false ) );
					die( '<a href="' . aurl( $continue_url ) . '">' . $lang['continue'] . '</a>' );
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );
			}
			break;
		case 'active':
			if ( isset( $_GET['comment_id'] ) && is_numeric( $_GET['comment_id'] ) ) {
				$sql = "SELECT comment_id, comment_spam, comment_active, entry_id FROM " . TABLE_COMMENTS . " WHERE comment_id = '" . $db->escape( $_GET['comment_id'] ) . "';";
				$res = $db->query( $sql );
				if( $db->numrows( $res ) ) {
					$row = $db->fetch( $res );
					$sql = "UPDATE " . TABLE_COMMENTS . " SET comment_active = '" . $db->escape( !$row['comment_active'] ) . "' WHERE comment_id = '" . $row['comment_id'] . "';";
					$db->query( $sql );
					$sql = "SELECT entry_id, comment_number FROM " . TABLE_BLOG . " WHERE entry_id = '" . $row['entry_id'] . "';";
					$res = $db->query( $sql );
					$erow = $db->fetch( $res );
					if( $row['comment_active'] ) {
						$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . ( $erow['comment_number'] - 1 ) . "' WHERE entry_id = '" . $erow['entry_id'] . "';"; 
					} else {
						$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . ( $erow['comment_number'] + 1 ) . "' WHERE entry_id = '" . $erow['entry_id'] . "';";
					}
					if( !$row['comment_spam'] ) {
						$db->query( $sql );
					}
					$continue_url = array(
						'site' => 'comments',
						'action' => 'list'
					);
					if( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) ) {
						$continue_url['start'] = $_GET['start'];
					}
					header('Location: ' . aurl( $continue_url, false ) );
					die( '<a href="' . aurl( $continue_url ) . '">' . $lang['continue'] . '</a>' );
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );
			}
			break;
		case 'delete':
			if ( isset( $_GET['comment_id'] ) && is_numeric( $_GET['comment_id'] ) ) {
				$sql = "SELECT comment_id, comment_spam, comment_active, entry_id FROM " . TABLE_COMMENTS . " WHERE comment_id = '" . $db->escape( $_GET['comment_id'] ) . "';";
				$res = $db->query( $sql );
				if( $db->numrows( $res ) ) {
					if ( isset( $_GET['yabsonce'] ) && $_GET['yabsonce'] == $user->getOnce() ) {
						$row = $db->fetch( $res );
						$sql = "DELETE FROM " . TABLE_COMMENTS . " WHERE comment_id = '" . $db->escape( $_GET['comment_id'] ) . "';";
						$db->query( $sql );
						$sql = "SELECT entry_id, comment_number FROM " . TABLE_BLOG . " WHERE entry_id = '" . $row['entry_id'] . "';";
						$res = $db->query( $sql );
						$erow = $db->fetch( $res );
						if( $row['comment_active'] ) {
							$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . ( $erow['comment_number'] - 1 ) . "' WHERE entry_id = '" . $erow['entry_id'] . "';"; 
						} else {
							$sql = "UPDATE " . TABLE_BLOG . " SET comment_number = '" . ( $erow['comment_number'] + 1 ) . "' WHERE entry_id = '" . $erow['entry_id'] . "';";
						}
						if( $row['comment_active'] && !$row['comment_spam'] ) {
							$db->query( $sql );
						}
						$continue_url = array(
							'site' => 'comments',
							'action' => 'list'
						);
						if( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) ) {
							$continue_url['start'] = $_GET['start'];
						}
						header('Location: ' . aurl( $continue_url, false ) );
						die( '<a href="' . aurl( $continue_url ) . '">' . $lang['continue'] . '</a>' );
					} else {
						$tpl->add( 'empty.tpl' );
						$tpl->fillin( 'S_CONTENT', $lang['admin_error_invalid_link'] . $lang['back'] );
					}
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );	
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_error_comment_notfound'] . $lang['back'] );	
			}
			break;
		case 'list':
		default:
			$sql = "SELECT
						c.comment_id,
						c.entry_id,
						c.comment_author_name,
						c.comment_author_mail,
						c.comment_author_ip,
						c.comment_date,
						c.comment_active,
						c.comment_spam,
						c.comment_title,
						e.entry_title
					FROM
						" . TABLE_COMMENTS . " c
					LEFT JOIN 
						" . TABLE_BLOG . " e
					ON (
						e.entry_id = c.entry_id )";
			
			if( isset( $_POST['comment_filter'] ) ) {
				if( isset( $_POST['comment_filter_active'] ) && is_numeric( $_POST['comment_filter_active'] ) ) $_SESSION['comment_filter_active'] = $_POST['comment_filter_active'];
				else $_SESSION ['comment_filter_active'] = -1;
				if( isset( $_POST['comment_filter_spam'] ) && is_numeric( $_POST['comment_filter_spam'] ) ) $_SESSION['comment_filter_spam'] = $_POST['comment_filter_spam'];
				else $_SESSION ['comment_filter_spam'] = -1;
				if( !empty( $_POST['comment_filter_mail'] ) ) $_SESSION['comment_filter_mail'] = $_POST['comment_filter_mail'];
				else $_SESSION['comment_filter_mail'] = '';
				if( !empty( $_POST['comment_filter_name'] ) ) $_SESSION['comment_filter_name'] = $_POST['comment_filter_name'];
				else $_SESSION['comment_filter_name'] = '';
				if( !empty( $_POST['comment_filter_ip'] ) ) $_SESSION['comment_filter_ip'] = $_POST['comment_filter_ip'];
				else $_SESSION['comment_filter_ip'] = '';
			}
			
			$sql1 = '';
			if( isset( $_SESSION['comment_filter_spam'] ) ) {
				if( $_SESSION['comment_filter_spam'] == 0 ) {
					if( !strlen( $sql1 ) ) $sql1 .= " WHERE";
					else $sql1 .= ' and';
					$sql1 .= " c.comment_spam = '0'";
				} else if( $_SESSION['comment_filter_spam'] == 1 ) {
					if( !strlen( $sql1 ) ) $sql1 .= " WHERE";
					else $sql1 .= ' and';
					$sql1 .= " c.comment_spam = '1'";
				}
			} else {
				$_SESSION['comment_filter_spam'] = -1;
			}
			if( isset( $_SESSION['comment_filter_active'] ) ) {
				if( $_SESSION['comment_filter_active'] == 0 ) {
					if( !strlen( $sql1 ) ) $sql1 .= " WHERE";
					else $sql1 .= ' and';
					$sql1 .= " c.comment_active = '0'";
				} else if( $_SESSION['comment_filter_active'] == 1 ) {
					if( !strlen( $sql1 ) ) $sql1 .= " WHERE";
					else $sql1 .= ' and';
					$sql1 .= " c.comment_active = '1'";
				}
			} else {
				$_SESSION['comment_filter_active'] = -1;
			}
			if( !empty( $_SESSION['comment_filter_ip'] ) ) {
				if( !strlen( $sql1 ) ) $sql1 .= " WHERE";
				else $sql1 .= ' and';
				$sql1 .=  " c.comment_author_ip = '" . $db->escape( $_SESSION['comment_filter_ip']) . "'";
			}
			if( !empty( $_SESSION['comment_filter_name'] ) ) {
				if( !strlen( $sql1 ) ) $sql1 .= " WHERE";
				else $sql1 .= ' and';
				$sql1 .= " c.comment_author_name = '" . $db->escape( $_SESSION['comment_filter_name'] ) . "'";
			}
			if( !empty( $_SESSION['comment_filter_mail'] ) ) {
				if( !strlen( $sql1 ) ) $sql1 .= " WHERE";
				else $sql1 .= ' and';
				$sql1 .= " c.comment_author_mail = '" . $db->escape( $_SESSION['comment_filter_mail'] ) . "' and";
			}
			if( substr( $sql1, strlen($sql1) - 3, 3 ) == 'and' ) $sql1 = substr( $sql1, 0, strlen( $sql1 ) - 3 );
			$sql .= $sql1 .= " ORDER BY c.comment_date DESC ";
			$offset = ( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) && $_GET['start'] >= 0 ) ? $_GET['start'] : 0;
			$sql .=  "LIMIT " . $db->escape( $offset ) . ", 30;";
			$res = $db->query( $sql );
			$tpl->add( 'comments_list.tpl' );
			$tpl->part_seperate( 'E_COMMENTS' );
			$i = 0;
			while( $row = $db->fetch( $res ) ) {
				$tpl->part_load();
				if ( $i == 0 ) {
					$css_table_row = 'yabs_table_row_dark';
					$i = 1;
				} else {
					$css_table_row =  'yabs_table_row_light';
					$i = 0;
				}
				$edit_url = array( 'site' => 'comments', 'comment_id' => $row['comment_id'], 'action' => 'edit' );
				$details_url = array( 'site' => 'comments', 'comment_id' => $row['comment_id'], 'action' => 'view' );
				$delete_url = array( 'site' => 'comments', 'comment_id' => $row['comment_id'], 'action' => 'delete', 'yabsonce' => $user->getOnce(), 'start' => $offset );
				$view_url = array( 'site' => 'blog',  'blog' => urlencode( $row['entry_title'] ) );
				$active_url = array( 'site' => 'comments', 'comment_id' => $row['comment_id'], 'action' => 'active', 'start' => $offset );
				$spam_url = array( 'site' => 'comments', 'comment_id' => $row['comment_id'], 'action' => 'spam', 'start' => $offset );
				if( empty( $row['comment_title'] ) ) $type = $lang['admin_comment_type_comment'];
				else $type = $lang['admin_comment_type_trackback'];
				if( !$row['comment_spam'] ) {
					if( $row['comment_active'] ) {
						$status = $lang['admin_comment_active'];
					} else {
						$status = $lang['admin_comment_inactive'];
					}
				} else {
					$status = $lang['admin_comment_spam'];
				}
				$tpl->fillin_array( array(
					'L_COMMENT_VIEW_LINK' => url( $view_url ) . '#com' . $row['comment_id'],
					'L_COMMENT_DETAILS_LINK' => aurl( $details_url ),
					'L_COMMENT_EDIT_LINK' => aurl( $edit_url ),
					'L_COMMENT_DELETE_LINK' => aurl( $delete_url ),
					'L_COMMENT_SPAM_LINK' => aurl( $spam_url ),
					'L_COMMENT_ACTIVE_LINK' => aurl( $active_url ),
					'S_COMMENT_DATE' => strftime( $config['time_format'], time_lokal( $row['comment_date'] ) ),
					'S_CSS_TABLE_ROW' => $css_table_row,
					'S_COMMENT_AUTHOR_NAME' => $plug->runfilter( 'filter_comment_author_name', $row['comment_author_name'] ),
					'S_COMMENT_TYPE' => $type,
					'S_COMMENT_STATUS' => $status,
					'S_COMMENT_AUTHOR_IP' => $row['comment_author_ip'],
				) );
			}
			$tpl->part_unite();
			
			$sql = "SELECT comment_id FROM " . TABLE_COMMENTS . " c";
			$sql .= $sql1;
			$res = $db->query( $sql, __LINE__, __FILE__ );
			$num = ceil ( $db->numrows( $res ) / 30 );
			$db->free( $res );
			$pages = '';
			$url = array();
			$url['site'] = 'comments';
			for( $i = 0; $i < $num; $i++ ){
				if( $i * 30 == $offset ) $pages .=  ( $i + 1 ) . ' ';
				else {
					$url['start'] = $i * 30 ;
					$pages .= '<a href="' . aurl( $url ) . '">' . ( $i + 1 ) . '</a> '; 
				}
			}
			
			$comment_filter = array();
			$comment_filter['active_yes'] = '<input type="radio" name="comment_filter_active" value="1" />';
			$comment_filter['active_no'] = '<input type="radio" name="comment_filter_active" value="0" />';
			$comment_filter['active_both'] = '<input type="radio" name="comment_filter_active" value="-1" />';
			
			if( $_SESSION['comment_filter_active'] == 1 ) $comment_filter['active_yes'] = '<input type="radio" name="comment_filter_active" value="1" checked="checked" />';
			else if ( $_SESSION['comment_filter_active'] == 0 ) $comment_filter['active_no'] = '<input type="radio" name="comment_filter_active" value="0" checked="checked" />';
			else $comment_filter['active_both'] = '<input type="radio" name="comment_filter_active" value="-1" checked="checked" />';
			
			$comment_filter['spam_yes'] = '<input type="radio" name="comment_filter_spam" value="1" />';
			$comment_filter['spam_no'] = '<input type="radio" name="comment_filter_spam" value="0" />';
			$comment_filter['spam_both'] = '<input type="radio" name="comment_filter_spam" value="-1" />';
			
			if( $_SESSION['comment_filter_spam'] == 1 ) $comment_filter['spam_yes'] = '<input type="radio" name="comment_filter_spam" value="1" checked="checked" />';
			else if ( $_SESSION['comment_filter_spam'] == 0 ) $comment_filter['spam_no'] = '<input type="radio" name="comment_filter_spam" value="0" checked="checked" />';
			else $comment_filter['spam_both'] = '<input type="radio" name="comment_filter_spam" value="-1" checked="checked" />';
			
			$comment_filter['name'] = '<input tpye="text" name="comment_filter_name" value="';
			if( !empty( $_SESSION['comment_filter_name'] ) ) $comment_filter['name'] .= $_SESSION['comment_filter_name'];
			$comment_filter['name'] .= '" />';
			
			$comment_filter['name'] = '<input tpye="text" name="comment_filter_name" value="';
			if( !empty( $_SESSION['comment_filter_name'] ) ) $comment_filter['name'] .= $_SESSION['comment_filter_name'];
			$comment_filter['name'] .= '" />';
			
			$comment_filter['ip'] = '<input tpye="text" name="comment_filter_ip" value="';
			if( !empty( $_SESSION['comment_filter_ip'] ) ) $comment_filter['ip'] .= $_SESSION['comment_filter_ip'];
			$comment_filter['ip'] .= '" />';
			
			$comment_filter['mail'] = '<input tpye="text" name="comment_filter_mail" value="';
			if( !empty( $_SESSION['comment_filter_mail'] ) ) $comment_filter['mail'] .= $_SESSION['comment_filter_mail'];
			$comment_filter['mail'] .= '" />';
			
			$tpl->fillin_array( array(
				'S_COMMENT_VIEW_TEXT' => $lang['view'],
				'S_COMMENT_EDIT_TEXT' => $lang['edit'],
				'S_COMMENT_DETAILS_TEXT' => $lang['details'],
				'S_COMMENT_DELETE_TEXT' => $lang['delete'],
				'I_COMMENT_DELETE_CONFIRM' => 'onclick="return confirm(\'' . $lang['admin_comment_delete_question'] . '\')""',
				'S_COMMENT_DATE_TEXT' => $lang['date'],
				'S_COMMENT_AUTHOR_NAME_TEXT' => $lang['author'],
				'S_COMMENT_STATUS_TEXT' => $lang['admin_comment_status'],
				'S_COMMENT_TYPE_TEXT' => $lang['admin_comment_type'],
				'S_COMMENT_AUTHOR_IP_TEXT' => $lang['admin_comment_author_ip'],
				'S_COMMENTS_PAGES' => $pages,
				'S_COMMENT_ACTIVE_TEXT' => $lang['admin_comment_deactivate'],
				'S_COMMENT_SPAM_TEXT' => $lang['admin_comment_spam_text'],
				'S_COMMENT_FILTER_TEXT' => $lang['admin_comment_filter'],
				'S_COMMENT_FILTER_ACTIVE' => $lang['admin_comment_filter_active'] . ':',
				'S_COMMENT_FILTER_ACTIVE_YES_TEXT' => $lang['admin_comment_filter_active_yes'],
				'S_COMMENT_FILTER_ACTIVE_NO_TEXT' => $lang['admin_comment_filter_active_no'],
				'S_COMMENT_FILTER_ACTIVE_BOTH_TEXT' => $lang['admin_comment_filter_active_both'],
				'I_COMMENT_FILTER_ACTIVE_YES' => $comment_filter['active_yes'],
				'I_COMMENT_FILTER_ACTIVE_NO' => $comment_filter['active_no'],
				'I_COMMENT_FILTER_ACTIVE_BOTH' => $comment_filter['active_both'],
				'S_COMMENT_FILTER_SPAM' => $lang['admin_comment_filter_spam'] . ':',
				'S_COMMENT_FILTER_SPAM_YES_TEXT' => $lang['admin_comment_filter_spam_yes'],
				'S_COMMENT_FILTER_SPAM_NO_TEXT' => $lang['admin_comment_filter_spam_no'],
				'S_COMMENT_FILTER_SPAM_BOTH_TEXT' => $lang['admin_comment_filter_spam_both'],
				'I_COMMENT_FILTER_SPAM_YES' => $comment_filter['spam_yes'],
				'I_COMMENT_FILTER_SPAM_NO' => $comment_filter['spam_no'],
				'I_COMMENT_FILTER_SPAM_BOTH' => $comment_filter['spam_both'],
				'I_COMMENT_FILTER_SUBMIT' => '<input type="submit" name="comment_filter" value="' . $lang['admin_comment_filter'] . '" />',
				'S_COMMENT_FILTER_MAIL' => $lang['mail'] . ':',
				'I_COMMENT_FILTER_MAIL' => $comment_filter['mail'],  
				'S_COMMENT_FILTER_NAME' => $lang['name'] . ':',
				'I_COMMENT_FILTER_NAME' => $comment_filter['name'],
				'S_COMMENT_FILTER_IP' => $lang['admin_comment_author_ip'] . ':',
				'I_COMMENT_FILTER_IP' => $comment_filter['ip'],
				'L_COMMENT_FILTER_ACTION' => aurl( array( 'site' => 'comments', 'action' => 'list' ) ),
			) );
			break;
	}
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}
?>
