<?php

/*
 * name		class.mysqlidb.php
 * begin	July 21, 2007
 * 
 * $Id: class.mysqlidb.php 99 2007-08-09 12:49:57Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class mysqlidb {
	
    protected $_dbhandle = 0;
    private $_querynum = 0;
    private $_author = 'Daniel Triendl';
    private $_version = '1.0.0';

    public function __construct( $dbhost, $dbuser, $dbpass, $dbname )
    {
        $this->_dbhandle = mysqli_connect( $dbhost, $dbuser, $dbpass );
        if ( $this->_dbhandle ) {
            $result = mysqli_select_db( $this->_dbhandle, $dbname );
            if ( $result == false ) {
                $this->raise_error( 'Can\'t select database (' . $dbname . ').', 'database', __LINE__ );
            } 
        } else {
            $this->raise_error( 'Can\'t open database connection. ', '__construct', __LINE__ );
        } 
    }

    public function query( $sql = '', $line=__LINE__, $file=__FILE__, $die = true )
    {
        $sql = trim( $sql );
        $result = mysqli_query( $this->_dbhandle, $sql );
        if ( $result == false && $die ) {
            $this->raise_error( mysqli_error( $this->_dbhandle ) . '<br /><b>Errno:</b> ' . 
				mysqli_errno( $this->_dbhandle ), 'query', $line, $file, $sql );
        } 

        $this->_querynum++;
        return $result;
    } 

    public function fetch( $result )
    {
        if ( is_object( $result ) ) {
            return mysqli_fetch_assoc( $result );
        } else {
            $this->raise_error( 'Got invalid ressource.', 'fetch', __LINE__ );
        } 
    }
    
    public function fetch_row( $result ) 
	{
        if ( is_object( $result ) ) {
            return mysqli_fetch_row( $result );
        } else {
            $this->raise_error( 'Got invalid ressource.', 'fetch_row', __LINE__ );
        } 
    }
    
    public function numrows( $result )
    {
        if ( is_object( $result ) ) {
            return mysqli_num_rows( $result );
        } else {
            $this->raise_error( 'Got invalid ressource.', 'numrows', __LINE__ );
        } 
    } 

    public function free( $result )
    {
        if ( is_object( $result ) ) {
            mysqli_free_result( $result );
        } else {
            $this->raise_error( 'Got invalid ressource.', 'free', __LINE__ );
        } 
    } 

    public function disconnect()
    {
        if ( $this->_dbhandle ) {
            mysqli_close( $this->_dbhandle );
            $this->_dbhandle = 0;
        } else {
            $this->raise_error( 'No MySQL connection active.', 'disconnect', __LINE__ );
        } 
    } 

    public function status( $element = false )
    {
        $return['file'] = __FILE__;
        $return['version'] = $this->_version;
        $return['author'] = $this->_author;
        $return['querynum'] = $this->_querynum;
        $return['error'] = mysqli_error( $this->_dbhandle );
        $return['errno'] = mysqli_errno( $this->_dbhandle );
        $return['database'] = 'mysql';
        if ( $this->_dbhandle ) {
            $return['active'] = 1;
        } else {
            $return['active'] = 0;
        } 

        if ( $element != false && isset( $return[$element] ) ) {
            return $return[$element];
        } else {
            return $return;
        } 
    } 

    protected function raise_error( $error = '', $function = '', $line = __LINE__, $file=__FILE__, $sql = '' )
    {
        $msg = '<h1>An error occured</h1>';
        $msg .= '<b>Error:</b> ' . $error . '<br />';
        $msg .= '<b>Function:</b> mysql::' . $function . '()<br />';
        $msg .= '<b>File:</b> ' . $file . '<br />';
        $msg .= '<b>Line:</b> ' . $line . '<br />';
        if ( !empty( $sql ) ) {
            $msg .= '<b>Query:</br><pre>' . $sql . '</pre><br />';
        } 
        die( $msg );
    }
    
    public function escape( $str )
    {
    	if ( $this->_dbhandle ){
    		if ( get_magic_quotes_gpc() ) {
          	  $str = stripslashes( $str );
        	}
        	return mysqli_real_escape_string( $this->_dbhandle, $str );
    	} else {
    		$this->raise_error( 'No MySQL connection active.', 'escape', __LINE__ );
    	}
    }
} 

?>