<?php
/*
 * name		entry_manage.php
 * begin	09.02.2007
 * 
 * $ID$
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if( $user->getRight('entry' ) ) {

	if ( isset( $_GET['action'] ) && $_GET['action'] == 'delete' ) {
		if ( isset( $_GET['entry_id'] ) && is_numeric( $_GET['entry_id'] ) ) {
			$sql = "SELECT
						entry_id
					FROM
						" . TABLE_BLOG . "
					WHERE
						entry_id = '" . $db->escape( $_GET['entry_id'] ) . "'";
			if( !$user->getRight('entry_other' ) ) $sql .= " and user_id = '" . $user->getuser_id() . "'";
			$sql .= "
					LIMIT
						0, 1;";
			$res = $db->query( $sql, __LINE__, __FILE__ );
			if ( $db->numrows( $res ) ) {
				$entry = $db->fetch( $res );
				$db->free( $res );
				if ( isset( $_GET['yabsonce'] ) && $_GET['yabsonce'] == $user->getOnce() ) {
					$sql = "DELETE FROM " . TABLE_BLOG ." WHERE entry_id = '" . $db->escape( $_GET['entry_id']) . "';";
					$db->query( $sql, __LINE__, __FILE__ );
					$sql  = "DELETE FROM " . TABLE_COMMENTS ." WHERE entry_id = '" . $db->escape( $_GET['entry_id'] ) . "';";
					$db->query( $sql, __LINE__, __FILE__ );
					$continue_url = array();
					if( isset( $_GET['call'] ) && isset( $sites[$_GET['call']] ) ) {
						$continue_url['site'] = $_GET['call'];
					} else {
						$continue_url['site'] = 'entry_manage';
						$offset = ( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) && $_GET['start'] >= 0 ) ? $_GET['start'] : 0;
						$continue_url['start'] = $offset;
					}
					
					$plug->runhook( 'hook_admin_entry_manage_deleted' );
					header('Location: ' . aurl( $continue_url, false ) );
					die( '<a href="' . aurl( $continue_url ) . '">' . $lang['continue'] . '</a>' );
				} else {
					$tpl->add( 'empty.tpl' );
					$tpl->fillin( 'S_CONTENT', $lang['admin_error_invalid_link'] . $lang['back'] );
				}
			} else {
				$db->free( $res );
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['error_entry_notfound'] . $lang['back'] );	
			}
		} else {
			$tpl->add( 'empty.tpl' );
			$tpl->fillin( 'S_CONTENT', $lang['error_entry_notfound'] . $lang['back'] );
		}
	} else {
		$offset = ( isset( $_GET['start'] ) && is_numeric( $_GET['start'] ) && $_GET['start'] >= 0 ) ? $_GET['start'] : 0;
		$sql = "SELECT
					e.entry_id,
					e.entry_title,
					e.entry_content,
					e.entry_extended,
					e.entry_date,
					u.user_id,
					u.user_name,
					l.link_id,
					l.link_name
				FROM
					" . TABLE_BLOG . " e
				LEFT JOIN
					" . TABLE_LINKS . " l
				ON	(
					 l.link_id = e.link_id and
					 l.link_url = ''
					)
				LEFT JOIN
					" . TABLE_USER ." u
				ON
					u.user_id = e.user_id
				WHERE
					e.entry_hidden = '0'";
		if( !$user->getRight('entry_other' ) ) $sql .= " and e.user_id = '" . $user->getuser_id() . "'";
		$sql .= "
				ORDER BY
					e.entry_date DESC
				LIMIT
					" . $db->escape( $offset ) . ", 30;";
		$res = $db->query( $sql, __LINE__, __FILE__ );
		$tpl->add( 'entry_manage.tpl' );
		$tpl->part_seperate( 'E_MANAGE' );
		if ( $db->numrows( $res ) ) {
			$i = 0;
			while ( $entry = $db->fetch( $res ) ) {
				$tpl->part_load();
				if ( $i == 0 ) {
					$css_table_row = 'yabs_table_row_dark';
					$i = 1;
				} else {
					$css_table_row =  'yabs_table_row_light';
					$i = 0;
				}
				$edit_url = array( 'site' => 'write', 'entry_id' => $entry['entry_id'] );
				$delete_url = array( 
					'site' => 'entry_manage',
					'action' => 'delete', 
					'entry_id' => $entry['entry_id'],
					'yabsonce' => $user->getOnce(),
					'start' => $offset,
				);
				$view_url = array( 'site' => 'blog', 'blog' => urlencode( $entry['entry_title'] ));
				
				if ( empty( $entry['entry_title'] ) ) {
					if ( empty( $entry['entry_content'] ) ) {
						if ( empty( $entry['entry_extended'] ) ) {
							$title = $lang['admin_write_notitle'];
						} else {
							$title = substr( html2txt( $entry['entry_extended'] ), 0, 20 );
						}
					} else {
						$title = substr( html2txt( $entry['entry_content'] ), 0, 50 );
					}
				} else {
					$title = substr( html2txt( $entry['entry_title'] ), 0, 50 );
				}
				
				$plug->runhook( 'hook_admin_entry_manage_list_fillin', $entry['entry_id'] );
				
				$tpl->fillin_array( array(
					'S_ENTRY_USER_NAME' => $entry['user_name'],
					'S_ENTRY_CATEGORY_NAME' => $entry['link_name'],
					'S_ENTRY_DATE' => strftime( $config['time_format'], time_lokal( $entry['entry_date'] ) ),
					'S_CSS_TABLE_ROW' => $css_table_row,
					'S_ENTRY_TITLE' => $title,
					'S_ENTRY_ID' => $entry['entry_id'],
					'L_ENTRY_EDIT_LINK' => aurl( $edit_url ),
					'L_ENTRY_DELETE_LINK' => aurl( $delete_url ),
					'L_ENTRY_VIEW_LINK' => url( $view_url ),
				) );
			}	
		}
		$tpl->part_unite();
		
		$sql = "SELECT entry_id FROM " . TABLE_BLOG ." WHERE entry_hidden = 0";
		if( !$user->getRight('entry_other' ) ) $sql .= " and user_id = '" . $user->getuser_id() . "'";
		$res = $db->query( $sql, __LINE__, __FILE__ );
		$num = ceil ( $db->numrows( $res ) / 30 );
		$db->free( $res );
		$pages = '';
		for( $i = 0; $i < $num; $i++ ){
			if( $i * 30 == $offset ) $pages .=  ( $i + 1 ) . ' ';
			else $pages .= '<a href="' . aurl( array( 'site' => 'entry_manage', 'start' => $i * 30 ) ) . '">' . ( $i + 1 ) . '</a> '; 
		}	
		
		$tpl->fillin_array( array(
			'I_ENTRY_DELETE_CONFIRM' => 'onclick="return confirm(\'' . $lang['admin_entry_delete_question'] . '\')""',
			'S_ENTRY_DELETE_TEXT' => $lang['delete'],
			'S_ENTRY_EDIT_TEXT' => $lang['edit'],
			'S_ENTRY_VIEW_TEXT' => $lang['view'], 
			'S_ENTRY_DATE_TEXT' => $lang['date'],
			'S_ENTRY_ID_TEXT' => $lang['id'],
			'S_ENTRY_USER_NAME_TEXT' => $lang['author'],
			'S_ENTRY_TITLE_TEXT' => $lang['title'],
			'S_ENTRY_CATEGORY_NAME_TEXT' => $lang['category'],
			'S_ENTRY_PAGES' => $pages,
		) );
	}
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}

?>
