<?php

/*
 * name		admin.php
 * begin	May 21, 2005
 * 
 * $Id: admin.php 104 2007-08-21 14:32:59Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

define('INSIDE', true);

require_once( './includes/init.php' );

$plug->runhook( 'hook_admin_index_init' );

$tpl = new template( './templates/admin' );
$tpl->add( 'header.tpl' );

$user = user::singleton();

if ( isset( $_GET['action'] ) && $_GET['action'] == 'logout' ) {
	$plug->runhook( 'hook_admin_index_logout' );
	$user->logout();
}

if ( $user->is_login() ) {
	$admincategories = array(
		'general',
		'entries',
		'feedback',
		'blog',
	);
	$plug->addadminsite( 'general', 'dashboard', './admin/dashboard.php', $lang['admin_menu_dashboard'], 200 );
	
	$plug->addadminsite( 'entries', 'write', './admin/write.php', $lang['admin_menu_write'], 200 );
	$plug->addadminsite( 'entries', 'entry_manage', './admin/entry_manage.php', $lang['admin_menu_entry_manage'], 190 );
	
	$plug->addadminsite( 'feedback', 'comments', './admin/comments.php', $lang['admin_menu_comments'], 200 );
	
	$plug->addadminsite( 'blog', 'settings', './admin/settings.php',  $lang['admin_menu_settings'], 200 );
	$plug->addadminsite( 'blog', 'template', './admin/template.php',  $lang['admin_menu_template'], 190 );
	$plug->addadminsite( 'blog', 'user', './admin/user.php', $lang['admin_menu_user'], 180 );
	$plug->addadminsite( 'blog', 'menu', './admin/menu.php',  $lang['admin_menu_menu'], 170 );
	$plug->addadminsite( 'blog', 'links', './admin/links.php',  $lang['admin_menu_links'], 160 );
	$plug->addadminsite( 'blog', 'plugins', './admin/plugins.php', $lang['admin_menu_plugins'], 150 );
	
	$tpl->part_seperate( 'E_MENU' );
	foreach( $admincategories as $cat ) {
		$sites = $plug->getadmincategory( $cat );
		$tpl->part_load( 1 );
		$tpl->fillin( 'S_MENU_CATEGORY', $lang['admin_category_' . $cat] );
		foreach( $sites as $site ) {
			$tpl->part_load( 2 );
			if ( !empty( $site['text'] ) ) {
				$tpl->fillin_array( array(
					'S_MENU_TEXT' => $site['text'],
					'L_MENU_LINK' => aurl( array( 'site' => $site['link'] ) ),
				) );
				if ( isset( $_GET['site']) && $_GET['site'] == $site['link'] ) {
					$tpl->fillin( 'S_MENU_SELECTED', 'class="yabs_menu_selected"' );
				} elseif ( !isset ($_GET['site'] ) && $site['link'] == 'dashboard' ) {
					$tpl->fillin( 'S_MENU_SELECTED', 'class="yabs_menu_selected"' );
				}else {
					$tpl->fillin( 'S_MENU_SELECTED', 'class="yabs_menu_notselected"' );
				}
			}
		}
	}
	
	$tpl->part_unite();
	$sites = $plug->getadminsites();
	$plug->runhook( 'hook_admin_index_site_load' );
	if	( isset( $_GET['site'] ) && isset( $sites[$_GET['site']] ) ) {
		include( $sites[$_GET['site']] );
	} else {
		include( $sites['dashboard'] );
	}
} else {
	$tpl->part_seperate( 'E_MENU' );
	$tpl->part_unite();
	if( isset( $_GET['action'] ) && $_GET['action'] == 'login' ) {
		if( !isset( $_POST['user_name'] ) ) $_POST['user_name'] = '';
		if( !isset( $_POST['user_pass'] ) ) $_POST['user_pass'] = '';
		
		$remember = ( isset( $_POST['user_remember'] ) && $_POST['user_remember'] == 'true' ) ? true : false;
		
		if ( $user->login( $_POST['user_name'], $_POST['user_pass'], $remember ) ) {
			$url = array();
			$plug->runhook( 'hook_admin_index_login_success' );
			header('Location:' . aurl( $url, false ) );
			die( '<a href="' . aurl( $url ) . '">' . $lang['continue'] . '</a>' );
		}else {
			$tpl->add( 'empty.tpl' );
			$plug->runhook( 'hook_admin_index_login_failed' );
			$tpl->fillin( 'S_CONTENT', $lang['admin_login_failed'] );
		}
	}
	$tpl->add( 'login.tpl' );
	$plug->runhook( 'hook_admin_index_login_form' );
	$tpl->fillin_array( array( 
		'L_ACTION' => aurl( array( 'action' => 'login' ) ),
		'S_LOGIN_TITLE' => $lang['admin_login_title'],
		'S_LOGIN_FORM_NAME_TEXT' => $lang['name'],
		'S_LOGIN_FORM_NAME_INPUT' => '<input type="text" name="user_name" />',
		'S_LOGIN_FORM_PASS_TEXT' => $lang['password'],
		'S_LOGIN_FORM_PASS_INPUT' => '<input type="password" name="user_pass" />',
		'S_LOGIN_FORM_REMEMBER_TEXT' => $lang['login_remember'],
		'S_LOGIN_FORM_REMEMBER_INPUT' => '<input type="checkbox" name="user_remember" value="true" />',
		'S_LOGIN_FORM_LOGIN_INPUT' => '<input type="submit" name="login" value="' . $lang['login'] . '" />'
	) );
}

// Add footer
$tpl->add( 'footer.tpl' );
	
$tpl->fillin_array( array(
	'S_HOME' => url(),
	'S_TRUE_HOME' => site_true_home(),
	'S_HEADERS' => yabs_headers(),
	'S_BLOG_TITLE' => $config['blog_title'],
	'S_CHARSET' => $lang['charset'],
) );

// Header
if( !headers_sent() ) {
	//header('X-Blog: yabs '.$yabs->get_version());
	header( 'Cache-control: private, pre-check=0, post-check=0, max-age=0' );
	header( 'Pragma: no-cache' );
	header( 'Expires: 0' );
	header( 'Content-Type: text/html; charset=' . $lang['charset'] );
}

$tpl->output();

?>