<?php

/*
 * name		template.php
 * begin	July 23, 2007
 * 
 * $Id: template.php 103 2007-08-21 02:10:36Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

$kubrick = array();
$kubrick['wide'] = false;
	
$plug->addhook( 'hook_blog_single_entry', 'kubrick_setwide' );
$plug->addhook( 'hook_blog_comment_single', 'kubrick_commentclass' );
$plug->addhook( 'hook_blog_trackback_single', 'kubrick_trackbackclass' );
$plug->addhook( 'hook_index_preoutput', 'kubrick_fillin' );
	
function kubrick_setwide()
{
	global $kubrick;
	$kubrick['wide'] = true;
}

function kubrick_commentclass()
{
	static $count = 0;
	global $tpl;
	
	if( $count == 0 ) {
		$tpl->fillin( 'KUBRICK_COMMENT_CLASS', 'alt' );
		$count = 1;
	} else {
		$tpl->fillin( 'KUBRICK_COMMENT_CLASS', '' );
		$count = 0;
	}
}

function kubrick_trackbackclass()
{
	static $count = 0;
	global $tpl;
	
	if( $count == 0 ) {
		$tpl->fillin( 'KUBRICK_COMMENT_CLASS', 'alt' );
		$count = 1;
	} else {
		$tpl->fillin( 'KUBRICK_COMMENT_CLASS', '' );
		$count = 0;
	}
}

function kubrick_fillin()
{
	global $kubrick, $tpl, $lang;
	
	if( $kubrick['wide'] ) {
		$tpl->fillin( 'KUBRICK_CONTENT_CLASS', 'widecolumn' );
		$tpl->fillin( 'KUBRICK_HIDE_SIDEBAR', 'style="display: none;"' );
		yabs_headers( '<style type="text/css" media="screen">

	#page { background: url("' . url() . '/templates/kubrick/images/kubrickbgwide.jpg") repeat-y top; border: none; } 


</style>');
	} else {
		$tpl->fillin( 'KUBRICK_CONTENT_CLASS', 'narrowcolumn' );
		$tpl->fillin( 'KUBRICK_HIDE_SIDEBAR', '' );
		yabs_headers( '<style type="text/css" media="screen">

	#page { background: url("' . url() . '/templates/kubrick/images/kubrickbg.jpg") repeat-y top; border: none; }

</style>' );
	}
	
	$tpl->fillin( 'KUBRICK_MENU_TITLE', $lang['admin_menu_menu'] );
}
?>