<?php

/*
 * name		init.php
 * begin	April 23, 2007
 * 
 * $Id: init.php 103 2007-08-21 02:10:36Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

error_reporting( E_ALL );
$rendertime_start = array_sum(explode(" ", microtime()));

$yabs_version = '0.8.0beta4';

if( file_exists( './install' ) ) {
	//die( 'Remove install/ if you already installen or updates yabs, or run <a href="http://' . $_SERVER['HTTP_HOST'] . dirname( $_SERVER['PHP_SELF'] ) . '/install/install.php">install/install.php</a> to do so.' );
}
// Load basic stuff	
require_once( './includes/config.php' );
if ( !defined( 'DEBUG' ) ) {
	error_reporting( E_ALL );
} else {
	error_reporting( E_ALL );
}

require_once( './includes/sites.php' );
require_once( './includes/tables.php' );

require_once( './includes/autoload.php' );

$plug = plugin::singleton();
include_once( './includes/plugins.php' );
require_once( './includes/functions.php' );
	
//Start a connection to the mysql server
$db = new $dbtype( $dbhost, $dbuser, $dbpass, $dbname );
	
// Load the Config from the Server
$sql = "SELECT
			config_name,
			config_value
		FROM
			" . TABLE_CONFIG . ";";
$res = $db->query( $sql, __LINE__, __FILE__ );
$config = array();
while ( $row = $db->fetch( $res ) ) {
	$config[$row['config_name']] = $row['config_value'];
}

if( version_compare( $config['version'], $yabs_version ) == -1 ) die( 'Database version is lower then file version, run <a href="http://' . $_SERVER['HTTP_HOST'] . dirname( $_SERVER['PHP_SELF'] ) . '/install/install.php">install/install.php</a> to update the database.' );

if( $config['mod_rewrite'] == '1' && basename( $_SERVER['PHP_SELF'] ) != 'admin.php' ) {
	make_get();
}

//Ok, now we know the language, so load the language file
require_once('./languages/'.$config['language'].'.php');

eval( $plug->registerPlugins() );

?>
