<?php
/*
 * name		class.user.php
 * begin	February 6, 2007
 * 
 * User session handling
 * Based on http://www.mtdev.com/2002/07/creating-a-secure-php-login-script/
 * 
 * $Id: class.user.php 99 2007-08-09 12:49:57Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

class user{
	
	private $_userdata = array( 'user_id' => false, 'once' => 0 );
	private $_userrights = false;
	private $_userconfig = false;
	private static $instance;
	
	private function __construct()
	{
		session_start();
		
		if ( isset( $_SESSION['user_id'] ) ) {
			$this->checksession();
		} elseif( isset( $_COOKIE['yabs_login'] ) ) {
			$this->checkcookie( $_COOKIE['yabs_login'] );
		}
	}
	
	public static function singleton()
	{
		if ( !isset( self::$instance ) ) {
			$user = __CLASS__;
			self::$instance = new $user;
		}
		
		return self::$instance;
	}
	
	public function __clone()
	{
		trigger_error( 'Can\'t clone class ' . __CLASS__ . '.', E_USER_ERROR );
	}
	
	public function is_login()
	{
		if ( $this->_userdata['user_id'] !== false ) {
			return true;
		} else {
			return false;
		}
	}
	
	public function getuser_id()
	{
		if ( $this->_userdata['user_id'] !== false ) {
			return $this->_userdata['user_id'];
		} else {
			return false;
		}
	}
	
	public function getOnce()
	{
		return $this->_userdata['once'];
	}
	
	private function checksession()
	{
		global $db;
		global $dbprefix;
		
		$sql = "SELECT
					user_id,
					user_name,
					user_cookie
				FROM
					" . TABLE_USER ."
				WHERE
					user_id = '" . $db->escape( $_SESSION['user_id'] ) . "' and
					user_session = '" . $db->escape( session_id() ) . "' and
					user_ip = '" . $db->escape( $_SERVER['REMOTE_ADDR'] ) . "'
				LIMIT
					0, 1";
		$res = $db->query( $sql, __LINE__, __FILE__ );
		if ( $db->numrows( $res ) ) {
			$this->setsession( $db->fetch( $res ), false, false );
		} else {
			$this->logout();
		}
		$db->free( $res ); 
	}
	
	private function setsession( $data, $remember, $init )
	{
		$_SESSION['user_id'] = $data['user_id'];
		$this->_userdata = $data;
		if ( isset( $_SESSION['once'] ) && strlen( $_SESSION['once']) == 8 ) {
			$this->_userdata['once'] = $_SESSION['once'];
		} else {
			$once = substr( md5( microtime() ), 0, 8 );
			$_SESSION['once'] = $once;
			$this->_userdata['once'] = $once;
		}
		
		if ( $remember ) {
			setcookie( 'yabs_login', urlencode( serialize( array( $data['user_name'], $data['user_cookie'] ) ) ), ( time() + 3600 * 24 * 365 ), dirname( $_SERVER['PHP_SELF'] ) );
		}
		
		if ( $init ) {
			global $db;
			global $dbprefix;
			
			$sql = "UPDATE
						" . TABLE_USER ."
					SET
						user_session = '" . $db->escape( session_id() ) . "',
						user_ip = '" . $db->escape( $_SERVER['REMOTE_ADDR'] ) . "'
					WHERE
						user_id = '" . $data['user_id'] . "';";
			$db->query( $sql, __LINE__, __FILE__ );
		}
	}
	
	private function checkcookie( $cookie )
	{
		list( $name, $cookie ) = @unserialize( urldecode( $cookie ) );
		if ( !$name or !$cookie ) {
			setcookie( 'yabs_login', '', 0, dirname( $_SERVER['PHP_SELF'] ) );
			return;	
		}
		
		global $db;
		global $dbprefix;
		
		$sql = "SELECT
					user_id,
					user_name,
					user_cookie
				FROM
					" . TABLE_USER ."
				WHERE
					user_name = '" . $db->escape( $name ) . "' and
					user_cookie = '" . $db->escape( $cookie ) . "'
				LIMIT
					0, 1;";
		$res = $db->query( $sql );
		if ( $db->numrows( $res ) ) {
			$this->setsession( $db->fetch( $res ), true, true );
		} else {
			setcookie( 'yabs_login', '', 0, dirname( $_SERVER['PHP_SELF'] ) );
		}
		$db->free( $res );
	}
	
	public function login( $name, $pass, $remember )
	{
		global $db;
		global $dbprefix;
		
		$sql = "SELECT
					user_id,
					user_name,
					user_cookie
				FROM
					" . TABLE_USER ."
				WHERE
					user_name = '" . $db->escape( $name ) . "' and
					user_password = '" . $db->escape( md5( $pass ) ) . "'
				LIMIT
					0, 1;";
		$res = $db->query( $sql );
		if ( $db->numrows( $res ) ) {
			$row = $db->fetch( $res );
			$db->free( $res );
			$this->setsession( $row, $remember, true );
			return true;
		} else {
			$db->free( $res );
			return false;
		}
	}
	
	public function logout()
	{
		session_destroy();
		if ( isset( $_COOKIE['yabs_login'] ) ) {
			setcookie( 'yabs_login', '', 0, dirname( $_SERVER['PHP_SELF'] ) );
		}
		header('location: ' . url() );
		die( 'Was unable to autoredirect.<br /><a href="' . url() . '">Continue</a>' );
	}
	
	public function getRight( $right )
	{	
		if( !is_array( $this->_userrights ) ) {
			global $db;
			$sql = "SELECT user_config_name FROM " . TABLE_USER_CONFIG . " WHERE user_id = '" . $db->escape( $this->_userdata['user_id'] ) . "' and user_permission = '1';";
			$res = $db->query( $sql );
			$this->_userrights = array();
			while( $row = $db->fetch( $res ) ) {
				$this->_userrights[] = $row['user_config_name'];
			}
			$db->free( $res );
		}
		if ( in_array( $right, $this->_userrights ) ) {
			return true;
		} else {
			return false;	
		}
	}
	
	public function getConfig( $uconfig )
	{
		if( !is_array( $this->_userconfig ) ) {
			global $db;
			$sql = "SELECT user_config_name, user_config_value FROM " . TABLE_USER_CONFIG . " WHERE user_id = '" . $db->escape( $this->_userdata['user_id'] ) . "';";
			$res = $db->query( $sql );
			$this->_userconfig = array();
			while( $row = $db->fetch( $res ) ) {
				$this->_userconfig[$row['user_config_name']] = $row['user_config_value'];
			}
			$db->free( $res );
		}
		if( isset( $this->_userconfig[$uconfig] ) ) {
			return $this->_userconfig[$uconfig];
		} else {
			return false;
		}
	}
	
}

?>