<?php
/*
 * name		write.php
 * begin	February 07, 2007
 * 
 * $Id: write.php 103 2007-08-21 02:10:36Z daniel $
 */

/*
 * yabs - yet another blog system
 * Copyright (C) 2007 Daniel Triendl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA
 *
 * http://www.gnu.org/copyleft/gpl.html
 */
 
if ( !defined('INSIDE') ) die( 'Don\'t call this file directly.' );

if( $user->getRight('entry' ) ) {

	if ( isset( $_GET['action'] ) && $_GET['action'] == 'trackback' ) {
	
		//
		// Trackback Area
		//
		if( isset( $_GET['entry_id']) && is_numeric( $_GET['entry_id'] ) ) {
			$sql = "SELECT
						entry_id,
						entry_title,
						entry_content,
						entry_extended
					FROM
						" . TABLE_BLOG ."
					WHERE
						entry_id = '" . $db->escape( $_GET['entry_id'] ) . "'";
		if( !$user->getRight('entry_other' ) ) $sql .= " and user_id = '" . $user->getuser_id() . "'";
			$sql .=	"
					LIMIT
						0, 1;";
			$res = $db->query( $sql, __LINE__, __FILE__ );
			if	( $db->numrows( $res ) ) {
				$entry = $db->fetch( $res );
				$db->free( $res );
				
				if ( isset( $_POST['trackback_send'] ) ) {
					
					//
					// Sending trackbacks
					//
					$tb = array();
					if( !empty( $_POST['trackback_uris'] ) ) {
						foreach ( $_POST['trackback_uris'] as $tb_uri ) {
							if ( !empty( $tb_uri ) ) {
								$tb[] = urldecode( trim( $tb_uri ) );
							}
						}
					}
					if( !empty( $_POST['trackback_additional'] ) ) {
						$tb_as = explode( "\n", $_POST['trackback_additional']);
						foreach ( $tb_as as $tb_a ) {
							if ( !empty( $tb_a ) ) {
								$tb[] = trim( $tb_a );
							}
						}
					}
					
					$echo = '<ul>';
							
					$trackback = new trackback();
					foreach ($tb as $url ) {
						$tb_short = ( strlen( $url ) > 60 ) ? substr( $url, 0, 40 ) . '...' . substr( $url, strlen( $url ) - 15, 15 ) : $url;
						$echo .= '<li>' . $tb_short . '<br />';

						if ( preg_match( '/^(http|https):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,6}((:[0-9]{1,5})?\/.*)?$/i', $url ) ) {
							
							if ( empty( $entry['entry_title'] ) ) {
								if ( empty( $entry['entry_content'] ) ) {
									if ( empty( $entry['entry_extended'] ) ) {
										$title = '';
									} else {
										$title = $entry['entry_extended'];
									}
								} else {
									$title = $entry['entry_content'];
								}
							} else {
								$title = $entry['entry_title'];
							}
							
							if ( empty( $entry['entry_content'] ) ) {
								if ( empty( $entry['entry_extended'] ) ) {
									$excerpt = '';
								} else {
									$excerpt = $entry['entry_extended'];
								}
							} else {
								$excerpt = $entry['entry_content'];
							}
							
							$return = $trackback->sendTrackback( $url, url( array( 'site' => 'blog', 'blog' => urlencode( $entry['entry_title'] ) ) ),  $plug->runfilter( 'filter_trackback_send_blog_title', $config['blog_title'] ), $plug->runfilter( 'filter_trackback_send_title', $title ), $plug->runfilter( 'filter_trackback_send_excerpt', $excerpt ) );
							
							switch ( $return ) {
								case '0':
									$echo .=  '<span class="yabs_text_true">' . $lang['admin_trackback_succes'] . '</span>';
									break;
								case '1':
									$echo .=  '<span class="yabs_text_false">' . $lang['admin_trackback_failed'] . '</span> ' . $lang['admin_trackback_error_connection'];
									break;
								case '2':
									$echo .=  '<span class="yabs_text_false">' . $lang['admin_trackback_failed'] . '</span> ' . $lang['admin_trackback_error_invalid_answer'];
									break;
								case '3':
									$echo .=  '<span class="yabs_text_false">' . $lang['admin_trackback_failed'] . '</span> ' . $lang['admin_trackback_error_no_errormessage'];
									break;
								default:
									$echo .=  '<span class="yabs_text_false">' . $lang['admin_trackback_failed'] . '</span> ' . html2txt( $return );
									break;
							}
						} else {
							$echo .=  '<span class="yabs_text_false">' . $lang['admin_trackback_failed'] . '</span> ' . $lang['admin_trackback_error_invalid_uri'];
						}
						
						$plug->runhook( 'hook_admin_trackback_sent', $url );
						
						$echo .= '</li>';
					}
					$echo .= '</ul>';
					$echo .= '<a href="' . aurl( array( 'site' => 'entry_manage' ) ) . '">' . $lang['continue'] . '</a>';
					$tpl->add( 'empty.tpl' );
					$plug->runhook( 'hook_admin_trackback_sent_fillin' );
					$tpl->fillin( 'S_CONTENT', $echo );
				} else {
					
					//
					// Gather trackback urls
					//
					$tpl->add( 'trackback.tpl' );
					$tpl->part_seperate( 'E_TRACKBACKS' );
					if ( preg_match_all( "/a[\s]+[^>]*?href[\s]?=[\s\"\']+(.*?)[\"\']+.*?>([^<]+|.*?)?<\/a>/", ' ' . $entry['entry_content'] . ' ' . $entry['entry_extended'] . ' ', $match ) ) {
						$match[1] = array_unique($match[1]);
						$socket = new socket();
						$i = 0;
						foreach ( $match[1] as $tb ) {
							$tpl->part_load();
							if ( $i == 0 ) {
								$css_table_row = 'yabs_table_row_dark';
								$i = 1;
							} else {
								$css_table_row = 'yabs_table_row_light';
								$i = 0;
							}
							$tb = trim( $tb );
							$target = parse_url( $tb );
							if ( empty( $target['query'] ) ) {
								$target['query'] = '';
							} else {
								$target['query'] = '?' . $target['query'];
							}
							$taget['path'] = ( !empty( $target['path'] ) ) ? $target['path'] : '/';
	
							$tb_found = false;
							$trackback_select = '';
							if ( isset( $target['host'] ) && $socket->connect( $target['host'] ) ) {
								$socket->write( 'GET ' . $taget['path'] . $target['query'] . ' HTTP/1.1' . "\r\n" );
								$socket->write( 'Host:' . $target['host'] . "\r\n" );
								$socket->write( 'User-Agent: MoveableType (yabs)' . "\r\n" );
								$socket->write( 'Connection: Close' . "\r\n\r\n");
								
								$plug->runhook( 'hook_admin_write_trackback_autodedect_send', $tb );
								
								$data = $socket->read( 20 );
								
								$socket->disconnect();
	
								if ( preg_match( '@dc:identifier\s*=\s*["\'](http:[^"\']+)"@i', $data, $tb_id ) ) {
									$tb_id = trim( $tb_id[1] );
									if( preg_match( '@trackback:ping\s*=\s*["\'](http:[^"\']+)"@i', $data, $tb_uri ) ) {
										$tb_uri = trim( $tb_uri[1] );
										if ( $tb_id == $tb ) {
											$trackback_found = '<span class="yabs_text_true">' . $lang['yes'] . '</span>';
											$trackback_select = '<input type="checkbox" name="trackback_uris[]" value="' . urlencode( $tb_uri ) . '" checked="checked">';
										} else {
											$trackback_found = $lang['admin_trackback_error_id_missmatch'];
										}
									} else {
										$trackback_found = $lang['admin_trackback_error_uri_notfound'];
									}
								} else {
									$trackback_found = $lang['admin_trackback_error_id_notfound'];
								}
							} else {
								$trackback_found = $lang['admin_trackback_error_connection'];
							}
							$tb_short = ( strlen( $tb ) > 40 ) ? substr( $tb, 0, 20 ) . '...' . substr( $tb, strlen( $tb ) - 15, 15 ) : $tb;
							
							$plug->runhook( 'hook_admin_write_trackback_autodetect_fillin', $tb );
							
							$tpl->fillin_array( array(
								'S_FOUND_URI' => $tb_short,
								'L_FOUND_URI' => $tb,
								'I_TRACKBACK_SELECT' => $trackback_select,
								'S_TRACKBACK_FOUND' => $trackback_found,
								'S_CSS_TABLE_ROW' => $css_table_row,
							) );
	 					}	
					}
					$tpl->part_unite();
					$action_url = array( 'site' => 'write', 'action' => 'trackback', 'entry_id' => $entry['entry_id'] );
					
					$plug->runhook( 'hook_admin_write_trackback_autodetect_general_fillin' );
					
					$tpl->fillin_array( array(
						'S_TRACKBACK_SELECT_TEXT' => $lang['admin_trackback_select'],
						'S_TRACKBACK_FOUND_TEXT' => $lang['admin_trackback_found'],
						'S_FOUND_URI_TEXT' => $lang['admin_trackback_uri'],
						'S_TRACKBACK_ADDITIONAL' => $lang['admin_trackback_additional'],
						'I_TRACKBACK_ADDITIONAL' => '<textarea name="trackback_additional" cols="40", rows="5"></textarea>',
						'I_TRACKBACK_SEND' => '<input type="submit" name="trackback_send" value="' . $lang['send'] . '" />',
						'L_TRACKBACK_ACTION' => aurl( $action_url ),
						'S_TRACKBACK_FINISHED' => '<a href="' . aurl( array( 'site' => 'entry_manage' ) ) . '">' . $lang['finished'] . '</a>',
					) );
				}
			} else {
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['error_entry_notfound'] . $lang['back'] );
			}
		} else {
			$tpl->add( 'empty.tpl' );
			$tpl->fillin( 'S_CONTENT', $lang['error_entry_notfound'] . $lang['back'] );
		}
	} else {
		
		//
		// Edit area
		//
		$entry = array();
		$entry['entry_id'] = ( isset( $_GET['entry_id'] ) && is_numeric( $_GET['entry_id'] ) && !isset( $_POST['entry_new'] ) ) ? $_GET['entry_id'] : -1;
		$entry['entry_title'] = '';
		$entry['entry_content'] = '';
		$entry['entry_extended'] = '';
		$entry['entry_date'] = time_utc();
		$entry['link_id'] = 1; 
		$entry['entry_hidden'] = 1;
		$entry_error =array();
		
		$plug->runhook( 'hook_admin_write_edit_start' );
		
		// Check if we got a valid id
		$sql = "SELECT
					entry_id
				FROM
					" . TABLE_BLOG ."
				WHERE
					entry_id = '" . $db->escape( $entry['entry_id'] ) . "'";
		if( !$user->getRight('entry_other' ) ) $sql .= " and user_id = '" . $user->getuser_id() . "'";
		$sql .= "
				LIMIT
					0, 1;";
		$res = $db->query( $sql, __LINE__, __FILE__ );
		if ( !$db->numrows( $res ) ) $entry['entry_id'] = -1;
		$db->free( $res );
		
		//
		// Save draft / publish
		//
		if ( isset( $_POST['entry_save'] ) || isset( $_POST['entry_publish'] ) ) {
			$entry['entry_hidden'] = ( isset( $_POST['entry_save'] ) ) ? 1 : 0;
			if ( isset( $_POST['entry_hidden'] ) && $_POST['entry_hidden'] == 0 ) $entry['entry_hidden'] = 0;
			$entry['entry_title'] = ( !empty( $_POST['entry_title'] ) ) ? $_POST['entry_title'] : '';
			if( !empty( $entry['entry_title'] ) ) {
				$title_sql = "SELECT entry_id FROM " . TABLE_BLOG . " WHERE entry_title = '" . $db->escape( $entry['entry_title'] ) . "'";
				if( $entry['entry_id'] != -1 ) $title_sql .= " and entry_id != '" . $db->escape( $entry['entry_id'] ) . "';";
				$title_res = $db->query( $title_sql );
				if( $db->numrows( $title_res ) ) $entry_error['entry_title'] = $lang['admin_error_write_title'];
				$db->free( $title_res );
			} else {
				$entry_error['entry_title'] = $lang['admin_error_write_title'];
			}
			$entry['entry_content'] = ( !empty( $_POST['entry_content'] ) ) ? $_POST['entry_content'] : '';
			$entry['entry_extended'] = ( !empty( $_POST['entry_extended'] ) ) ? $_POST['entry_extended'] : '';
			if(
				isset( $_POST['entry_date_month'] ) && is_numeric( $_POST['entry_date_month'] ) &&
				isset( $_POST['entry_date_day'] ) && is_numeric( $_POST['entry_date_day'] ) &&
				isset( $_POST['entry_date_year'] ) && is_numeric( $_POST['entry_date_year'] ) &&
				isset( $_POST['entry_date_hour'] ) && is_numeric( $_POST['entry_date_hour'] ) &&
				isset( $_POST['entry_date_minute'] ) && is_numeric( $_POST['entry_date_minute'] ) &&
				checkdate( $_POST['entry_date_month'], $_POST['entry_date_day'], $_POST['entry_date_year'] ) &&
				$_POST['entry_date_hour'] <= 24 && $_POST['entry_date_hour'] >= 0 &&
				$_POST['entry_date_minute'] < 60 && $_POST['entry_date_minute'] >= 0
			) {
				$entry['entry_date'] = time_utc( mktime( $_POST['entry_date_hour'], $_POST['entry_date_minute'], 0,
					$_POST['entry_date_month'], $_POST['entry_date_day'], $_POST['entry_date_year'] ) );
			} else {
				$entry['entry_date'] = time_utc();
			}
			if( trim( html2txt( $entry['entry_content'] ) ) == '' ) $entry['entry_content'] = '';
			if( trim( html2txt( $entry['entry_extended'] ) ) == '' ) $entry['entry_extended'] = '';
			
			if ( isset( $_POST['link_id'] ) && is_numeric( $_POST['link_id'] ) ) {
				$sql = "SELECT link_id FROM " . TABLE_LINKS ." WHERE link_url = '' and link_id = '" . $db->escape( $_POST['link_id'] ) . "' LIMIT 0, 1;";
				$res = $db->query( $sql, __LINE__, __FILE__ );
				if( $db->numrows( $res) ) {
					$row = $db->fetch( $res );
					$db->free( $res );
					$entry['link_id'] = $row['link_id'];
				} else {
					$db->free( $res );
					$sql = "SELECT link_id FROM " . TABLE_LINKS ." WHERE link_url = '' ORDER BY link_id ASC LIMIT 0, 1;";
					$res = $db->query( $sql, __LINE__, __FILE__ );
					$row = $db->fetch( $res );
					$db->free( $res );
					$entry['link_id'] = $row['link_id'];
				}
			} else {
				$sql = "SELECT link_id FROM " . TABLE_LINKS ." WHERE link_url = '' ORDER BY link_id ASC LIMIT 0, 1;";
				$res = $db->query( $sql, __LINE__, __FILE__ );
				$row = $db->fetch( $res );
				$db->free( $res );
				$entry['link_id'] = $row['link_id'];
			}
			$plug->runhook( 'hook_admin_write_presave', $entry );
			if( !count( $entry_error ) ) {
				if ( $entry['entry_id'] != -1 ) {
					//
					// Update
					//
					$sql = "UPDATE
								" . TABLE_BLOG ."
							SET";
					if ( isset( $_POST['entry_publish'] ) ) $sql .= " entry_hidden = '" . $db->escape( $entry['entry_hidden']) . "',";
					$sql .=	"	entry_content = '" . $db->escape( $entry['entry_content'] ) . "',
								entry_extended = '" . $db->escape( $entry['entry_extended'] ) . "',
								entry_title = '" . $db->escape( $entry['entry_title'] ) . "',
								entry_date = '" .$db->escape( $entry['entry_date'] ) . "',
								link_id = '" . $db->escape( $entry['link_id'] ) . "',
								entry_hidden = '" . $db->escape( $entry['entry_hidden'] ) . "'
							WHERE
								entry_id = '" . $db->escape( $entry['entry_id'] ) . "';";
				} else {
					
					//
					// Save a new entry
					//
					$sql = "INSERT INTO " . TABLE_BLOG ."
								(
								 entry_title,
								 entry_content,
								 entry_extended,
								 user_id,
								 entry_hidden,
								 entry_date,
								 link_id
								)
							VALUES
								(
								 '" . $db->escape( $entry['entry_title'] ) . "',
								 '" . $db->escape( $entry['entry_content'] ) . "',
								 '" . $db->escape( $entry['entry_extended'] ) . "',
								 '" . $db->escape( $user->getuser_id() ) . "',
								 '" . $db->escape( $entry['entry_hidden'] ) . "',
								 '" . $db->escape( $entry['entry_date'] ) . "',
								 '" . $db->escape( $entry['link_id'] ) . "'
								);";
				}
				$db->query( $sql, __LINE__, __FILE__ );
				if ( $entry['entry_id'] == -1 ) {
					$sql = "SELECT entry_id FROM " . TABLE_BLOG ." ORDER BY entry_id DESC LIMIT 0, 1;";
					$res = $db->query( $sql, __LINE__, __FILE__ );
					$row = $db->fetch( $res );
					$db->free( $res );
					$entry['entry_id'] = $row['entry_id'];
				}
				
				$plug->runhook( 'hook_admin_write_saved', $entry['entry_id'] );
				
				$tpl->add( 'empty.tpl' );
				$tpl->fillin( 'S_CONTENT', $lang['admin_write_saved'] );
				
				if ( isset( $_POST['entry_publish'] ) ) {
					$publish_url = array(
						'site' => 'write',
						'action' => 'trackback',
						'entry_id' => $entry['entry_id']
					);
					$plug->runhook( 'hook_admin_write_publish_redirect', $entry['entry_id'] );
					header( 'Location: ' . aurl( $publish_url, false ) );
					die( '<a href="' . aurl( $publish_url ) . '">' . $lang['continue'] . '</a>' );
				}
			}
		}
		
		//
		// Load draft list
		//
		$sql = "SELECT
					entry_id,
					entry_title,
					entry_content,
					entry_extended
				FROM
					" . TABLE_BLOG ."
				WHERE
					user_id = '" . $user->getuser_id() . "' and
					entry_hidden = '1'
				ORDER BY
					entry_date DESC;";
		$res = $db->query( $sql, __LINE__, __FILE__ );
		if( $db->numrows( $res ) ){
			$tpl->add( 'write_drafts.tpl' );
			$tpl->part_seperate( 'E_WRITE_DRAFTS' );
			
			$i = 0;
			while ( $draft = $db->fetch( $res ) ) {
				$tpl->part_load();
				if ( $i == 0 ) {
					$css_table_row = 'yabs_table_row_dark';
					$i = 1;
				} else {
					$css_table_row = 'yabs_table_row_light';
					$i = 0;
				}
				
				$edit_url = array( 'site' => 'write', 'entry_id' => $draft['entry_id'] );			
				$delete_url = array( 
					'site' => 'entry_manage',
					'action' => 'delete', 
					'entry_id' => $draft['entry_id'],
					'yabsonce' => $user->getOnce(),
					'call' => 'write'
				);
	
				if ( empty( $draft['entry_title'] ) ) {
					if ( empty( $draft['entry_content'] ) ) {
						if ( empty( $draft['entry_extended'] ) ) {
							$title = $lang['admin_write_notitle'];
						} else {
							$title = substr( html2txt( $draft['entry_extended'] ), 0, 50 );
						}
					} else {
						$title = substr( html2txt( $draft['entry_content'] ), 0, 50 );
					}
				} else {
					$title = substr( html2txt( $draft['entry_title'] ), 0, 50 );
				}
				
				$plug->runhook( 'hook_admin_write_draft_fillin', $draft );
				
				$tpl->fillin_array( array(
					'L_DRAFT_DELETE_LINK' => aurl( $delete_url ),
					'S_DRAFT_TITLE' => $title,
					'I_DRAFT_DELETE_CONFIRM' => 'onclick="return confirm(\'' . $lang['admin_entry_delete_question'] . '\')""',
					'S_DRAFT_DELETE_TEXT' => $lang['delete'],
					'S_DRAFT_EDIT_TEXT' => $lang['edit'],
					'L_DRAFT_EDIT_LINK' => aurl( $edit_url ),
					'S_DRAFT_ID' => $draft['entry_id'],
					'S_CSS_TABLE_ROW' => $css_table_row,
				) );
				
			}
			$tpl->part_unite();
		}
		$db->free( $res );
		
		//
		// Load entry for editing
		//
		if ( !count( $entry_error ) && $entry['entry_id'] != -1 ) {
			$sql = "SELECT
						entry_id,
						entry_title,
						entry_content,
						entry_extended,
						entry_date,
						entry_hidden,
						link_id
					FROM
						" . TABLE_BLOG ."
					WHERE
						entry_id = '" . $db->escape( $entry['entry_id'] ) . "'";
			if( !$user->getRight('entry_other' ) ) $sql .= " and user_id = '" . $user->getuser_id() . "'";
			$sql .= "
					LIMIT
						0, 1;";
			$res = $db->query( $sql, __LINE__, __FILE__ );
			if ( $db->numrows( $res ) ) {
				$entry = array();
				$entry = $db->fetch( $res );
			}
			$db->free( $res );
		}
		
		$plug->runhook( 'hook_admin_write_edit_entry_loaded', $entry );
		
		// loading wysiwyg editor
		$spaw = new SpawEditor( 'entry_content', '' );
		$spaw->setLanguage( $lang['lang_short'], $lang['charset'] );
		$spaw->addToolbars( 'edit', 'font', 'plugins', 'format', 'insert' );
		$spaw->addPage( new SpawEditorPage( 'entry_content', $lang['admin_write_editor_content'], $entry['entry_content'] ) );
		$spaw->addPage( new SpawEditorPage( 'entry_extended', $lang['admin_write_editor_extended'], $entry['entry_extended'] ) );
		
		if ( $user->getRight( 'fm_upload' ) ) {
			//echo "upload";
			$spaw->setConfigValueElement( 'PG_SPAWFM_SETTINGS', 'allow_upload', true );
		}
		
		if ( $user->getRight( 'fm_modify' ) ) {
			//echo "modify";
			$spaw->setConfigValueElement( 'PG_SPAWFM_SETTINGS', 'allow_modify', true );
		}
		
		$tpl->add('write.tpl');
		
		$entry_date_month = "<select name=\"entry_date_month\">\n";
		for ( $i=1 ; $i<=12 ; $i++ ) {
			$entry_date_month .= "<option value=\"" . $i . "\"";
			if ( date( 'n', time_local( $entry['entry_date'] ) ) == $i ) $entry_date_month .= " selected=\"selected\"";
			$entry_date_month .= ">" . strftime( '%B', mktime(1, 1, 1, $i, 1, 1 ) ) . "</option>\n";
		}
		$entry_date_month .= "</select>\n";
		$entry_date_day = '<input type="text" name="entry_date_day" size="2" value="' . strftime('%d', time_local( $entry['entry_date'] ) ) . '" maxlength="2" />';
		$entry_date_year = '<input type="text" name="entry_date_year" size="4" value="' . strftime('%Y', time_local( $entry['entry_date'] ) ) . '" maxlength="4" />';
		$entry_date_hour = '<input type="text" name="entry_date_hour" size="2" value="' . strftime('%H', time_local( $entry['entry_date'] ) ) . '" maxlength="2" />';
		$entry_date_minute = '<input type="text" name="entry_date_minute" size="2" value="' . strftime('%M', time_local( $entry['entry_date'] ) ) . '" maxlength="2" />';
		
		$sql = "SELECT link_id, link_name FROM " . TABLE_LINKS ." WHERE link_url = '' ORDER BY link_id ASC;";
		$res = $db->query( $sql, __LINE__, __FILE__ );
		$entry_cat = '<select name="link_id">';
		while ( $row = $db->fetch( $res ) ) {
			if ( $entry['link_id'] == 0 ) $entry['link_id'] = $row['link_id'];
			$entry_cat .= '<option value="' . $row['link_id'] . '"';
			if ( $entry['link_id'] == $row['link_id'] ) $entry_cat .= ' selected="selected"';
			$entry_cat .= '>' . $row['link_name'] . '</option>';
		}
		$entry_cat .= '</select>';
		
		$plug->runhook( 'hook_admin_write_edit_fillin', $entry );
		
		if( $entry['entry_hidden'] == '0' ) {
			$tpl->fillin_array( array(
				'I_ENTRY_FORM_PUBLISH' => '',
				'I_ENTRY_FORM_STATUS_PUBLIC' => '<input type="radio" name="entry_hidden" value="0" checked="checked" />',
				'I_ENTRY_FORM_STATUS_DRAFT' => '<input type="radio" name="entry_hidden" value="1" />',
				'S_ENTRY_FORM_STATUS_PUBLIC' => $lang['admin_write_status_public'],
				'S_ENTRY_FORM_STATUS_DRAFT' => $lang['admin_write_status_draft'],
				'S_ENTRY_FORM_STATUS_TEXT' => $lang['admin_write_status_text'],
			) );
		}
		
		$url = array();
		$url['site'] = 'write';
		if( $entry['entry_id'] != -1 ) $url['entry_id'] = $entry['entry_id'];
		
		if( !empty( $entry_error['entry_title'] ) ) {
			$tpl->fillin_array( array(
				'I_ENTRY_FORM_TITLE_INPUT' => '<input type="text" name="entry_title" size="50" value="' . $entry['entry_title'] . '" class="yabs_form_error" />',
				'S_ENTRY_FORM_TITLE_ERROR' => $entry_error['entry_title'],
			) );
		} else {
			$tpl->fillin_array( array(
				'I_ENTRY_FORM_TITLE_INPUT' => '<input type="text" name="entry_title" size="50" value="' . $entry['entry_title'] . '" />',
				'S_ENTRY_FORM_TITLE_ERROR' => '',
			) );
		}
		
		if( !$user->getConfig( 'use_wysiwyg') ) {
			$editor = '<b>' . $lang['admin_write_editor_content'] . '</b><br /><textarea style="width: 100%" rows="20" name="entry_content">' . $entry['entry_content'] . '</textarea><br /><br />';
			$editor .= '<b>' . $lang['admin_write_editor_extended'] . '</b><br /><textarea style="width: 100%" rows="20" name="entry_extended">' . $entry['entry_extended'] . '</textarea>';
			$tpl->fillin( 'I_ENTRY_FORM_EDITOR', $editor );
		}
		
		$tpl->fillin_array( array(
			'I_ENTRY_FORM_EDITOR' => $spaw->getHtml(),
			'S_ENTRY_FORM_TITLE_TEXT' => $lang['title'] . ':',
			'S_ENTRY_FORM_CONTENT_TEXT' => $lang['admin_write_content'] . ':',
			'I_ENTRY_FORM_SAVE' => '<input type="submit" name="entry_save" value="' . $lang['save' ] . '" />',
			'I_ENTRY_FORM_PUBLISH' => '<input type="submit" name="entry_publish" value="' . $lang['admin_write_publish'] . '" />',
			'I_ENTRY_FORM_NEW' => '<input type="submit" name="entry_new" value="' . $lang['admin_write_new'] . '" />',
			'L_WRITE_ACTION' => aurl( $url ),
			'I_ENTRY_DATE_MONTH' => $entry_date_month,
			'I_ENTRY_DATE_YEAR' => $entry_date_year,
			'I_ENTRY_DATE_DAY' => $entry_date_day,
			'I_ENTRY_DATE_HOUR' => $entry_date_hour,
			'I_ENTRY_DATE_MINUTE' => $entry_date_minute,
			'I_ENTRY_CAT_INPUT' => $entry_cat,
			'S_ENTRY_CAT_TEXT' => $lang['category'] . ':',
			'I_ENTRY_FORM_STATUS_PUBLIC' => '',
			'I_ENTRY_FORM_STATUS_DRAFT' => '',
			'S_ENTRY_FORM_STATUS_PUBLIC' => '',
			'S_ENTRY_FORM_STATUS_DRAFT' => '',
			'S_ENTRY_FORM_STATUS_TEXT' => '',
			'S_ENTRY_DATE_TEXT' => $lang['date'] . ':',
		) );
	}
} else {
	$tpl->add( 'empty.tpl' );
	$tpl->fillin( 'S_CONTENT', $lang['admin_access_denied'] );
}

?>